/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain.ebs;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.terrain.ebs.Edge;

public class ConstantLatEdge
implements Edge {
    private Angle lat;
    private Angle startLon;
    private Angle endLon;

    public ConstantLatEdge(Angle angle, Angle angle2, Angle angle3) {
        this.lat = angle;
        this.startLon = angle2;
        this.endLon = angle3;
    }

    public LatLon arcLengthPointOnEdge(double d) {
        return this.pointOnEdge(d);
    }

    public Edge.EdgeType getEdgeType() {
        return Edge.EdgeType.ConstantLatitude;
    }

    public LatLon getStartPoint() {
        return new LatLon(this.lat, this.startLon);
    }

    public LatLon getEndPoint() {
        return new LatLon(this.lat, this.endLon);
    }

    public double maxLongitudeDegrees() {
        double d;
        double d2 = this.startLon.getDegrees();
        if (d2 > (d = this.endLon.getDegrees())) {
            return d2;
        }
        return d;
    }

    public LatLon pointOnEdge(double d) {
        return new LatLon(this.lat, this.startLon.multiply(1.0 - d).add(this.endLon.multiply(d)));
    }

    public Edge.EdgeType subdivide(Edge[] edgeArray) {
        Angle angle = Angle.midAngle(this.startLon, this.endLon);
        edgeArray[0] = new ConstantLatEdge(this.lat, this.startLon, angle);
        edgeArray[1] = new ConstantLatEdge(this.lat, angle, this.endLon);
        return Edge.EdgeType.ConstantLatitude;
    }

    public String toString() {
        return "Constant lat = " + this.lat.toString() + "; lon range: " + this.startLon.toString() + " to " + this.endLon.toString();
    }
}

