/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain.ebs;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.terrain.ebs.Edge;

public class ConstantLonEdge
implements Edge {
    private Angle startLat;
    private Angle endLat;
    private Angle lon;

    public ConstantLonEdge(Angle angle, Angle angle2, Angle angle3) {
        this.startLat = angle;
        this.endLat = angle2;
        this.lon = angle3;
    }

    public LatLon arcLengthPointOnEdge(double d) {
        return this.pointOnEdge(d);
    }

    public Edge.EdgeType getEdgeType() {
        return Edge.EdgeType.ConstantLongitude;
    }

    public LatLon getStartPoint() {
        return new LatLon(this.startLat, this.lon);
    }

    public LatLon getEndPoint() {
        return new LatLon(this.endLat, this.lon);
    }

    public double maxLongitudeDegrees() {
        return this.lon.getDegrees();
    }

    public LatLon pointOnEdge(double d) {
        return new LatLon(this.startLat.multiply(1.0 - d).add(this.endLat.multiply(d)), this.lon);
    }

    public Edge.EdgeType subdivide(Edge[] edgeArray) {
        Angle angle = Angle.midAngle(this.startLat, this.endLat);
        edgeArray[0] = new ConstantLonEdge(this.startLat, angle, this.lon);
        edgeArray[1] = new ConstantLonEdge(angle, this.endLat, this.lon);
        return Edge.EdgeType.ConstantLongitude;
    }

    public String toString() {
        return "Constant lon = " + this.lon.toString() + "; lat range: " + this.startLat.toString() + " to " + this.endLat.toString();
    }
}

