/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain.ebs;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.terrain.ebs.ConstantLatEdge;
import gov.nasa.worldwind.terrain.ebs.ConstantLonEdge;
import gov.nasa.worldwind.terrain.ebs.Edge;
import gov.nasa.worldwind.terrain.ebs.GreatEllipseEdge;
import gov.nasa.worldwind.util.Logging;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeBoundedSector
extends Sector {
    private Edge[] boundary = new Edge[4];
    private static Globe theGlobe = null;

    private EdgeBoundedSector(Angle angle, Angle angle2, Angle angle3, Angle angle4, Edge[] edgeArray) {
        super(angle, angle2, angle3, angle4);
        System.arraycopy(edgeArray, 0, this.boundary, 0, 4);
    }

    public LatLon averageOfCorners() {
        Angle angle = Angle.fromDegrees(0.0);
        Angle angle2 = Angle.fromDegrees(0.0);
        for (int i = 0; i < 4; ++i) {
            LatLon latLon = this.boundary[i].getStartPoint();
            angle = angle.add(latLon.getLatitude());
            angle2 = angle2.add(latLon.getLongitude());
        }
        return new LatLon(angle.multiply(0.25), angle2.multiply(0.25));
    }

    @Override
    public Vec4 computeCenterPoint(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = this.averageOfCorners();
        Angle angle = latLon.getLatitude();
        Angle angle2 = latLon.getLongitude();
        return globe.computePointFromPosition(angle, angle2, d * globe.getElevation(angle, angle2));
    }

    @Override
    public Vec4[] computeCornerPoints(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = new Vec4[4];
        for (int i = 0; i < 4; ++i) {
            LatLon latLon = this.boundary[i].getStartPoint();
            Angle angle = latLon.getLatitude();
            Angle angle2 = latLon.getLongitude();
            vec4Array[i] = globe.computePointFromPosition(angle, angle2, d * globe.getElevation(angle, angle2));
        }
        return vec4Array;
    }

    @Override
    public boolean containsDegrees(double d, double d2) {
        double d3 = Math.PI / 180;
        return this.containsRadians(d3 * d, d3 * d2);
    }

    @Override
    public boolean containsRadians(double d, double d2) {
        if (!super.containsRadians(d, d2)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (!(this.boundary[i] instanceof GreatEllipseEdge)) continue;
            GreatEllipseEdge greatEllipseEdge = (GreatEllipseEdge)this.boundary[i];
            Vec4 vec4 = greatEllipseEdge.getOutwardPointingNormal();
            Vec4 vec42 = greatEllipseEdge.getStartPointXYZ();
            Vec4 vec43 = theGlobe.computePointFromPosition(Angle.fromRadians(d), Angle.fromRadians(d2), 0.0);
            Vec4 vec44 = vec43.subtract3(vec42);
            if (!(vec4.dot3(vec44) > 0.0)) continue;
            return false;
        }
        return true;
    }

    private static EdgeBoundedSector fromEdges(Edge[] edgeArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < 4; ++i) {
            LatLon latLon = edgeArray[i].getStartPoint();
            double d5 = latLon.getLatitude().getDegrees();
            double d6 = latLon.getLongitude().getDegrees();
            if (i == 0) {
                d = d2 = d5;
                d3 = d4 = d6;
                continue;
            }
            if (d5 < d) {
                d = d5;
            } else if (d5 > d2) {
                d2 = d5;
            }
            if (d6 < d3) {
                d3 = d6;
                continue;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        return new EdgeBoundedSector(Angle.fromDegrees(d), Angle.fromDegrees(d2), Angle.fromDegrees(d3), Angle.fromDegrees(d4), edgeArray);
    }

    @Override
    public LatLon getCentroid() {
        return this.averageOfCorners();
    }

    public Edge getEdge(int n) {
        return this.boundary[n];
    }

    public static EdgeBoundedSector[] initialCubeMapping(Angle angle) {
        EdgeBoundedSector[] edgeBoundedSectorArray = new EdgeBoundedSector[6];
        Edge[] edgeArray = new Edge[4];
        Angle angle2 = Angle.fromDegrees(-angle.getDegrees());
        edgeArray[0] = new ConstantLonEdge(angle2, angle, Angle.NEG180);
        edgeArray[1] = new ConstantLatEdge(angle, Angle.NEG180, Angle.NEG90);
        edgeArray[2] = new ConstantLonEdge(angle, angle2, Angle.NEG90);
        edgeArray[3] = new ConstantLatEdge(angle2, Angle.NEG90, Angle.NEG180);
        edgeBoundedSectorArray[0] = EdgeBoundedSector.fromEdges(edgeArray);
        edgeArray[0] = new ConstantLonEdge(angle2, angle, Angle.NEG90);
        edgeArray[1] = new ConstantLatEdge(angle, Angle.NEG90, Angle.ZERO);
        edgeArray[2] = new ConstantLonEdge(angle, angle2, Angle.ZERO);
        edgeArray[3] = new ConstantLatEdge(angle2, Angle.ZERO, Angle.NEG90);
        edgeBoundedSectorArray[1] = EdgeBoundedSector.fromEdges(edgeArray);
        edgeArray[0] = new ConstantLonEdge(angle2, angle, Angle.ZERO);
        edgeArray[1] = new ConstantLatEdge(angle, Angle.ZERO, Angle.POS90);
        edgeArray[2] = new ConstantLonEdge(angle, angle2, Angle.POS90);
        edgeArray[3] = new ConstantLatEdge(angle2, Angle.POS90, Angle.ZERO);
        edgeBoundedSectorArray[2] = EdgeBoundedSector.fromEdges(edgeArray);
        edgeArray[0] = new ConstantLonEdge(angle2, angle, Angle.POS90);
        edgeArray[1] = new ConstantLatEdge(angle, Angle.POS90, Angle.POS180);
        edgeArray[2] = new ConstantLonEdge(angle, angle2, Angle.POS180);
        edgeArray[3] = new ConstantLatEdge(angle2, Angle.POS180, Angle.POS90);
        edgeBoundedSectorArray[3] = EdgeBoundedSector.fromEdges(edgeArray);
        edgeArray[0] = new ConstantLatEdge(angle2, Angle.POS180, Angle.POS90);
        edgeArray[1] = new ConstantLatEdge(angle2, Angle.POS90, Angle.ZERO);
        edgeArray[2] = new ConstantLatEdge(angle2, Angle.ZERO, Angle.NEG90);
        edgeArray[3] = new ConstantLatEdge(angle2, Angle.NEG90, Angle.NEG180);
        edgeBoundedSectorArray[4] = EdgeBoundedSector.fromEdges(edgeArray);
        edgeArray[0] = new ConstantLatEdge(angle, Angle.NEG180, Angle.NEG90);
        edgeArray[1] = new ConstantLatEdge(angle, Angle.NEG90, Angle.ZERO);
        edgeArray[2] = new ConstantLatEdge(angle, Angle.ZERO, Angle.POS90);
        edgeArray[3] = new ConstantLatEdge(angle, Angle.POS90, Angle.POS180);
        edgeBoundedSectorArray[5] = EdgeBoundedSector.fromEdges(edgeArray);
        return edgeBoundedSectorArray;
    }

    @Override
    public Iterator<LatLon> iterator() {
        return new Iterator<LatLon>(){
            private int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < 4;
            }

            @Override
            public LatLon next() {
                if (this.position > 3) {
                    throw new NoSuchElementException();
                }
                return EdgeBoundedSector.this.boundary[this.position++].getStartPoint();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void recordGlobe(Globe globe) {
        theGlobe = globe;
    }

    @Override
    public Sector[] subdivide() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (!(this.boundary[i] instanceof ConstantLatEdge)) continue;
            ++n;
        }
        if (n == 4) {
            return this.subdividePolarSector();
        }
        return this.subdivideNonPolarSector();
    }

    private EdgeBoundedSector[] subdivideNonPolarSector() {
        Edge[][] edgeArray = new Edge[4][2];
        Edge.EdgeType[] edgeTypeArray = new Edge.EdgeType[4];
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            edgeTypeArray[i] = this.boundary[i].subdivide(edgeArray[i]);
            if (edgeTypeArray[i] != Edge.EdgeType.GreatEllipse) continue;
            bl = true;
        }
        if (edgeTypeArray[0] != edgeTypeArray[2]) {
            bl = true;
        }
        if (bl) {
            return this.subdivideUsingGreatEllipses(edgeArray);
        }
        return this.subdivideUsingConstantLatLonEdges(edgeArray, edgeTypeArray);
    }

    private EdgeBoundedSector[] subdividePolarSector() {
        Edge[] edgeArray = new Edge[4];
        EdgeBoundedSector[] edgeBoundedSectorArray = new EdgeBoundedSector[4];
        for (int i = 0; i < 4; ++i) {
            LatLon latLon = this.boundary[i].getStartPoint();
            LatLon latLon2 = this.boundary[i].getEndPoint();
            Angle angle = Angle.POS90;
            if (latLon.getLatitude().getRadians() < 0.0) {
                angle = Angle.NEG90;
            }
            this.boundary[i].subdivide(edgeArray);
            edgeArray[2] = new ConstantLonEdge(latLon2.getLatitude(), angle, latLon2.getLongitude());
            edgeArray[3] = new ConstantLonEdge(angle, latLon.getLatitude(), latLon.getLongitude());
            edgeBoundedSectorArray[i] = EdgeBoundedSector.fromEdges(edgeArray);
        }
        return edgeBoundedSectorArray;
    }

    private EdgeBoundedSector[] subdivideUsingConstantLatLonEdges(Edge[][] edgeArray, Edge.EdgeType[] edgeTypeArray) {
        EdgeBoundedSector[] edgeBoundedSectorArray = new EdgeBoundedSector[4];
        LatLon latLon = this.getCentroid();
        Angle angle = latLon.getLatitude();
        Angle angle2 = latLon.getLongitude();
        Edge[] edgeArray2 = new Edge[4];
        int n = 3;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            edgeArray2[0] = edgeArray[n][1];
            edgeArray2[1] = edgeArray[n2][0];
            LatLon latLon2 = edgeArray2[1].getStartPoint();
            LatLon latLon3 = edgeArray2[1].getEndPoint();
            if (edgeTypeArray[n2] == Edge.EdgeType.ConstantLatitude) {
                edgeArray2[2] = new ConstantLonEdge(latLon3.getLatitude(), angle, angle2);
                edgeArray2[3] = new ConstantLatEdge(angle, angle2, latLon2.getLongitude());
            } else {
                edgeArray2[2] = new ConstantLatEdge(angle, latLon2.getLongitude(), angle2);
                edgeArray2[3] = new ConstantLonEdge(angle, latLon2.getLatitude(), angle2);
            }
            edgeBoundedSectorArray[i] = EdgeBoundedSector.fromEdges(edgeArray2);
            n = (n + 1) % 4;
            ++n2;
        }
        return edgeBoundedSectorArray;
    }

    private EdgeBoundedSector[] subdivideUsingGreatEllipses(Edge[][] edgeArray) {
        EdgeBoundedSector[] edgeBoundedSectorArray = new EdgeBoundedSector[4];
        LatLon[] latLonArray = new LatLon[4];
        for (int i = 0; i < 4; ++i) {
            latLonArray[i] = edgeArray[i][0].getEndPoint();
        }
        LatLon latLon = GreatEllipseEdge.findCentralPoint(theGlobe, latLonArray);
        Edge[] edgeArray2 = new Edge[4];
        int n = 3;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            edgeArray2[0] = edgeArray[n][1];
            edgeArray2[1] = edgeArray[n2][0];
            edgeArray2[2] = new GreatEllipseEdge(theGlobe, latLonArray[n2].getLatitude(), latLon.getLatitude(), latLonArray[n2].getLongitude(), latLon.getLongitude());
            edgeArray2[3] = new GreatEllipseEdge(theGlobe, latLon.getLatitude(), latLonArray[n].getLatitude(), latLon.getLongitude(), latLonArray[n].getLongitude());
            edgeBoundedSectorArray[i] = EdgeBoundedSector.fromEdges(edgeArray2);
            n = (n + 1) % 4;
            ++n2;
        }
        return edgeBoundedSectorArray;
    }

    @Override
    public String toString() {
        String string = "EdgeBoundedSector[" + super.toString() + ", Sector edges: ";
        for (int i = 0; i < 4; ++i) {
            string = string + ((Object)this.boundary[i]).toString();
            if (i == 3) continue;
            string = string + ", ";
        }
        return string + "]";
    }
}

