/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.NetworkStatus;
import gov.nasa.worldwind.util.WWIO;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class BasicNetworkStatus
extends AVListImpl
implements NetworkStatus {
    private static final long DEFAULT_TRY_AGAIN_INTERVAL = 60000L;
    private static final int DEFAULT_ATTEMPT_LIMIT = 10;
    private static final String[] networkTestSites = new String[]{"www.nasa.gov", "worldwind.arc.nasa.gov", "google.com", "microsoft.com", "yahoo.com"};
    private static final long NETWORK_STATUS_REPORT_INTERVAL = 60000L;
    private ConcurrentHashMap<String, HostInfo> hostMap = new ConcurrentHashMap();
    private AtomicLong tryAgainInterval = new AtomicLong(60000L);
    private AtomicInteger attemptLimit = new AtomicInteger(10);
    private boolean offlineMode;
    private AtomicLong lastUnavailableLogTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong lastAvailableLogTime = new AtomicLong(System.currentTimeMillis() + 1L);
    private AtomicLong lastNetworkCheckTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong lastNetworkStatusReportTime = new AtomicLong(0L);
    private AtomicBoolean lastNetworkUnavailableResult = new AtomicBoolean(false);

    public BasicNetworkStatus() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.OfflineMode", "false");
        this.offlineMode = string.startsWith("t") || string.startsWith("T");
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public void setOfflineMode(boolean bl) {
        this.offlineMode = bl;
    }

    public void setAttemptLimit(int n) {
        if (n < 1) {
            String string = Logging.getMessage("NetworkStatus.InvalidAttemptLimit");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attemptLimit.set(n);
    }

    public void setTryAgainInterval(long l) {
        if (l < 0L) {
            String string = Logging.getMessage("NetworkStatus.InvalidTryAgainInterval");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tryAgainInterval.set(l);
    }

    public int getAttemptLimit() {
        return this.attemptLimit.get();
    }

    public long getTryAgainInterval() {
        return this.tryAgainInterval.get();
    }

    public synchronized void logUnavailableHost(URL uRL) {
        if (this.offlineMode) {
            return;
        }
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = uRL.getHost();
        HostInfo hostInfo = this.hostMap.get(string);
        if (hostInfo != null) {
            if (!hostInfo.isUnavailable()) {
                hostInfo.logCount.incrementAndGet();
                if (hostInfo.isUnavailable()) {
                    this.firePropertyChange("gov.nasa.worldwind.util.NetworkStatus.HostUnavailable", null, uRL);
                }
            }
            hostInfo.lastLogTime.set(System.currentTimeMillis());
        } else {
            hostInfo = new HostInfo(this.attemptLimit.get(), this.tryAgainInterval.get());
            hostInfo.logCount.set(1);
            if (hostInfo.isUnavailable()) {
                this.firePropertyChange("gov.nasa.worldwind.util.NetworkStatus.HostUnavailable", null, uRL);
            }
            this.hostMap.put(string, hostInfo);
        }
        this.lastUnavailableLogTime.set(System.currentTimeMillis());
    }

    public synchronized void logAvailableHost(URL uRL) {
        if (this.offlineMode) {
            return;
        }
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = uRL.getHost();
        HostInfo hostInfo = this.hostMap.get(string);
        if (hostInfo != null) {
            this.hostMap.remove(string);
            this.firePropertyChange("gov.nasa.worldwind.util.NetworkStatus.HostAvailable", null, uRL);
        }
        this.lastAvailableLogTime.set(System.currentTimeMillis());
    }

    public synchronized boolean isHostUnavailable(URL uRL) {
        if (this.offlineMode) {
            return true;
        }
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = uRL.getHost();
        HostInfo hostInfo = this.hostMap.get(string);
        if (hostInfo == null) {
            return false;
        }
        if (hostInfo.isTimeToTryAgain()) {
            hostInfo.logCount.set(0);
            return false;
        }
        return hostInfo.isUnavailable();
    }

    public boolean isNetworkUnavailable() {
        return this.offlineMode || this.isNetworkUnavailable(5000L);
    }

    public synchronized boolean isNetworkUnavailable(long l) {
        if (this.offlineMode) {
            return true;
        }
        if (this.lastAvailableLogTime.get() > this.lastUnavailableLogTime.get()) {
            this.lastNetworkUnavailableResult.set(false);
            return this.lastNetworkUnavailableResult.get();
        }
        long l2 = System.currentTimeMillis();
        if (!this.lastNetworkUnavailableResult.get() && l2 - this.lastAvailableLogTime.get() < l) {
            return this.lastNetworkUnavailableResult.get();
        }
        if (l2 - this.lastNetworkCheckTime.get() < l) {
            return this.lastNetworkUnavailableResult.get();
        }
        this.lastNetworkCheckTime.set(l2);
        if (!this.isWorlWindServerUnavailable()) {
            this.lastNetworkUnavailableResult.set(false);
            return this.lastNetworkUnavailableResult.get();
        }
        for (String string : networkTestSites) {
            if (!BasicNetworkStatus.isHostReachable(string)) continue;
            this.lastNetworkUnavailableResult.set(false);
            return this.lastNetworkUnavailableResult.get();
        }
        if (l2 - this.lastNetworkStatusReportTime.get() > 60000L) {
            this.lastNetworkStatusReportTime.set(l2);
            String string = Logging.getMessage("NetworkStatus.NetworkUnreachable");
            Logging.logger().info(string);
        }
        this.lastNetworkUnavailableResult.set(true);
        return this.lastNetworkUnavailableResult.get();
    }

    public boolean isWorlWindServerUnavailable() {
        return this.offlineMode || !BasicNetworkStatus.isHostReachable("worldwind.arc.nasa.gov");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isHostReachable(String string) {
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = Logging.getMessage("NetworkStatus.UnreachableTestHost", string);
            Logging.logger().fine(string2);
            return false;
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("NetworkStatus.ExceptionTestingHost", string);
            Logging.logger().info(string3);
            return false;
        }
        URLConnection uRLConnection = null;
        try {
            URL uRL = new URL("http://" + string);
            Proxy proxy = WWIO.configureProxy();
            uRLConnection = proxy != null ? uRL.openConnection(proxy) : uRL.openConnection();
            uRLConnection.setConnectTimeout(2000);
            String string4 = uRLConnection.getContentType();
            if (string4 != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            String string5 = Logging.getMessage("NetworkStatus.ExceptionTestingHost", string);
            Logging.logger().info(string5);
        }
        finally {
            if (uRLConnection != null && uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
        return false;
    }

    private static class HostInfo {
        private final long tryAgainInterval;
        private final int attemptLimit;
        private AtomicInteger logCount = new AtomicInteger();
        private AtomicLong lastLogTime = new AtomicLong();

        private HostInfo(int n, long l) {
            this.lastLogTime.set(System.currentTimeMillis());
            this.logCount.set(1);
            this.tryAgainInterval = l;
            this.attemptLimit = n;
        }

        private boolean isUnavailable() {
            return this.logCount.get() >= this.attemptLimit;
        }

        private boolean isTimeToTryAgain() {
            return System.currentTimeMillis() - this.lastLogTime.get() >= this.tryAgainInterval;
        }
    }
}

