/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Sector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTree<T, C> {
    protected Controller<T, C> controller;

    public DecisionTree(Controller<T, C> controller) {
        this.controller = controller;
    }

    public void traverse(T t, C c) {
        if (!this.controller.isVisible(t, c)) {
            return;
        }
        if (this.controller.isTerminal(t, c)) {
            return;
        }
        for (T t2 : this.controller.split(t, c)) {
            this.traverse(t2, c);
        }
    }

    public static void main(String[] stringArray) {
        DecisionTree<Sector, Sector> decisionTree = new DecisionTree<Sector, Sector>(new Controller<Sector, Sector>(){

            @Override
            public boolean isVisible(Sector sector, Sector sector2) {
                return sector.intersects(sector2);
            }

            @Override
            public boolean isTerminal(Sector sector, Sector sector2) {
                return sector.getDeltaLat().degrees < 1.0;
            }

            public Sector[] split(Sector sector, Sector sector2) {
                return sector.subdivide();
            }
        });
        int n = 10000;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            decisionTree.traverse(Sector.FULL_SPHERE, Sector.fromDegrees(0.0, 40.0, 0.0, 40.0));
        }
        System.out.println((double)(System.currentTimeMillis() - l) / (double)n + " ms");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Controller<T, C> {
        public boolean isVisible(T var1, C var2);

        public boolean isTerminal(T var1, C var2);

        public T[] split(T var1, C var2);
    }
}

