/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTree
implements Iterable<File> {
    private File root;
    private int mode = 3;
    public static final int FILES_ONLY = 1;
    public static final int DIRECTORIES_ONLY = 2;
    public static final int FILES_AND_DIRECTORIES = 3;

    public FileTree() {
        this(null);
    }

    public FileTree(File file) {
        this.root = file;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File file) {
        this.root = file;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        if (!FileTree.validate(n)) {
            throw new IllegalArgumentException("mode:" + n);
        }
        this.mode = n;
    }

    public List<File> asList() {
        return this.asList(null);
    }

    public List<File> asList(FileFilter fileFilter) {
        return FileTree.makeList(this.root, fileFilter, this.mode);
    }

    @Override
    public Iterator<File> iterator() {
        return this.iterator(null);
    }

    public Iterator<File> iterator(FileFilter fileFilter) {
        return new FileTreeIterator(this.root, fileFilter, this.mode);
    }

    private static List<File> makeList(File file, FileFilter fileFilter, int n) {
        LinkedList<File> linkedList = new LinkedList<File>();
        if (FileTree.isDirectory(file)) {
            linkedList.offer(file);
        }
        LinkedList<File> linkedList2 = new LinkedList<File>();
        while (linkedList.peek() != null) {
            FileTree.expand((File)linkedList.poll(), fileFilter, n, linkedList2, linkedList);
        }
        return linkedList2;
    }

    private static void expand(File file, FileFilter fileFilter, int n, Queue<File> queue, Queue<File> queue2) {
        File[] fileArray;
        if (file != null && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (file2 == null) continue;
                boolean bl = file2.isDirectory();
                if (bl) {
                    queue2.offer(file2);
                }
                if ((bl || !FileTree.isDisplayFiles(n)) && (!bl || !FileTree.isDisplayDirectories(n)) || fileFilter != null && !fileFilter.accept(file2)) continue;
                queue.offer(file2);
            }
        }
    }

    private static boolean isDirectory(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    private static boolean isDisplayFiles(int n) {
        return n == 1 || n == 3;
    }

    private static boolean isDisplayDirectories(int n) {
        return n == 2 || n == 3;
    }

    private static boolean validate(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileTreeIterator
    implements Iterator<File> {
        private final Queue<File> dirs = new LinkedList<File>();
        private final Queue<File> files = new LinkedList<File>();
        private final FileFilter fileFilter;
        private final int mode;

        private FileTreeIterator(File file, FileFilter fileFilter, int n) {
            if (FileTree.isDirectory(file)) {
                this.dirs.offer(file);
            }
            this.fileFilter = fileFilter;
            this.mode = n;
        }

        @Override
        public boolean hasNext() {
            if (this.files.peek() == null) {
                this.expandUntilFilesFound();
            }
            return this.files.peek() != null;
        }

        @Override
        public File next() {
            if (this.files.peek() == null) {
                this.expandUntilFilesFound();
                if (this.files.peek() == null) {
                    throw new NoSuchElementException();
                }
            }
            return this.files.poll();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void expandUntilFilesFound() {
            while (this.dirs.peek() != null && this.files.peek() == null) {
                this.expand(this.dirs.poll());
            }
        }

        private void expand(File file) {
            if (file != null) {
                FileTree.expand(file, this.fileFilter, this.mode, this.files, this.dirs);
            }
        }
    }
}

