/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.util.HashMap;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryBuilder {
    public static final int OUTSIDE = 0;
    public static final int INSIDE = 1;
    public static final int COUNTER_CLOCKWISE = 0;
    public static final int CLOCKWISE = 1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    private int orientation = 0;
    private final GLU glu = new GLU();
    private static final int ICOSAHEDRON_INDEX_COUNT = 60;
    private static final int ICOSAHEDRON_VERTEX_COUNT = 12;
    private static final float X = 0.5257311f;
    private static final float Z = 0.8506508f;
    private static float[] icosahedronVertexArray = new float[]{-0.5257311f, 0.0f, 0.8506508f, 0.5257311f, 0.0f, 0.8506508f, -0.5257311f, 0.0f, -0.8506508f, 0.5257311f, 0.0f, -0.8506508f, 0.0f, 0.8506508f, 0.5257311f, 0.0f, 0.8506508f, -0.5257311f, 0.0f, -0.8506508f, 0.5257311f, 0.0f, -0.8506508f, -0.5257311f, 0.8506508f, 0.5257311f, 0.0f, -0.8506508f, 0.5257311f, 0.0f, 0.8506508f, -0.5257311f, 0.0f, -0.8506508f, -0.5257311f, 0.0f};
    private static int[] icosahedronIndexArray = new int[]{1, 4, 0, 4, 9, 0, 4, 5, 9, 8, 5, 4, 1, 8, 4, 1, 10, 8, 10, 3, 8, 8, 3, 5, 3, 2, 5, 3, 7, 2, 3, 10, 7, 10, 6, 7, 6, 11, 7, 6, 0, 11, 6, 1, 0, 10, 1, 6, 11, 0, 9, 2, 11, 9, 5, 2, 9, 11, 2, 7};

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public IndexedTriangleArray tessellateSphere(float f, int n) {
        int n2;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[60];
        float[] fArray = new float[36];
        System.arraycopy(icosahedronIndexArray, 0, nArray, 0, 60);
        System.arraycopy(icosahedronVertexArray, 0, fArray, 0, 36);
        if (this.orientation == 1) {
            for (int i = 0; i < 60; i += 3) {
                n2 = nArray[i];
                nArray[i] = nArray[i + 2];
                nArray[i + 2] = n2;
            }
        }
        IndexedTriangleArray indexedTriangleArray = new IndexedTriangleArray(60, nArray, 12, fArray);
        for (n2 = 0; n2 < n; ++n2) {
            this.subdivideIndexedTriangleArray(indexedTriangleArray);
            fArray = indexedTriangleArray.getVertices();
            for (int i = 0; i < indexedTriangleArray.vertexCount; ++i) {
                this.norm3AndSet(fArray, 3 * i);
            }
        }
        fArray = indexedTriangleArray.getVertices();
        for (n2 = 0; n2 < indexedTriangleArray.vertexCount; ++n2) {
            this.mul3AndSet(fArray, 3 * n2, f);
        }
        return indexedTriangleArray;
    }

    public int getCylinderVertexCount(int n, int n2) {
        return n * (n2 + 1);
    }

    public int getCylinderIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getCylinderOutlineIndexCount(int n, int n2) {
        return n * 4;
    }

    public int getCylinderDrawMode() {
        return 5;
    }

    public int getCylinderOutlineDrawMode() {
        return 1;
    }

    public void makeCylinderVertices(float f, float f2, int n, int n2, float[] fArray) {
        int n3 = this.getCylinderVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f3 = (float)n2 != 0.0f ? f2 / (float)n2 : 0.0f;
        float f4 = (float)Math.PI * 2 / (float)n;
        for (int i = 0; i < n; ++i) {
            float f5 = (float)i * f4;
            float f6 = (float)Math.sin(f5);
            float f7 = (float)Math.cos(f5);
            float f8 = 0.0f;
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                fArray[n5] = f6 * f;
                fArray[n5 + 1] = f7 * f;
                fArray[n5 + 2] = f8;
                f8 += f3;
            }
        }
    }

    public void makeCylinderNormals(int n, int n2, float[] fArray) {
        int n3 = this.getCylinderVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = (float)Math.PI * 2 / (float)n;
        float f2 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[3];
        for (int i = 0; i < n; ++i) {
            float f3 = (float)i * f;
            float f4 = (float)Math.sin(f3);
            float f5 = (float)Math.cos(f3);
            fArray2[0] = f4 * f2;
            fArray2[1] = f5 * f2;
            fArray2[2] = 0.0f;
            this.norm3AndSet(fArray2, 0);
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makeCylinderIndices(int n, int n2, int[] nArray) {
        int n3 = this.getCylinderIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                n5 = this.orientation == 1 ? i + 1 : i;
                nArray[n4++] = n5;
                nArray[n4++] = n5;
            }
            for (int j = 0; j <= n; ++j) {
                n5 = j == n ? i : i + j * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5 + 1;
                    nArray[n4++] = n5;
                    continue;
                }
                nArray[n4++] = n5;
                nArray[n4++] = n5 + 1;
            }
        }
    }

    public void makeCylinderOutlineIndices(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        int n5 = this.getCylinderOutlineIndexCount(n, n2);
        if (n5 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * (n2 + 1);
            nArray[n6++] = n3;
            nArray[n6++] = n4 != n - 1 ? n3 + n2 + 1 : 0;
        }
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * (n2 + 1) + n2;
            nArray[n6++] = n3;
            nArray[n6++] = n4 != n - 1 ? n3 + n2 + 1 : n2;
        }
    }

    public int getPartialCylinderVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    public int getPartialCylinderIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getPartialCylinderOutlineIndexCount(int n, int n2) {
        return n * 4;
    }

    public int getPartialCylinderDrawMode() {
        return 5;
    }

    public int getPartialCylinderOutlineDrawMode() {
        return 1;
    }

    public void makePartialCylinderVertices(float f, float f2, int n, int n2, float f3, float f4, float[] fArray) {
        int n3 = this.getPartialCylinderVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = (float)n2 != 0.0f ? f2 / (float)n2 : 0.0f;
        float f6 = f4 / (float)n;
        for (int i = 0; i <= n; ++i) {
            float f7 = (float)i * f6 + f3;
            float f8 = (float)Math.sin(f7);
            float f9 = (float)Math.cos(f7);
            float f10 = 0.0f;
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                fArray[n5] = f8 * f;
                fArray[n5 + 1] = f9 * f;
                fArray[n5 + 2] = f10;
                f10 += f5;
            }
        }
    }

    public void makePartialCylinderNormals(float f, float f2, int n, int n2, float f3, float f4, float[] fArray) {
        int n3 = this.getPartialCylinderVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = f4 / (float)n;
        float f6 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[3];
        for (int i = 0; i <= n; ++i) {
            float f7 = (float)i * f5 + f3;
            float f8 = (float)Math.sin(f7);
            float f9 = (float)Math.cos(f7);
            fArray2[0] = f8 * f6;
            fArray2[1] = f9 * f6;
            fArray2[2] = 0.0f;
            this.norm3AndSet(fArray2, 0);
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makePartialCylinderIndices(int n, int n2, int[] nArray) {
        int n3 = this.getPartialCylinderIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                if (this.orientation == 1) {
                    n5 = i + n * (n2 + 1);
                    nArray[n4++] = n5 - 1;
                    n5 = i + 1;
                    nArray[n4++] = n5;
                } else {
                    n5 = i + n * (n2 + 1);
                    nArray[n4++] = n5;
                    n5 = i;
                    nArray[n4++] = n5;
                }
            }
            for (int j = 0; j <= n; ++j) {
                n5 = i + j * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5 + 1;
                    nArray[n4++] = n5;
                    continue;
                }
                nArray[n4++] = n5;
                nArray[n4++] = n5 + 1;
            }
        }
    }

    public void makePartialCylinderOutlineIndices(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        int n5 = this.getPartialCylinderOutlineIndexCount(n, n2);
        if (n5 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * (n2 + 1);
            nArray[n6++] = n3;
            nArray[n6++] = n3 + n2 + 1;
        }
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * (n2 + 1) + n2;
            nArray[n6++] = n3;
            nArray[n6++] = n3 + n2 + 1;
        }
    }

    public int getDiskVertexCount(int n, int n2) {
        return n * (n2 + 1);
    }

    public int getDiskIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getDiskDrawMode() {
        return 5;
    }

    public void makeDiskVertices(float f, float f2, int n, int n2, float[] fArray) {
        int n3 = this.getDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f3 = (float)Math.PI * 2 / (float)n;
        float f4 = (f2 - f) / (float)n2;
        for (int i = 0; i < n; ++i) {
            float f5 = (float)i * f3;
            float f6 = (float)Math.sin(f5);
            float f7 = (float)Math.cos(f5);
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                float f8 = f + (float)j * f4;
                fArray[n5] = f8 * f6;
                fArray[n5 + 1] = f8 * f7;
                fArray[n5 + 2] = 0.0f;
            }
        }
    }

    public void makeDiskNormals(int n, int n2, float[] fArray) {
        int n3 = this.getDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f * f};
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makeDiskVertexNormals(float f, float f2, int n, int n2, float[] fArray, float[] fArray2) {
        int n3 = this.getDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.SourceVertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f3 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        for (int i = 0; i <= n2; ++i) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (i == 0 || i == n2) {
                if (i == 0 && f == 0.0f) {
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    for (n9 = 0; n9 < n; ++n9) {
                        n8 = i + n9 * (n2 + 1);
                        n7 = i + (n9 + 1) * (n2 + 1);
                        if (n9 == n - 1) {
                            n7 = i;
                        }
                        n6 = n8 + 1;
                        this.facenorm(fArray, n8, n7 + 1, n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    this.mul3AndSet(fArray3, 0, f3);
                    this.norm3AndSet(fArray3, 0);
                    for (n9 = 0; n9 < n; ++n9) {
                        n8 = i + n9 * (n2 + 1);
                        System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
                    }
                    continue;
                }
                for (n9 = 0; n9 < n; ++n9) {
                    n8 = i + n9 * (n2 + 1);
                    n7 = i + (n9 - 1) * (n2 + 1);
                    n6 = i + (n9 + 1) * (n2 + 1);
                    if (n9 == 0) {
                        n7 = i + (n - 1) * (n2 + 1);
                    } else if (n9 == n - 1) {
                        n6 = i;
                    }
                    n5 = i == 0 ? n8 + 1 : n8 - 1;
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    if (i == 0) {
                        this.facenorm(fArray, n8, n6, n5, fArray5);
                    } else {
                        this.facenorm(fArray, n8, n5, n6, fArray5);
                    }
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    if (i == 0) {
                        this.facenorm(fArray, n8, n5, n7, fArray5);
                    } else {
                        this.facenorm(fArray, n8, n7, n5, fArray5);
                    }
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.mul3AndSet(fArray3, 0, f3);
                    this.norm3AndSet(fArray3, 0);
                    System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
                }
                continue;
            }
            for (n9 = 0; n9 < n; ++n9) {
                n8 = i + n9 * (n2 + 1);
                n7 = i + (n9 - 1) * (n2 + 1);
                n6 = i + (n9 + 1) * (n2 + 1);
                if (n9 == 0) {
                    n7 = i + (n - 1) * (n2 + 1);
                } else if (n9 == n - 1) {
                    n6 = i;
                }
                n5 = n8 - 1;
                int n10 = n8 + 1;
                System.arraycopy(fArray4, 0, fArray3, 0, 3);
                this.facenorm(fArray, n8, n7, n7 - 1, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n7 - 1, n5, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n5, n6 - 1, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n6 - 1, n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n6, n6 + 1, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n6 + 1, n10, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n10, n7 + 1, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n7 + 1, n7, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.mul3AndSet(fArray3, 0, f3);
                this.norm3AndSet(fArray3, 0);
                System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
            }
        }
    }

    public void makeDiskIndices(int n, int n2, int[] nArray) {
        int n3 = this.getDiskIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                if (this.orientation == 1) {
                    n5 = i;
                    nArray[n4++] = n5;
                    nArray[n4++] = n5;
                } else {
                    n5 = i - 1;
                    nArray[n4++] = n5;
                    n5 = i + 1;
                    nArray[n4++] = n5;
                }
            }
            for (int j = 0; j <= n; ++j) {
                n5 = j == n ? i : i + j * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5;
                    nArray[n4++] = n5 + 1;
                    continue;
                }
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5;
            }
        }
    }

    public int getPartialDiskVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    public int getPartialDiskIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getPartialDiskDrawMode() {
        return 5;
    }

    public void makePartialDiskVertices(float f, float f2, int n, int n2, float f3, float f4, float[] fArray) {
        int n3 = this.getPartialDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = f4 / (float)n;
        float f6 = (f2 - f) / (float)n2;
        for (int i = 0; i <= n; ++i) {
            float f7 = (float)i * f5 + f3;
            float f8 = (float)Math.sin(f7);
            float f9 = (float)Math.cos(f7);
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                float f10 = f + (float)j * f6;
                fArray[n5] = f10 * f8;
                fArray[n5 + 1] = f10 * f9;
                fArray[n5 + 2] = 0.0f;
            }
        }
    }

    public void makePartialDiskNormals(int n, int n2, float[] fArray) {
        int n3 = this.getPartialDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f * f};
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makePartialDiskVertexNormals(float f, float f2, int n, int n2, float f3, float f4, float[] fArray, float[] fArray2) {
        int n3 = this.getPartialDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.SourceVertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        for (int i = 0; i <= n2; ++i) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (i == 0 || i == n2) {
                if (i == 0 && f == 0.0f) {
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    for (n9 = 0; n9 < n; ++n9) {
                        n8 = i + n9 * (n2 + 1);
                        n7 = i + (n9 + 1) * (n2 + 1);
                        n6 = n8 + 1;
                        this.facenorm(fArray, n8, n7 + 1, n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    this.mul3AndSet(fArray3, 0, f5);
                    this.norm3AndSet(fArray3, 0);
                    for (n9 = 0; n9 <= n; ++n9) {
                        n8 = i + n9 * (n2 + 1);
                        System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
                    }
                    continue;
                }
                for (n9 = 0; n9 <= n; ++n9) {
                    n8 = i + n9 * (n2 + 1);
                    n5 = i == 0 ? n8 + 1 : n8 - 1;
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    if (n9 > 0) {
                        n7 = i + (n9 - 1) * (n2 + 1);
                        if (i == 0) {
                            this.facenorm(fArray, n8, n5, n7, fArray5);
                        } else {
                            this.facenorm(fArray, n8, n7, n5, fArray5);
                        }
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    if (n9 < n) {
                        n6 = i + (n9 + 1) * (n2 + 1);
                        if (i == 0) {
                            this.facenorm(fArray, n8, n6, n5, fArray5);
                        } else {
                            this.facenorm(fArray, n8, n5, n6, fArray5);
                        }
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    this.mul3AndSet(fArray3, 0, f5);
                    this.norm3AndSet(fArray3, 0);
                    System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
                }
                continue;
            }
            for (n9 = 0; n9 <= n; ++n9) {
                n8 = i + n9 * (n2 + 1);
                n5 = n8 - 1;
                int n10 = n8 + 1;
                System.arraycopy(fArray4, 0, fArray3, 0, 3);
                if (n9 > 0) {
                    n7 = i + (n9 - 1) * (n2 + 1);
                    this.facenorm(fArray, n8, n7, n7 - 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n7 - 1, n5, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n10, n7 + 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n7 + 1, n7, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                }
                if (n9 < n) {
                    n6 = i + (n9 + 1) * (n2 + 1);
                    this.facenorm(fArray, n8, n5, n6 - 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n6 - 1, n6, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n6, n6 + 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n6 + 1, n10, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                }
                this.mul3AndSet(fArray3, 0, f5);
                this.norm3AndSet(fArray3, 0);
                System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
            }
        }
    }

    public void makePartialDiskIndices(int n, int n2, int[] nArray) {
        int n3 = this.getPartialDiskIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                if (this.orientation == 1) {
                    n5 = i + n * (n2 + 1);
                    nArray[n4++] = n5;
                    n5 = i;
                    nArray[n4++] = n5;
                } else {
                    n5 = i - 1 + n * (n2 + 1);
                    nArray[n4++] = n5;
                    n5 = i;
                    nArray[n4++] = n5 + 1;
                }
            }
            for (int j = 0; j <= n; ++j) {
                n5 = i + j * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5;
                    nArray[n4++] = n5 + 1;
                    continue;
                }
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5;
            }
        }
    }

    public int getRadialWallVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    public int getRadialWallIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getRadialWallOutlineIndexCount(int n, int n2) {
        return n * 4;
    }

    public int getRadialWallDrawMode() {
        return 5;
    }

    public int getRadialWallOutlineDrawMode() {
        return 1;
    }

    public void makeRadialWallVertices(float f, float f2, float f3, float f4, int n, int n2, float[] fArray) {
        int n3 = this.getRadialWallVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = f4;
        float f6 = (float)Math.sin(f5);
        float f7 = (float)Math.cos(f5);
        float f8 = 0.0f;
        float f9 = (float)n2 != 0.0f ? f3 / (float)n2 : 0.0f;
        float f10 = (f2 - f) / (float)n;
        for (int i = 0; i <= n2; ++i) {
            for (int j = 0; j <= n; ++j) {
                int n5 = j + i * (n + 1);
                n5 = 3 * n5;
                float f11 = f + (float)j * f10;
                fArray[n5] = f11 * f6;
                fArray[n5 + 1] = f11 * f7;
                fArray[n5 + 2] = f8;
            }
            f8 += f9;
        }
    }

    public void makeRadialWallNormals(float f, float f2, float f3, float f4, int n, int n2, float[] fArray) {
        int n3 = this.getRadialWallVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = f4;
        float f6 = (float)Math.cos(f5);
        float f7 = (float)(-Math.sin(f5));
        float f8 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[]{f6 * f8, f7 * f8, 0.0f};
        this.norm3AndSet(fArray2, 0);
        for (int i = 0; i <= n2; ++i) {
            for (int j = 0; j <= n; ++j) {
                int n5 = j + i * (n + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makeRadialWallIndices(int n, int n2, int[] nArray) {
        int n3 = this.getRadialWallIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                if (this.orientation == 1) {
                    n5 = n + i * (n + 1);
                    nArray[n4++] = n5;
                    n5 = i * (n + 1);
                    nArray[n4++] = n5;
                } else {
                    n5 = n + (i - 1) * (n + 1);
                    nArray[n4++] = n5;
                    n5 = (i + 1) * (n + 1);
                    nArray[n4++] = n5;
                }
            }
            for (int j = 0; j <= n; ++j) {
                n5 = j + i * (n + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5;
                    nArray[n4++] = n5 + (n + 1);
                    continue;
                }
                nArray[n4++] = n5 + (n + 1);
                nArray[n4++] = n5;
            }
        }
    }

    public void makeRadialWallOutlineIndices(int n, int n2, int[] nArray) {
        int n3;
        int n4 = this.getRadialWallOutlineIndexCount(n, n2);
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            n3 = n6++;
            nArray[n5++] = n3;
            nArray[n5++] = n3 + 1;
        }
        for (n6 = 0; n6 < n; ++n6) {
            n3 = n6 + n2 * (n + 1);
            nArray[n5++] = n3;
            nArray[n5++] = n3 + 1;
        }
    }

    public int getLongCylinderVertexCount(int n, int n2, int n3) {
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        return n4 * (n3 + 1);
    }

    public int getLongCylinderIndexCount(int n, int n2, int n3) {
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        return n3 * 2 * (n4 + 1) + 2 * (n3 - 1);
    }

    public int getLongCylinderOutlineIndexCount(int n, int n2, int n3) {
        return (n + n2) * 2 * 4;
    }

    public int getLongCylinderDrawMode() {
        return 5;
    }

    public int getLongCylinderOutlineDrawMode() {
        return 1;
    }

    public void makeLongCylinderVertices(float f, float f2, float f3, int n, int n2, int n3, float[] fArray) {
        int n4 = this.getLongCylinderVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " stacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f4 = (float)Math.PI / (float)n;
        float f5 = f2 / (float)n2;
        float f6 = (float)n3 != 0.0f ? f3 / (float)n3 : 0.0f;
        float f7 = 0.0f;
        int n6 = 0;
        for (int i = 0; i <= n3; ++i) {
            float f8;
            float f9;
            float f10;
            int n7;
            for (n7 = 0; n7 <= n; ++n7) {
                f10 = (float)n7 * f4 + 4.712389f;
                f9 = (float)Math.sin(f10);
                f8 = (float)Math.cos(f10);
                fArray[n6++] = f9 * f;
                fArray[n6++] = f8 * f + f2;
                fArray[n6++] = f7;
            }
            for (n7 = n2 - 1; n7 >= 1; --n7) {
                fArray[n6++] = f;
                fArray[n6++] = (float)n7 * f5;
                fArray[n6++] = f7;
            }
            for (n7 = 0; n7 <= n; ++n7) {
                f10 = (float)n7 * f4 + 1.5707964f;
                f9 = (float)Math.sin(f10);
                f8 = (float)Math.cos(f10);
                fArray[n6++] = f9 * f;
                fArray[n6++] = f8 * f;
                fArray[n6++] = f7;
            }
            for (n7 = 1; n7 < n2; ++n7) {
                fArray[n6++] = -f;
                fArray[n6++] = (float)n7 * f5;
                fArray[n6++] = f7;
            }
            f7 += f6;
        }
    }

    public void makeLongCylinderNormals(int n, int n2, int n3, float[] fArray) {
        int n4 = this.getLongCylinderVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " stacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = (float)Math.PI / (float)n;
        float f2 = this.orientation == 0 ? 1.0f : -1.0f;
        int n6 = 0;
        for (int i = 0; i <= n3; ++i) {
            float f3;
            float f4;
            float f5;
            int n7;
            for (n7 = 0; n7 <= n; ++n7) {
                f5 = (float)n7 * f + 4.712389f;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                fArray[n6++] = f4 * f2;
                fArray[n6++] = f3 * f2;
                fArray[n6++] = 0.0f;
            }
            for (n7 = n2 - 1; n7 >= 1; --n7) {
                fArray[n6++] = 1.0f * f2;
                fArray[n6++] = 0.0f;
                fArray[n6++] = 0.0f;
            }
            for (n7 = 0; n7 <= n; ++n7) {
                f5 = (float)n7 * f + 1.5707964f;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                fArray[n6++] = f4 * f2;
                fArray[n6++] = f3 * f2;
                fArray[n6++] = 0.0f;
            }
            for (n7 = 1; n7 < n2; ++n7) {
                fArray[n6++] = -1.0f * f2;
                fArray[n6++] = 0.0f;
                fArray[n6++] = 0.0f;
            }
        }
    }

    public void makeLongCylinderIndices(int n, int n2, int n3, int[] nArray) {
        int n4 = this.getLongCylinderIndexCount(n, n2, n3);
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " stacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n5 = 2 * (n + 1) + 2 * (n2 - 1);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7;
            if (i != 0) {
                if (this.orientation == 1) {
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7;
                    n7 = i * n5;
                    nArray[n6++] = n7;
                } else {
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7 + n5;
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7;
                }
            }
            for (int j = 0; j <= n5; ++j) {
                n7 = j == n5 ? i * n5 : j + i * n5;
                if (this.orientation == 1) {
                    nArray[n6++] = n7 + n5;
                    nArray[n6++] = n7;
                    continue;
                }
                nArray[n6++] = n7;
                nArray[n6++] = n7 + n5;
            }
        }
    }

    public void makeLongCylinderOutlineIndices(int n, int n2, int n3, int[] nArray) {
        int n4;
        int n5;
        int n6 = this.getLongCylinderOutlineIndexCount(n, n2, n3);
        if (n6 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " stacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n6) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n7 = 2 * (n + 1) + 2 * (n2 - 1);
        int n8 = 0;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n5;
            nArray[n8++] = n4;
            nArray[n8++] = n5 != n7 - 1 ? n4 + 1 : 0;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n5 + n7 * n3;
            nArray[n8++] = n4;
            nArray[n8++] = n5 != n7 - 1 ? n4 + 1 : n7 * n3;
        }
    }

    public int getLongDiskVertexCount(int n, int n2, int n3) {
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        return n4 * (n3 + 1);
    }

    public int getLongDiskIndexCount(int n, int n2, int n3) {
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        return n3 * 2 * (n4 + 1) + 2 * (n3 - 1);
    }

    public int getLongDiskDrawMode() {
        return 5;
    }

    public void makeLongDiskVertices(float f, float f2, float f3, int n, int n2, int n3, float[] fArray) {
        int n4 = this.getLongDiskVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " loops=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f4 = f3 / (float)n2;
        float f5 = (float)Math.PI / (float)n;
        float f6 = (f2 - f) / (float)n3;
        int n6 = 0;
        for (int i = 0; i <= n3; ++i) {
            float f7;
            float f8;
            float f9;
            int n7;
            float f10 = f + (float)i * f6;
            for (n7 = 0; n7 <= n; ++n7) {
                f9 = (float)n7 * f5 + 4.712389f;
                f8 = (float)Math.sin(f9);
                f7 = (float)Math.cos(f9);
                fArray[n6++] = f8 * f10;
                fArray[n6++] = f7 * f10 + f3;
                fArray[n6++] = 0.0f;
            }
            for (n7 = n2 - 1; n7 >= 1; --n7) {
                fArray[n6++] = f10;
                fArray[n6++] = (float)n7 * f4;
                fArray[n6++] = 0.0f;
            }
            for (n7 = 0; n7 <= n; ++n7) {
                f9 = (float)n7 * f5 + 1.5707964f;
                f8 = (float)Math.sin(f9);
                f7 = (float)Math.cos(f9);
                fArray[n6++] = f8 * f10;
                fArray[n6++] = f7 * f10;
                fArray[n6++] = 0.0f;
            }
            for (n7 = 1; n7 < n2; ++n7) {
                fArray[n6++] = -f10;
                fArray[n6++] = (float)n7 * f4;
                fArray[n6++] = 0.0f;
            }
        }
    }

    public void makeLongDiskNormals(int n, int n2, int n3, float[] fArray) {
        int n4 = this.getLongDiskVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " loops=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = 2 * (n + 1) + 2 * (n2 - 1);
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f * f};
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j < n6; ++j) {
                int n7 = j + i * n6;
                n7 = 3 * n7;
                System.arraycopy(fArray2, 0, fArray, n7, 3);
            }
        }
    }

    public void makeLongDiskVertexNormals(float f, float f2, float f3, int n, int n2, int n3, float[] fArray, float[] fArray2) {
        int n4 = this.getLongDiskVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " loops=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.SourceVertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = 2 * (n + 1) + 2 * (n2 - 1);
        float f4 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        for (int i = 0; i <= n3; ++i) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            if (i == 0 || i == n3) {
                if (i == 0 && f == 0.0f) {
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    n11 = 0;
                    while (n11 <= n) {
                        n10 = n11++;
                        this.facenorm(fArray, n10, n10 + n6 + 1, n10 + n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    n10 = n;
                    this.facenorm(fArray, n10, n10 + 1, n10 + n6, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    n10 = 0;
                    this.facenorm(fArray, n10, n10 + n6, n10 + n6 - 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.mul3AndSet(fArray3, 0, f4);
                    this.norm3AndSet(fArray3, 0);
                    n11 = 0;
                    while (n11 <= n) {
                        n10 = n11++;
                        System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
                    }
                    for (n11 = 1; n11 < n2; ++n11) {
                        n10 = n11 + n;
                        n9 = n6 - n11;
                        System.arraycopy(fArray4, 0, fArray3, 0, 3);
                        this.facenorm(fArray, n10, n10 + n6, n10 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n10, n10 + 1, n10 + n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        if (n11 == 1) {
                            this.facenorm(fArray, n9, n9 - n6 + 1, n9 + n6, fArray5);
                        } else {
                            this.facenorm(fArray, n9, n9 + 1, n9 + n6, fArray5);
                        }
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n9, n9 + n6, n9 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.mul3AndSet(fArray3, 0, f4);
                        this.norm3AndSet(fArray3, 0);
                        System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
                        System.arraycopy(fArray3, 0, fArray2, 3 * n9, 3);
                    }
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    for (n11 = 0; n11 <= n; ++n11) {
                        n10 = n11 + n + n2;
                        this.facenorm(fArray, n10, n10 + n6 + 1, n10 + n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    n10 = n + n2;
                    this.facenorm(fArray, n10, n10 + n6, n10 - 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    n10 = 2 * n + n2;
                    this.facenorm(fArray, n10, n10 + 1, n10 + n6, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.mul3AndSet(fArray3, 0, f4);
                    this.norm3AndSet(fArray3, 0);
                    for (n11 = 0; n11 <= n; ++n11) {
                        n10 = n11 + n + n2;
                        System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
                    }
                    continue;
                }
                for (n11 = 0; n11 < n6; ++n11) {
                    n10 = n11 + i * n6;
                    n9 = n10 - 1;
                    n8 = n10 + 1;
                    if (n11 == 0) {
                        n9 = i * n6;
                    } else if (n11 == n6 - 1) {
                        n8 = i;
                    }
                    n7 = i == 0 ? n10 + n6 : n10 - n6;
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    if (i == 0) {
                        this.facenorm(fArray, n10, n8, n7, fArray5);
                    } else {
                        this.facenorm(fArray, n10, n7, n8, fArray5);
                    }
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    if (i == 0) {
                        this.facenorm(fArray, n10, n7, n9, fArray5);
                    } else {
                        this.facenorm(fArray, n10, n9, n7, fArray5);
                    }
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.mul3AndSet(fArray3, 0, f4);
                    this.norm3AndSet(fArray3, 0);
                    System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
                }
                continue;
            }
            for (n11 = 0; n11 < n6; ++n11) {
                n10 = n11 + i * n6;
                n9 = n10 - 1;
                n8 = n10 + 1;
                if (n11 == 0) {
                    n9 = n6 - 1 + i * n6;
                } else if (n11 == n6 - 1) {
                    n8 = i * n6;
                }
                n7 = n10 - n6;
                int n12 = n10 + n6;
                System.arraycopy(fArray4, 0, fArray3, 0, 3);
                this.facenorm(fArray, n10, n9, n9 - n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n9 - n6, n7, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n7, n8 - n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n8 - n6, n8, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n8, n8 + n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n8 + n6, n12, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n12, n9 + n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n9 + n6, n9, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.mul3AndSet(fArray3, 0, f4);
                this.norm3AndSet(fArray3, 0);
                System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
            }
        }
    }

    public void makeLongDiskIndices(int n, int n2, int n3, int[] nArray) {
        int n4 = this.getLongDiskIndexCount(n, n2, n3);
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " loops=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n5 = 2 * (n + 1) + 2 * (n2 - 1);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7;
            if (i != 0) {
                if (this.orientation == 1) {
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7 + n5;
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7;
                } else {
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7;
                    n7 = i * n5;
                    nArray[n6++] = n7;
                }
            }
            for (int j = 0; j <= n5; ++j) {
                n7 = j == n5 ? i * n5 : j + i * n5;
                if (this.orientation == 1) {
                    nArray[n6++] = n7;
                    nArray[n6++] = n7 + n5;
                    continue;
                }
                nArray[n6++] = n7 + n5;
                nArray[n6++] = n7;
            }
        }
    }

    public int computePolygonWindingOrder2(int n, int n2, Vec4[] vec4Array) {
        float f = this.computePolygonArea2(n, n2, vec4Array);
        int n3 = f < 0.0f ? 1 : 0;
        return n3;
    }

    public float computePolygonArea2(int n, int n2, Vec4[] vec4Array) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pos=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array == null) {
            String string = "nullValue.PointsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "points.length < " + (n + n2));
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            int n4 = i == n2 - 1 ? n : n + i + 1;
            f = (float)((double)f + vec4Array[n3].x * vec4Array[n4].y);
            f = (float)((double)f - vec4Array[n4].x * vec4Array[n3].y);
        }
        return f /= 2.0f;
    }

    public IndexedTriangleArray tessellatePolygon2(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[3 * n2];
        GLUtessellator gLUtessellator = this.glu.gluNewTess();
        TessellatorCallback tessellatorCallback = new TessellatorCallback(this, n2, fArray);
        this.glu.gluTessCallback(gLUtessellator, 100101, tessellatorCallback);
        this.glu.gluTessCallback(gLUtessellator, 100100, tessellatorCallback);
        this.glu.gluTessCallback(gLUtessellator, 100102, tessellatorCallback);
        this.glu.gluTessCallback(gLUtessellator, 100105, tessellatorCallback);
        this.glu.gluTessNormal(gLUtessellator, 0.0, 0.0, 1.0);
        this.glu.gluTessBeginPolygon(gLUtessellator, null);
        this.glu.gluTessBeginContour(gLUtessellator);
        for (int i = 0; i < n2; ++i) {
            int n3 = 3 * (n + i);
            int n4 = 3 * i;
            dArray[n4] = fArray[n3];
            dArray[n4 + 1] = fArray[n3 + 1];
            dArray[n4 + 2] = 0.0;
            this.glu.gluTessVertex(gLUtessellator, dArray, n4, n + i);
        }
        this.glu.gluTessEndContour(gLUtessellator);
        this.glu.gluTessEndPolygon(gLUtessellator);
        this.glu.gluDeleteTess(gLUtessellator);
        return new IndexedTriangleArray(tessellatorCallback.getIndexCount(), tessellatorCallback.getIndices(), tessellatorCallback.getVertexCount(), tessellatorCallback.getVertices());
    }

    public int getIndexedTriangleArrayDrawMode() {
        return 4;
    }

    public void subdivideIndexedTriangleArray(IndexedTriangleArray indexedTriangleArray) {
        int n;
        int n2;
        int n3;
        if (indexedTriangleArray == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = indexedTriangleArray.indexCount;
        HashMap<Edge, Integer> hashMap = new HashMap<Edge, Integer>();
        for (n3 = 0; n3 < n4; n3 += 3) {
            for (int i = 0; i < 3; ++i) {
                n2 = indexedTriangleArray.indices[n3 + i];
                Edge edge = new Edge(n2, n = indexedTriangleArray.indices[i < 2 ? n3 + i + 1 : n3]);
                Integer n5 = (Integer)hashMap.get(edge);
                if (n5 != null) continue;
                n5 = this.splitVertex(indexedTriangleArray, n2, n);
                hashMap.put(edge, n5);
            }
        }
        for (n3 = 0; n3 < n4; n3 += 3) {
            n2 = indexedTriangleArray.indices[n3];
            n = indexedTriangleArray.indices[n3 + 1];
            int n6 = indexedTriangleArray.indices[n3 + 2];
            int n7 = (Integer)hashMap.get(new Edge(n2, n));
            int n8 = (Integer)hashMap.get(new Edge(n, n6));
            int n9 = (Integer)hashMap.get(new Edge(n6, n2));
            this.indexSplitTriangle(indexedTriangleArray, n3, n2, n, n6, n7, n8, n9);
        }
    }

    public IndexedTriangleArray subdivideIndexedTriangles(int n, int[] nArray, int n2, float[] fArray) {
        int n3 = 3 * n2;
        if (nArray == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + nArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n3) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        IndexedTriangleArray indexedTriangleArray = new IndexedTriangleArray(n, nArray, n2, fArray);
        this.subdivideIndexedTriangleArray(indexedTriangleArray);
        return indexedTriangleArray;
    }

    public void makeIndexedTriangleArrayNormals(IndexedTriangleArray indexedTriangleArray, float[] fArray) {
        if (indexedTriangleArray == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 3 * indexedTriangleArray.vertexCount;
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeIndexedTriangleArrayNormals(0, indexedTriangleArray.indexCount, indexedTriangleArray.indices, 0, indexedTriangleArray.vertexCount, indexedTriangleArray.vertices, fArray);
    }

    public void makeIndexedTriangleArrayNormals(int n, int n2, int[] nArray, int n3, int n4, float[] fArray, float[] fArray2) {
        int n5;
        int n6;
        if (nArray == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + nArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + fArray2.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        int[] nArray2 = new int[3];
        for (int i = 0; i < n2; i += 3) {
            nArray2[0] = nArray[n + i];
            nArray2[1] = nArray[n + i + 1];
            nArray2[2] = nArray[n + i + 2];
            this.facenorm(fArray, nArray2[0], nArray2[1], nArray2[2], fArray3);
            for (n6 = 0; n6 < 3; ++n6) {
                n5 = 3 * nArray2[n6];
                this.add3AndSet(fArray2, n5, fArray3, 0);
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            n5 = 3 * (n3 + n6);
            this.mul3AndSet(fArray2, n5, f);
            this.norm3AndSet(fArray2, n5);
        }
    }

    public void makeIndexedTriangleStripNormals(int n, int n2, int[] nArray, int n3, int n4, float[] fArray, float[] fArray2) {
        int n5;
        int n6;
        if (nArray == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + nArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < 3 * (n3 + n4)) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < 3 * (n3 + n4)) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + fArray2.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        int[] nArray2 = new int[3];
        for (int i = 2; i < n2; ++i) {
            if (i % 2 == 0) {
                nArray2[0] = nArray[n + i - 2];
                nArray2[1] = nArray[n + i - 1];
                nArray2[2] = nArray[n + i];
            } else {
                nArray2[0] = nArray[n + i - 1];
                nArray2[1] = nArray[n + i - 2];
                nArray2[2] = nArray[n + i];
            }
            this.facenorm(fArray, nArray2[0], nArray2[1], nArray2[2], fArray3);
            for (n6 = 0; n6 < 3; ++n6) {
                n5 = 3 * nArray2[n6];
                this.add3AndSet(fArray2, n5, fArray3, 0);
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            n5 = 3 * (n3 + n6);
            this.mul3AndSet(fArray2, n5, f);
            this.norm3AndSet(fArray2, n5);
        }
    }

    private int splitVertex(IndexedTriangleArray indexedTriangleArray, int n, int n2) {
        int n3 = indexedTriangleArray.vertices.length;
        int n4 = 3 * (indexedTriangleArray.vertexCount + 1);
        while (n4 > n3) {
            int n5 = 2 * n3;
            IndexedTriangleArray.access$802(indexedTriangleArray, this.copyOf(indexedTriangleArray.vertices, n5));
            n3 = n5;
        }
        int n6 = indexedTriangleArray.vertexCount;
        int n7 = 3 * n6;
        int n8 = 3 * n;
        int n9 = 3 * n2;
        ((IndexedTriangleArray)indexedTriangleArray).vertices[n7] = (indexedTriangleArray.vertices[n8] + indexedTriangleArray.vertices[n9]) / 2.0f;
        ((IndexedTriangleArray)indexedTriangleArray).vertices[n7 + 1] = (indexedTriangleArray.vertices[n8 + 1] + indexedTriangleArray.vertices[n9 + 1]) / 2.0f;
        ((IndexedTriangleArray)indexedTriangleArray).vertices[n7 + 2] = (indexedTriangleArray.vertices[n8 + 2] + indexedTriangleArray.vertices[n9 + 2]) / 2.0f;
        indexedTriangleArray.vertexCount++;
        return n6;
    }

    private void indexSplitTriangle(IndexedTriangleArray indexedTriangleArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = indexedTriangleArray.indices.length;
        int n9 = indexedTriangleArray.indexCount + 9;
        while (n9 > n8) {
            int n10 = 2 * n8;
            IndexedTriangleArray.access$702(indexedTriangleArray, this.copyOf(indexedTriangleArray.indices, n10));
            n8 = n10;
        }
        ((IndexedTriangleArray)indexedTriangleArray).indices[n] = n2;
        ((IndexedTriangleArray)indexedTriangleArray).indices[n + 1] = n5;
        ((IndexedTriangleArray)indexedTriangleArray).indices[n + 2] = n7;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n5;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n6;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n7;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n5;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n3;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n6;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n7;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n6;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n4;
    }

    public int getSubdivisionPointsVertexCount(int n) {
        return (1 << n) + 1;
    }

    public void makeSubdivisionPoints(float f, float f2, float f3, float f4, float f5, float f6, int n, float[] fArray) {
        int n2 = this.getSubdivisionPointsVertexCount(n);
        int n3 = 3 * n2;
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        int n5 = n2 - 1;
        int n6 = 3 * n4;
        fArray[n6] = f;
        fArray[n6 + 1] = f2;
        fArray[n6 + 2] = f3;
        n6 = 3 * n5;
        fArray[n6] = f4;
        fArray[n6 + 1] = f5;
        fArray[n6 + 2] = f6;
        this.subdivide(f, f2, f3, f4, f5, f6, n, fArray, n4, n5);
    }

    private void subdivide(float f, float f2, float f3, float f4, float f5, float f6, int n, float[] fArray, int n2, int n3) {
        if (n <= 0) {
            return;
        }
        float f7 = (f + f4) / 2.0f;
        float f8 = (f2 + f5) / 2.0f;
        float f9 = (f3 + f6) / 2.0f;
        int n4 = (n2 + n3) / 2;
        int n5 = n4 * 3;
        fArray[n5] = f7;
        fArray[n5 + 1] = f8;
        fArray[n5 + 2] = f9;
        if (n > 1) {
            this.subdivide(f, f2, f3, f7, f8, f9, n - 1, fArray, n2, n4);
            this.subdivide(f7, f8, f9, f4, f5, f6, n - 1, fArray, n4, n3);
        }
    }

    public int getBilinearSurfaceFillIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getBilinearSurfaceOutlineIndexCount(int n, int n2, int n3) {
        int n4 = 0;
        if ((n3 & 1) != 0) {
            n4 += 2 * n;
        }
        if ((n3 & 2) != 0) {
            n4 += 2 * n;
        }
        if ((n3 & 4) != 0) {
            n4 += 2 * n2;
        }
        if ((n3 & 8) != 0) {
            n4 += 2 * n2;
        }
        return n4;
    }

    public int getBilinearSurfaceVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    public int getBilinearSurfaceFillDrawMode() {
        return 5;
    }

    public int getBilinearSurfaceOutlineDrawMode() {
        return 1;
    }

    public void makeBilinearSurfaceFillIndices(int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = this.getBilinearSurfaceFillIndexCount(n2, n3);
        if (n5 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "uStacks=" + n2 + " vStacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n5 + n4) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = n4;
        for (int i = 0; i < n3; ++i) {
            int n7;
            if (i != 0) {
                if (this.orientation == 1) {
                    n7 = n2 + i * (n2 + 1);
                    nArray[n6++] = n + n7;
                    n7 = i * (n2 + 1);
                    nArray[n6++] = n + n7;
                } else {
                    n7 = n2 + (i - 1) * (n2 + 1);
                    nArray[n6++] = n + n7;
                    n7 = i * (n2 + 1) + (n2 + 1);
                    nArray[n6++] = n + n7;
                }
            }
            for (int j = 0; j <= n2; ++j) {
                n7 = j + i * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n6++] = n + n7;
                    nArray[n6++] = n + n7 + (n2 + 1);
                    continue;
                }
                nArray[n6++] = n + n7 + (n2 + 1);
                nArray[n6++] = n + n7;
            }
        }
    }

    public void makeBilinearSurfaceOutlineIndices(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        int n7;
        int n8;
        int n9 = this.getBilinearSurfaceOutlineIndexCount(n2, n3, n4);
        if (n9 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "uStacks=" + n2 + " vStacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n9 + n5) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n10 = n5;
        if ((n4 & 2) != 0) {
            for (n8 = 0; n8 < n2; ++n8) {
                n7 = n8;
                nArray[n10++] = n + n7;
                n7 = n8 + 1;
                nArray[n10++] = n + n7;
            }
        }
        if ((n4 & 8) != 0) {
            for (n6 = 0; n6 < n3; ++n6) {
                n7 = n2 + n6 * (n2 + 1);
                nArray[n10++] = n + n7;
                n7 = n2 + (n6 + 1) * (n2 + 1);
                nArray[n10++] = n + n7;
            }
        }
        if ((n4 & 1) != 0) {
            for (n8 = n2; n8 > 0; --n8) {
                n7 = n8 + n3 * (n2 + 1);
                nArray[n10++] = n + n7;
                n7 = n8 - 1 + n3 * (n2 + 1);
                nArray[n10++] = n + n7;
            }
        }
        if ((n4 & 4) != 0) {
            for (n6 = n3; n6 > 0; --n6) {
                n7 = n6 * (n2 + 1);
                nArray[n10++] = n + n7;
                n7 = (n6 - 1) * (n2 + 1);
                nArray[n10++] = n + n7;
            }
        }
    }

    public void makeBilinearSurfaceVertices(float[] fArray, int n, int n2, int n3, float[] fArray2) {
        int n4 = this.getBilinearSurfaceVertexCount(n2, n3);
        int n5 = 3 * n4;
        if (fArray == null) {
            String string = "nullValue.ControlPointArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < 12) {
            String string = "generic.ControlPointArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "uStacks=" + n2 + " vStacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n5 + 3 * n) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = 1.0f / (float)n2;
        float f2 = 1.0f / (float)n3;
        for (int i = 0; i <= n3; ++i) {
            float f3 = (float)i * f2;
            float f4 = 1.0f - f3;
            for (int j = 0; j <= n2; ++j) {
                float f5 = (float)j * f;
                float f6 = 1.0f - f5;
                int n6 = j + i * (n2 + 1);
                n6 = 3 * (n + n6);
                float f7 = f6 * f4 * fArray[0] + f5 * f4 * fArray[3] + f5 * f3 * fArray[6] + f6 * f3 * fArray[9];
                float f8 = f6 * f4 * fArray[1] + f5 * f4 * fArray[4] + f5 * f3 * fArray[7] + f6 * f3 * fArray[10];
                float f9 = f6 * f4 * fArray[2] + f5 * f4 * fArray[5] + f5 * f3 * fArray[8] + f6 * f3 * fArray[11];
                fArray2[n6] = f7;
                fArray2[n6 + 1] = f8;
                fArray2[n6 + 2] = f9;
            }
        }
    }

    public void makeBilinearSurfaceVertexNormals(int n, int n2, int n3, float[] fArray, int n4, float[] fArray2) {
        int n5 = this.getBilinearSurfaceVertexCount(n2, n3);
        int n6 = 3 * n5;
        if (n5 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "uStacks=" + n2 + " vStacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.SourceVertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n6 + 3 * n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j <= n2; ++j) {
                int n7 = j + i * (n2 + 1);
                n7 = n + n7;
                int n8 = n7 - (n2 + 1);
                int n9 = n7 + (n2 + 1);
                System.arraycopy(fArray4, 0, fArray3, 0, 3);
                if (i > 0) {
                    if (j > 0) {
                        this.facenorm(fArray, n7, n7 - 1, n8 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n7, n8 - 1, n8, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    if (j < n2) {
                        this.facenorm(fArray, n7, n8, n8 + 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n7, n8 + 1, n7 + 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                }
                if (i < n3) {
                    if (j > 0) {
                        this.facenorm(fArray, n7, n9, n9 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n7, n9 - 1, n7 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    if (j < n2) {
                        this.facenorm(fArray, n7, n7 + 1, n9 + 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n7, n9 + 1, n9, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                }
                this.mul3AndSet(fArray3, 0, f);
                this.norm3AndSet(fArray3, 0);
                System.arraycopy(fArray3, 0, fArray2, 3 * n7, 3);
            }
        }
    }

    public <T> void reversePoints(int n, int n2, T[] TArray) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pos=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (TArray == null) {
            String string = "nullValue.PointsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (TArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "points.length < " + (n + n2));
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        int n4 = n2 >> 1;
        int n5 = n2 - 1;
        while (n3 < n4) {
            T t = TArray[n + n3];
            TArray[n + n3] = TArray[n + n5];
            TArray[n + n5] = t;
            ++n3;
            --n5;
        }
    }

    private int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    private float[] copyOf(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(fArray.length, n));
        return fArray2;
    }

    private void facenorm(float[] fArray, int n, int n2, int n3, float[] fArray2) {
        int n4 = 3 * n;
        int n5 = 3 * n2;
        int n6 = 3 * n3;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        this.sub3(fArray, n5, fArray, n4, fArray3, 0);
        this.sub3(fArray, n6, fArray, n4, fArray4, 0);
        this.cross3(fArray3, fArray4, fArray2);
        this.norm3AndSet(fArray2, 0);
    }

    private void add3AndSet(float[] fArray, int n, float[] fArray2, int n2) {
        fArray[n] = fArray[n] + fArray2[n2];
        fArray[n + 1] = fArray[n + 1] + fArray2[n2 + 1];
        fArray[n + 2] = fArray[n + 2] + fArray2[n2 + 2];
    }

    private void sub3(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        fArray3[n3] = fArray[n] - fArray2[n2];
        fArray3[n3 + 1] = fArray[n + 1] - fArray2[n2 + 1];
        fArray3[n3 + 2] = fArray[n + 2] - fArray2[n2 + 2];
    }

    private void cross3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[1] * fArray2[2] - fArray[2] * fArray2[1];
        fArray3[1] = fArray[2] * fArray2[0] - fArray[0] * fArray2[2];
        fArray3[2] = fArray[0] * fArray2[1] - fArray[1] * fArray2[0];
    }

    private void mul3AndSet(float[] fArray, int n, float f) {
        int n2 = n;
        fArray[n2] = fArray[n2] * f;
        int n3 = n + 1;
        fArray[n3] = fArray[n3] * f;
        int n4 = n + 2;
        fArray[n4] = fArray[n4] * f;
    }

    private void norm3AndSet(float[] fArray, int n) {
        float f = fArray[n] * fArray[n] + fArray[n + 1] * fArray[n + 1] + fArray[n + 2] * fArray[n + 2];
        if (f != 0.0f) {
            f = (float)Math.sqrt(f);
            int n2 = n;
            fArray[n2] = fArray[n2] / f;
            int n3 = n + 1;
            fArray[n3] = fArray[n3] / f;
            int n4 = n + 2;
            fArray[n4] = fArray[n4] / f;
        }
    }

    private int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    private static class Edge {
        public final int a;
        public final int b;

        public Edge(int n, int n2) {
            this.a = n;
            this.b = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Edge edge = (Edge)object;
            return this.a == edge.a && this.b == edge.b || this.a == edge.b && this.b == edge.a;
        }

        public int hashCode() {
            return this.a + this.b;
        }
    }

    public static class IndexedTriangleArray {
        private int indexCount;
        private int vertexCount;
        private int[] indices;
        private float[] vertices;

        public IndexedTriangleArray(int n, int[] nArray, int n2, float[] fArray) {
            this.indexCount = n;
            this.indices = nArray;
            this.vertexCount = n2;
            this.vertices = fArray;
        }

        public int getIndexCount() {
            return this.indexCount;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public float[] getVertices() {
            return this.vertices;
        }

        static /* synthetic */ float[] access$802(IndexedTriangleArray indexedTriangleArray, float[] fArray) {
            indexedTriangleArray.vertices = fArray;
            return fArray;
        }

        static /* synthetic */ int[] access$702(IndexedTriangleArray indexedTriangleArray, int[] nArray) {
            indexedTriangleArray.indices = nArray;
            return nArray;
        }
    }

    private static class TessellatorCallback
    extends GLUtessellatorCallbackAdapter {
        private GeometryBuilder gb;
        private int type;
        private int indexCount;
        private int primIndexCount;
        private int vertexCount;
        private int[] indices;
        private int[] primIndices;
        private float[] vertices;

        private TessellatorCallback(GeometryBuilder geometryBuilder, int n, float[] fArray) {
            this.gb = geometryBuilder;
            this.indexCount = 0;
            this.primIndexCount = 0;
            this.vertexCount = n;
            int n2 = this.gb.nextPowerOfTwo(3 * n);
            this.indices = new int[n2];
            this.primIndices = new int[n2];
            this.vertices = this.gb.copyOf(fArray, n2);
        }

        public int getIndexCount() {
            return this.indexCount;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public float[] getVertices() {
            return this.vertices;
        }

        protected void addTriangle(int n, int n2, int n3) {
            int n4 = this.indexCount + 3;
            int n5 = this.indices.length;
            while (n4 > n5) {
                int n6 = 2 * n5;
                this.indices = this.gb.copyOf(this.indices, n6);
                n5 = n4;
            }
            if (this.gb.orientation == 1) {
                this.indices[this.indexCount++] = this.primIndices[n];
                this.indices[this.indexCount++] = this.primIndices[n3];
                this.indices[this.indexCount++] = this.primIndices[n2];
            } else {
                this.indices[this.indexCount++] = this.primIndices[n];
                this.indices[this.indexCount++] = this.primIndices[n2];
                this.indices[this.indexCount++] = this.primIndices[n3];
            }
        }

        public void begin(int n) {
            this.type = n;
            this.primIndexCount = 0;
        }

        public void vertex(Object object) {
            int n = this.primIndices.length;
            int n2 = this.primIndexCount + 1;
            while (n2 > n) {
                int n3 = 2 * n;
                this.primIndices = this.gb.copyOf(this.primIndices, n3);
                n = n3;
            }
            int n4 = (Integer)object;
            this.primIndices[this.primIndexCount++] = n4;
        }

        public void end() {
            block5: {
                block6: {
                    block4: {
                        if (this.type != 4) break block4;
                        for (int i = 2; i < this.primIndexCount; ++i) {
                            if ((i + 1) % 3 != 0) continue;
                            this.addTriangle(i - 2, i - 1, i);
                        }
                        break block5;
                    }
                    if (this.type != 5) break block6;
                    for (int i = 2; i < this.primIndexCount; ++i) {
                        if (i % 2 == 0) {
                            this.addTriangle(i - 2, i - 1, i);
                            continue;
                        }
                        this.addTriangle(i - 1, i - 2, i);
                    }
                    break block5;
                }
                if (this.type != 6) break block5;
                for (int i = 2; i < this.primIndexCount; ++i) {
                    this.addTriangle(0, i - 1, i);
                }
            }
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = objectArray[0];
        }
    }
}

