/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.tiff.GeotiffReader;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.BarycentricQuadrilateral;
import gov.nasa.worldwind.geom.BarycentricTriangle;
import gov.nasa.worldwind.geom.GeoQuad;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.geom.coords.TMCoord;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.util.ImageInterpolator;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtil {
    public static int NEAREST_NEIGHBOR_INTERPOLATION = 1;
    public static int BILINEAR_INTERPOLATION = 2;
    public static int IMAGE_TILE_SIZE = 1024;
    public static Color TRANSPARENT = new Color(0, 0, 0, 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImageOnCanvas(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.CanvasIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static void warpImageWithTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2, Matrix matrix) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.CanvasIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                Vec4 vec4 = new Vec4(j, i, 1.0).transformBy3(matrix);
                if (!(vec4.x >= 0.0) || !(vec4.y >= 0.0) || !(vec4.x <= (double)(n - 1)) || !(vec4.y <= (double)(n2 - 1))) continue;
                int n5 = (int)Math.floor(vec4.x);
                int n6 = (int)Math.ceil(vec4.x);
                double d = vec4.x - (double)n5;
                int n7 = (int)Math.floor(vec4.y);
                int n8 = (int)Math.ceil(vec4.y);
                double d2 = vec4.y - (double)n7;
                int n9 = ImageUtil.interpolateColor(d, d2, bufferedImage.getRGB(n5, n7), bufferedImage.getRGB(n6, n7), bufferedImage.getRGB(n5, n8), bufferedImage.getRGB(n6, n8));
                bufferedImage2.setRGB(j, i, n9);
            }
        }
    }

    public static Sector warpImageWithControlPoints(BufferedImage bufferedImage, Point2D[] point2DArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = ImageUtil.validateControlPoints(3, point2DArray, latLonArray);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (point2DArray.length >= 4 && latLonArray.length >= 4) {
            return ImageUtil.warpImageWithControlPoints4(bufferedImage, point2DArray, latLonArray, bufferedImage2);
        }
        return ImageUtil.warpImageWithControlPoints3(bufferedImage, point2DArray, latLonArray, bufferedImage2);
    }

    public static Sector warpImageWithControlPoints4(BufferedImage bufferedImage, Point2D[] point2DArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = ImageUtil.validateControlPoints(4, point2DArray, latLonArray);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Point2D[] point2DArray2 = new Point2D[3];
        LatLon[] latLonArray2 = new LatLon[3];
        ImageUtil.computeBestFittingControlPoints4(point2DArray, latLonArray, point2DArray2, latLonArray2);
        return ImageUtil.warpImageWithControlPoints3(bufferedImage, point2DArray2, latLonArray2, bufferedImage2);
    }

    public static Sector warpImageWithControlPoints3(BufferedImage bufferedImage, Point2D[] point2DArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = ImageUtil.validateControlPoints(3, point2DArray, latLonArray);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromImageToGeographic(point2DArray, latLonArray);
        List<LatLon> list = ImageUtil.computeImageCorners(bufferedImage.getWidth(), bufferedImage.getHeight(), matrix);
        Sector sector = Sector.boundingSector(list);
        if (Sector.isSector(list) && sector.isSameSector(list)) {
            ImageUtil.drawImageOnCanvas(bufferedImage, bufferedImage2);
        } else {
            Matrix matrix2 = Matrix.IDENTITY;
            matrix2 = matrix2.multiply(Matrix.fromGeographicToImage(point2DArray, latLonArray));
            matrix2 = matrix2.multiply(Matrix.fromImageToGeographic(bufferedImage2.getWidth(), bufferedImage2.getHeight(), sector));
            ImageUtil.warpImageWithTransform(bufferedImage, bufferedImage2, matrix2);
        }
        return sector;
    }

    public static Sector warpImageWithWorldFile(BufferedImage bufferedImage, AVList aVList, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromImageToGeographic(aVList);
        if (matrix == null) {
            String string = Logging.getMessage("WorldFile.UnrecognizedValues", "");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        List<LatLon> list = ImageUtil.computeImageCorners(bufferedImage.getWidth(), bufferedImage.getHeight(), matrix);
        Sector sector = Sector.boundingSector(list);
        if (Sector.isSector(list) && sector.isSameSector(list)) {
            ImageUtil.drawImageOnCanvas(bufferedImage, bufferedImage2);
        } else {
            Matrix matrix2 = Matrix.IDENTITY;
            matrix2 = matrix2.multiply(Matrix.fromGeographicToImage(aVList));
            matrix2 = matrix2.multiply(Matrix.fromImageToGeographic(bufferedImage2.getWidth(), bufferedImage2.getHeight(), sector));
            ImageUtil.warpImageWithTransform(bufferedImage, bufferedImage2, matrix2);
        }
        return sector;
    }

    public static void computeBestFittingControlPoints4(Point2D[] point2DArray, LatLon[] latLonArray, Point2D[] point2DArray2, LatLon[] latLonArray2) {
        String string = ImageUtil.validateControlPoints(4, point2DArray, latLonArray);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        string = ImageUtil.validateControlPoints(3, point2DArray2, latLonArray2);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Point2D[] point2DArray3 = null;
        LatLon[] latLonArray3 = null;
        double d = Double.MAX_VALUE;
        for (int[] nArray : new int[][]{{0, 1, 2}, {0, 1, 3}, {1, 2, 3}, {0, 2, 3}}) {
            Point2D[] point2DArray4 = new Point2D[]{point2DArray[nArray[0]], point2DArray[nArray[1]], point2DArray[nArray[2]]};
            LatLon[] latLonArray4 = new LatLon[]{latLonArray[nArray[0]], latLonArray[nArray[1]], latLonArray[nArray[2]]};
            Matrix matrix = Matrix.fromImageToGeographic(point2DArray4, latLonArray4);
            double d2 = 0.0;
            for (int i = 0; i < 4; ++i) {
                Vec4 vec4 = new Vec4(point2DArray[i].getX(), point2DArray[i].getY(), 1.0).transformBy3(matrix);
                LatLon latLon = LatLon.fromDegrees(vec4.y, vec4.x);
                LatLon latLon2 = latLonArray[i].subtract(latLon);
                double d3 = latLon2.getLatitude().degrees * latLon2.getLatitude().degrees + latLon2.getLongitude().degrees * latLon2.getLongitude().degrees;
                d2 += d3;
            }
            if (!(d2 < d)) continue;
            point2DArray3 = point2DArray4;
            latLonArray3 = latLonArray4;
            d = d2;
        }
        if (point2DArray3 != null) {
            System.arraycopy(point2DArray3, 0, point2DArray2, 0, 3);
            System.arraycopy(latLonArray3, 0, latLonArray2, 0, 3);
        }
    }

    public static List<LatLon> computeImageCorners(int n, int n2, Matrix matrix) {
        if (n < 1 || n2 < 1) {
            String string = Logging.getMessage("generic.InvalidImageSize", n, n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        Vec4 vec4 = new Vec4(0.0, n2, 1.0).transformBy3(matrix);
        arrayList.add(LatLon.fromDegrees(vec4.y, vec4.x));
        vec4 = new Vec4(n, n2, 1.0).transformBy3(matrix);
        arrayList.add(LatLon.fromDegrees(vec4.y, vec4.x));
        vec4 = new Vec4(n, 0.0, 1.0).transformBy3(matrix);
        arrayList.add(LatLon.fromDegrees(vec4.y, vec4.x));
        vec4 = new Vec4(0.0, 0.0, 1.0).transformBy3(matrix);
        arrayList.add(LatLon.fromDegrees(vec4.y, vec4.x));
        return arrayList;
    }

    private static String validateControlPoints(int n, Point2D[] point2DArray, LatLon[] latLonArray) {
        if (point2DArray == null) {
            return Logging.getMessage("nullValue.ImagePointsIsNull");
        }
        if (latLonArray == null) {
            return Logging.getMessage("nullValue.GeoPointsIsNull");
        }
        if (point2DArray.length < n) {
            return Logging.getMessage("generic.ArrayInvalidLength", point2DArray.length);
        }
        if (latLonArray.length < n) {
            return Logging.getMessage("generic.ArrayInvalidLength", point2DArray.length);
        }
        return null;
    }

    public static void mergeImage(Sector sector, Sector sector2, double d, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (sector == null || sector2 == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (bufferedImage2 == null || bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Util.AspectRatioInvalid", d);
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!sector.intersects(sector2)) {
            return;
        }
        int n = d >= 1.0 ? bufferedImage2.getWidth() : (int)((double)bufferedImage2.getWidth() * d);
        int n2 = d >= 1.0 ? (int)((double)bufferedImage2.getHeight() / d) : bufferedImage2.getHeight();
        double d2 = d >= 1.0 ? (1.0 - 1.0 / d) * (double)bufferedImage2.getHeight() : 0.0;
        double d3 = (double)n2 / (double)bufferedImage.getHeight() * sector2.getDeltaLat().divide(sector.getDeltaLat());
        double d4 = (double)n / (double)bufferedImage.getWidth() * sector2.getDeltaLon().divide(sector.getDeltaLon());
        double d5 = (double)n2 * (-sector2.getMaxLatitude().subtract((Angle)sector.getMaxLatitude()).degrees / sector.getDeltaLat().degrees);
        double d6 = (double)n * (sector2.getMinLongitude().subtract((Angle)sector.getMinLongitude()).degrees / sector.getDeltaLon().degrees);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.translate(d6, d5 + d2);
        graphics2D.scale(d4, d3);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
    }

    public static Sector positionImage(BufferedImage bufferedImage, Point[] pointArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        if (pointArray.length == 3) {
            return ImageUtil.positionImage3(bufferedImage, pointArray, latLonArray, bufferedImage2);
        }
        if (pointArray.length == 4) {
            return ImageUtil.positionImage4(bufferedImage, pointArray, latLonArray, bufferedImage2);
        }
        return null;
    }

    public static Sector positionImage3(BufferedImage bufferedImage, Point[] pointArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        BarycentricTriangle barycentricTriangle = new BarycentricTriangle(latLonArray[0], latLonArray[1], latLonArray[2]);
        BarycentricTriangle barycentricTriangle2 = new BarycentricTriangle(pointArray[0], pointArray[1], pointArray[2]);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        double[] dArray = barycentricTriangle2.getBarycentricCoords(new Vec4(0.0, bufferedImage.getHeight(), 0.0));
        arrayList.add(barycentricTriangle.getLocation(dArray));
        dArray = barycentricTriangle2.getBarycentricCoords(new Vec4(bufferedImage.getWidth(), bufferedImage.getHeight(), 0.0));
        arrayList.add(barycentricTriangle.getLocation(dArray));
        dArray = barycentricTriangle2.getBarycentricCoords(new Vec4(bufferedImage.getWidth(), 0.0, 0.0));
        arrayList.add(barycentricTriangle.getLocation(dArray));
        dArray = barycentricTriangle2.getBarycentricCoords(new Vec4(0.0, 0.0, 0.0));
        arrayList.add(barycentricTriangle.getLocation(dArray));
        Sector sector = Sector.boundingSector(arrayList);
        GeoQuad geoQuad = new GeoQuad(sector.asList());
        double d = bufferedImage2.getWidth();
        double d2 = bufferedImage2.getHeight();
        for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
            double d3 = (double)i / d2;
            for (int j = 0; j < bufferedImage2.getWidth(); ++j) {
                double d4 = (double)j / d;
                LatLon latLon = geoQuad.interpolate(1.0 - d3, d4);
                double[] dArray2 = barycentricTriangle.getBarycentricCoords(latLon);
                Vec4 vec4 = barycentricTriangle2.getPoint(dArray2);
                if (vec4.x < 0.0 || vec4.x >= (double)bufferedImage.getWidth() || vec4.y < 0.0 || vec4.y >= (double)bufferedImage.getHeight()) continue;
                int n = bufferedImage.getRGB((int)vec4.x, (int)vec4.y);
                bufferedImage2.setRGB(j, i, n);
            }
        }
        return sector;
    }

    public static Sector positionImage4(BufferedImage bufferedImage, Point[] pointArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        BarycentricQuadrilateral barycentricQuadrilateral = new BarycentricQuadrilateral(latLonArray[0], latLonArray[1], latLonArray[2], latLonArray[3]);
        BarycentricQuadrilateral barycentricQuadrilateral2 = new BarycentricQuadrilateral(pointArray[0], pointArray[1], pointArray[2], pointArray[3]);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        double[] dArray = barycentricQuadrilateral2.getBarycentricCoords(new Vec4(0.0, bufferedImage.getHeight(), 0.0));
        arrayList.add(barycentricQuadrilateral.getLocation(dArray));
        dArray = barycentricQuadrilateral2.getBarycentricCoords(new Vec4(bufferedImage.getWidth(), bufferedImage.getHeight(), 0.0));
        arrayList.add(barycentricQuadrilateral.getLocation(dArray));
        dArray = barycentricQuadrilateral2.getBarycentricCoords(new Vec4(bufferedImage.getWidth(), 0.0, 0.0));
        arrayList.add(barycentricQuadrilateral.getLocation(dArray));
        dArray = barycentricQuadrilateral2.getBarycentricCoords(new Vec4(0.0, 0.0, 0.0));
        arrayList.add(barycentricQuadrilateral.getLocation(dArray));
        Sector sector = Sector.boundingSector(arrayList);
        GeoQuad geoQuad = new GeoQuad(sector.asList());
        double d = bufferedImage2.getWidth();
        double d2 = bufferedImage2.getHeight();
        for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
            double d3 = (double)i / d2;
            for (int j = 0; j < bufferedImage2.getWidth(); ++j) {
                double d4 = (double)j / d;
                LatLon latLon = geoQuad.interpolate(1.0 - d3, d4);
                double[] dArray2 = barycentricQuadrilateral.getBarycentricCoords(latLon);
                Vec4 vec4 = barycentricQuadrilateral2.getPoint(dArray2);
                if (vec4.x < 0.0 || vec4.x >= (double)bufferedImage.getWidth() || vec4.y < 0.0 || vec4.y >= (double)bufferedImage.getHeight()) continue;
                int n = bufferedImage.getRGB((int)vec4.x, (int)vec4.y);
                bufferedImage2.setRGB(j, i, n);
            }
        }
        return sector;
    }

    public static BufferedImage[] buildMipmaps(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "maxLevel < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[1 + n2];
        if (bufferedImage.getType() == n) {
            bufferedImageArray[0] = bufferedImage;
        } else {
            bufferedImageArray[0] = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            ImageUtil.drawImageOnCanvas(bufferedImage, bufferedImageArray[0]);
        }
        for (int i = 1; i <= n2; ++i) {
            int n3 = Math.max(bufferedImage.getWidth() >> i, 1);
            int n4 = Math.max(bufferedImage.getWidth() >> i, 1);
            bufferedImageArray[i] = new BufferedImage(n3, n4, n);
            ImageUtil.drawImageOnCanvas(bufferedImageArray[i - 1], bufferedImageArray[i]);
        }
        return bufferedImageArray;
    }

    public static BufferedImage[] buildMipmaps(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getType();
        int n2 = ImageUtil.getMaxMipmapLevel(bufferedImage.getWidth(), bufferedImage.getHeight());
        if (n == 0) {
            n = 2;
        }
        return ImageUtil.buildMipmaps(bufferedImage, n, n2);
    }

    public static int getMaxMipmapLevel(int n, int n2) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = (int)WWMath.logBase2(n);
        int n4 = (int)WWMath.logBase2(n2);
        return Math.max(n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertToPowerOfTwoImage(BufferedImage bufferedImage, boolean bl) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (WWMath.isPowerOfTwo(bufferedImage.getWidth()) && WWMath.isPowerOfTwo(bufferedImage.getHeight())) {
            return bufferedImage;
        }
        int n = WWMath.powerOfTwoCeiling(bufferedImage.getWidth());
        int n2 = WWMath.powerOfTwoCeiling(bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getColorModel().hasAlpha() ? 6 : 5);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            if (bl) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
            } else {
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static long computeSizeInBytes(BufferedImage bufferedImage) {
        DataBuffer dataBuffer;
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (writableRaster != null && (dataBuffer = writableRaster.getDataBuffer()) != null) {
            l = ImageUtil.computeSizeOfDataBuffer(dataBuffer);
        }
        return l;
    }

    private static long computeSizeOfDataBuffer(DataBuffer dataBuffer) {
        return (long)dataBuffer.getSize() * ImageUtil.computeSizeOfBufferDataType(dataBuffer.getDataType());
    }

    private static long computeSizeOfBufferDataType(int n) {
        switch (n) {
            case 0: {
                return 1L;
            }
            case 5: {
                return 8L;
            }
            case 4: {
                return 4L;
            }
            case 3: {
                return 4L;
            }
            case 1: 
            case 2: {
                return 2L;
            }
        }
        return 0L;
    }

    public static AVList openSpatialImage(File file, int n) throws IOException {
        BufferedImage bufferedImage;
        File[] fileArray;
        AVListImpl aVListImpl = new AVListImpl();
        if (file.getName().toLowerCase().endsWith(".tiff") || file.getName().toLowerCase().endsWith(".tif")) {
            fileArray = new GeotiffReader(file);
            bufferedImage = fileArray.read();
            if (fileArray.isGeotiff()) {
                return ImageUtil.handleGeotiff(bufferedImage, (GeotiffReader)fileArray, n);
            }
        }
        if ((bufferedImage = ImageIO.read(file)) == null) {
            fileArray = Logging.getMessage("generic.ImageReadFailed", file);
            Logging.logger().severe((String)fileArray);
            throw new WWRuntimeException((String)fileArray);
        }
        fileArray = WorldFile.getWorldFiles(file.getAbsoluteFile());
        if (fileArray == null || fileArray.length == 0) {
            String string = Logging.getMessage("WorldFile.WorldFileNotFound", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage);
        WorldFile.decodeWorldFiles(fileArray, aVListImpl);
        Sector sector = (Sector)aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector");
        if (sector == null) {
            ImageUtil.reprojectUtmToGeographic(aVListImpl, n);
        }
        if ((sector = (Sector)aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector")) == null) {
            String string = "Problem generating bounding sector for the image";
            throw new WWRuntimeException(string);
        }
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        return aVListImpl;
    }

    public static AVList openSpatialImage(File file) throws IOException {
        return ImageUtil.openSpatialImage(file, NEAREST_NEIGHBOR_INTERPOLATION);
    }

    private static AVList handleGeotiff(BufferedImage bufferedImage, GeotiffReader geotiffReader, int n) throws IOException {
        Sector sector;
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage);
        if (geotiffReader.getGeoCodec().hasGeoKey(3074) || geotiffReader.getGeoCodec().hasGeoKey(3072)) {
            int n2;
            int n3;
            int[] nArray = geotiffReader.getGeoCodec().hasGeoKey(3074) ? geotiffReader.getGeoCodec().getGeoKeyAsInts(3074) : geotiffReader.getGeoCodec().getGeoKeyAsInts(3072);
            int n4 = nArray[0];
            if (n4 >= 16100 && n4 <= 16199) {
                n3 = 83;
                n2 = n4 - 16100;
            } else if (n4 >= 16000 && n4 <= 16099) {
                n3 = 78;
                n2 = n4 - 16000;
            } else if (n4 >= 26900 && n4 <= 26999) {
                n3 = 78;
                n2 = n4 - 26900;
            } else if (n4 >= 32600 && n4 <= 32699) {
                n3 = 78;
                n2 = n4 - 32600;
            } else if (n4 >= 32700 && n4 <= 32799) {
                n3 = 83;
                n2 = n4 - 32700;
            } else {
                String string = Logging.getMessage("generic.ProjectionUnsupported");
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            aVListImpl.setValue("gov.nasa.worldwind.worldFile.Hemisphere", String.valueOf((char)n3));
            aVListImpl.setValue("gov.nasa.worldwind.worldFile.Zone", Integer.toString(n2));
            aVListImpl.setValue("gov.nasa.worldwind.worldFile.XPixelSize", geotiffReader.getGeoCodec().getModelPixelScaleX());
            aVListImpl.setValue("gov.nasa.worldwind.worldFile.YPixelSize", -1.0 * geotiffReader.getGeoCodec().getModelPixelScaleY());
            double d = geotiffReader.getGeoCodec().getTiePoints()[0].getX() + geotiffReader.getGeoCodec().getModelPixelScaleX() * 0.5;
            double d2 = geotiffReader.getGeoCodec().getTiePoints()[0].getY() - geotiffReader.getGeoCodec().getModelPixelScaleY() * 0.5;
            aVListImpl.setValue("gov.nasa.worldwind.worldFile.XLocation", d);
            aVListImpl.setValue("gov.nasa.worldwind.worldFile.YLocation", d2);
            ImageUtil.reprojectUtmToGeographic(aVListImpl, n);
            sector = (Sector)aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector");
        } else if (geotiffReader.getGeoCodec().hasGeoKey(2048) && !geotiffReader.getGeoCodec().hasGeoKey(3072)) {
            double[] dArray = geotiffReader.getGeoCodec().getBoundingBox(bufferedImage.getWidth(), bufferedImage.getHeight());
            sector = new Sector(Angle.fromDegreesLatitude(dArray[3]), Angle.fromDegreesLatitude(dArray[1]), Angle.fromDegreesLongitude(dArray[0]), Angle.fromDegreesLongitude(dArray[2]));
        } else {
            String string = Logging.getMessage("generic.ProjectionUnsupported");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        return aVListImpl;
    }

    public static void reprojectUtmToGeographic(AVList aVList, int n) {
        double d = 500000.0;
        double d2 = 0.0;
        double d3 = 0.9996;
        Earth earth = new Earth();
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        BufferedImage bufferedImage = (BufferedImage)aVList.getValue("gov.nasa.worldwind.avkey.Image");
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = bufferedImage.getColorModel() != null && bufferedImage.getColorModel() instanceof IndexColorModel ? new BufferedImage(n2, n3, 2, (IndexColorModel)bufferedImage.getColorModel()) : new BufferedImage(n2, n3, 2);
        double d4 = 0.0;
        double d5 = 0.0;
        Object object = aVList.getValue("gov.nasa.worldwind.worldFile.XPixelSize");
        if (object != null && object instanceof Double) {
            d4 = (Double)object;
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.worldFile.YPixelSize")) != null && object instanceof Double) {
            d5 = (Double)object;
        }
        double d6 = (Double)aVList.getValue("gov.nasa.worldwind.worldFile.XLocation");
        double d7 = (Double)aVList.getValue("gov.nasa.worldwind.worldFile.YLocation");
        int n4 = Integer.parseInt((String)aVList.getValue("gov.nasa.worldwind.worldFile.Zone"));
        char c = ((String)aVList.getValue("gov.nasa.worldwind.worldFile.Hemisphere")).charAt(0);
        UTMCoord uTMCoord = UTMCoord.fromUTM(n4, c, d6, d7);
        UTMCoord uTMCoord2 = UTMCoord.fromUTM(n4, c, uTMCoord.getEasting() - d4 * 0.5, uTMCoord.getNorthing() - d5 * 0.5);
        UTMCoord uTMCoord3 = UTMCoord.fromUTM(n4, c, uTMCoord2.getEasting() + (double)n2 * d4, uTMCoord2.getNorthing() + (double)n3 * d5);
        UTMCoord uTMCoord4 = UTMCoord.fromUTM(n4, uTMCoord.getHemisphere(), uTMCoord2.getEasting(), uTMCoord3.getNorthing());
        UTMCoord uTMCoord5 = UTMCoord.fromUTM(n4, uTMCoord.getHemisphere(), uTMCoord3.getEasting(), uTMCoord2.getNorthing());
        Angle angle = Angle.max(uTMCoord5.getLongitude(), uTMCoord3.getLongitude());
        Angle angle2 = Angle.min(uTMCoord4.getLongitude(), uTMCoord2.getLongitude());
        Angle angle3 = Angle.max(uTMCoord5.getLatitude(), uTMCoord2.getLatitude());
        Angle angle4 = Angle.min(uTMCoord3.getLatitude(), uTMCoord4.getLatitude());
        Sector sector = new Sector(angle4, angle3, angle2, angle);
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        double d8 = (angle4.getDegrees() - angle3.getDegrees()) / (double)n3;
        double d9 = (angle.getDegrees() - angle2.getDegrees()) / (double)n2;
        double d10 = sector.getMaxLatitude().getDegrees() + d8 * 0.5;
        double d11 = sector.getMinLongitude().getDegrees() + d9 * 0.5;
        TMCoord tMCoord = TMCoord.fromLatLon(uTMCoord2.getLatitude(), uTMCoord2.getLongitude(), earth, Angle.fromDegrees(0.0), uTMCoord2.getCentralMeridian(), d, d2, d3);
        double d12 = tMCoord.getNorthing() + d5 * 0.5;
        double d13 = tMCoord.getEasting() + d4 * 0.5;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d14 = d10 + (double)i * d8;
                double d15 = d11 + (double)j * d9;
                TMCoord tMCoord2 = TMCoord.fromLatLon(Angle.fromDegreesLatitude(d14), Angle.fromDegreesLongitude(d15), earth, Angle.fromDegrees(0.0), uTMCoord2.getCentralMeridian(), d, d2, d3);
                double d16 = tMCoord2.getEasting() - d13;
                double d17 = d12 - tMCoord2.getNorthing();
                long l = Math.round(d16 / Math.abs(d4));
                long l2 = Math.round(d17 / Math.abs(d5));
                if (n == BILINEAR_INTERPOLATION) {
                    double d18 = d16 / Math.abs(d4);
                    double d19 = d17 / Math.abs(d5);
                    int n5 = (int)Math.floor(d18);
                    int n6 = (int)Math.floor(d19);
                    double d20 = d18 - (double)n5;
                    double d21 = d19 - (double)n6;
                    if (n5 <= 0 || n6 <= 0) continue;
                    if (n5 < n2 - 1 && n6 < n3 - 1) {
                        int n7 = bufferedImage.getRGB(n5, n6);
                        int n8 = bufferedImage.getRGB(n5 + 1, n6);
                        int n9 = bufferedImage.getRGB(n5, n6 + 1);
                        int n10 = bufferedImage.getRGB(n5 + 1, n6 + 1);
                        int n11 = ImageUtil.interpolateColor(d20, d21, n7, n8, n9, n10);
                        bufferedImage2.setRGB(j, i, Math.round(n11));
                        continue;
                    }
                    bufferedImage2.setRGB(j, i, 0);
                    continue;
                }
                if (l <= 0L || l2 <= 0L) continue;
                if (l < (long)n2 && l2 < (long)n3) {
                    bufferedImage2.setRGB(j, i, bufferedImage.getRGB(Long.valueOf(l).intValue(), Long.valueOf(l2).intValue()));
                    continue;
                }
                bufferedImage2.setRGB(j, i, 0);
            }
        }
        aVList.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage2);
    }

    public static int interpolateColor(double d, double d2, int n, int n2, int n3, int n4) {
        int n5 = n >> 24 & 0xFF;
        int n6 = n >> 16 & 0xFF;
        int n7 = n >> 8 & 0xFF;
        int n8 = n & 0xFF;
        int n9 = n2 >> 24 & 0xFF;
        int n10 = n2 >> 16 & 0xFF;
        int n11 = n2 >> 8 & 0xFF;
        int n12 = n2 & 0xFF;
        int n13 = n3 >> 24 & 0xFF;
        int n14 = n3 >> 16 & 0xFF;
        int n15 = n3 >> 8 & 0xFF;
        int n16 = n3 & 0xFF;
        int n17 = n4 >> 24 & 0xFF;
        int n18 = n4 >> 16 & 0xFF;
        int n19 = n4 >> 8 & 0xFF;
        int n20 = n4 & 0xFF;
        double d3 = 1.0 - d;
        double d4 = 1.0 - d2;
        double d5 = d3 * (double)n5 + d * (double)n9;
        double d6 = d3 * (double)n13 + d * (double)n17;
        int n21 = (int)(d4 * d5 + d2 * d6);
        n21 <<= 24;
        d5 = d3 * (double)n6 + d * (double)n10;
        d6 = d3 * (double)n14 + d * (double)n18;
        int n22 = (int)(d4 * d5 + d2 * d6);
        n22 <<= 16;
        d5 = d3 * (double)n7 + d * (double)n11;
        d6 = d3 * (double)n15 + d * (double)n19;
        int n23 = (int)(d4 * d5 + d2 * d6);
        d5 = d3 * (double)n8 + d * (double)n12;
        d6 = d3 * (double)n16 + d * (double)n20;
        int n24 = (int)(d4 * d5 + d2 * d6);
        return n21 | n22 | (n23 <<= 8) | n24;
    }

    public static AlignedImage alignImage(BufferedImage bufferedImage, float[] fArray, float[] fArray2) {
        return ImageUtil.alignImage(bufferedImage, fArray, fArray2, null);
    }

    public static AlignedImage alignImage(BufferedImage bufferedImage, float[] fArray, float[] fArray2, Sector sector) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (fArray == null || fArray2 == null || fArray.length != fArray2.length) {
            String string = Logging.getMessage("ImageUtil.FieldArrayInvalid");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n < 1 || n2 < 1) {
            String string = Logging.getMessage("ImageUtil.EmptyImage");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (fArray2.length < n * n2 || fArray.length < n * n2) {
            String string = Logging.getMessage("ImageUtil.FieldArrayTooShort");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (sector == null) {
            sector = ImageUtil.computeExtremes(fArray, fArray2);
        }
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        int[] nArray2 = new int[nArray.length];
        ImageInterpolator imageInterpolator = new ImageInterpolator(new Dimension(n, n2), fArray2, fArray, 10, 1);
        double d = sector.getDeltaLonDegrees() / (double)(n - 1);
        double d2 = sector.getDeltaLatDegrees() / (double)(n2 - 1);
        for (int i = 0; i < n2; ++i) {
            float f = (float)(sector.getMaxLatitude().degrees - (double)i * d2);
            for (int j = 0; j < n; ++j) {
                int n3;
                float f2 = (float)(sector.getMinLongitude().degrees + (double)j * d);
                ImageInterpolator.ContainingCell containingCell = imageInterpolator.findContainingCell(f2, f);
                nArray2[i * n + j] = containingCell == null ? 0 : (n3 = ImageUtil.interpolateColor(containingCell.uv[0], containingCell.uv[1], nArray[containingCell.fieldIndices[0]], nArray[containingCell.fieldIndices[1]], nArray[containingCell.fieldIndices[3]], nArray[containingCell.fieldIndices[2]]));
            }
        }
        nArray = null;
        imageInterpolator = null;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 6);
        bufferedImage2.setRGB(0, 0, n, n2, nArray2, 0, n);
        return new AlignedImage(bufferedImage2, sector);
    }

    private static Sector computeExtremes(float[] fArray, float[] fArray2) {
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        float f3 = Float.MAX_VALUE;
        float f4 = -3.4028235E38f;
        for (float f5 : fArray2) {
            if (f5 < f) {
                f = f5;
            }
            if (!(f5 > f2)) continue;
            f2 = f5;
        }
        for (float f5 : fArray) {
            if (f5 < f3) {
                f3 = f5;
            }
            if (!(f5 > f4)) continue;
            f4 = f5;
        }
        return Sector.fromDegrees(f3, f4, f, f2);
    }

    public static class AlignedImage {
        public final Sector sector;
        public final BufferedImage image;

        public AlignedImage(BufferedImage bufferedImage, Sector sector) {
            this.image = bufferedImage;
            this.sector = sector;
        }
    }
}

