/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import javax.media.opengl.GL;

public class OGLStateSupport {
    public static String COLOR_NO_PREMULTIPLIED_ALPHA = "OGLStateSupport.ColorNoPremultipliedAlpha";
    public static String COLOR_PREMULTIPLIED_ALPHA = "OGLStateSupport.ColorPremultipliedAlpha";
    public static String LIGHT_DIRECTIONAL_FROM_VIEWER_POSITION = "OGLStateSupport.LightDirectionalFromViewerPosition";
    protected static final String EXT_BLEND_FUNC_SEPARATE_STRING = "GL_EXT_blend_func_separate";
    protected boolean enableAlphaTest;
    protected boolean enableBlending;
    protected boolean enableColor;
    protected boolean enableLighting;
    protected String colorMode;
    protected Color color = Color.WHITE;
    protected double opacity = 1.0;
    protected String lightType;
    protected Vec4 lightPosition;

    public boolean isEnableAlphaTest() {
        return this.enableAlphaTest;
    }

    public void setEnableAlphaTest(boolean bl) {
        this.enableAlphaTest = bl;
    }

    public boolean isEnableBlending() {
        return this.enableBlending;
    }

    public void setEnableBlending(boolean bl) {
        this.enableBlending = bl;
    }

    public boolean isEnableColor() {
        return this.enableColor;
    }

    public void setEnableColor(boolean bl) {
        this.enableColor = bl;
    }

    public boolean isEnableLighting() {
        return this.enableLighting;
    }

    public void setEnableLighting(boolean bl) {
        this.enableLighting = bl;
    }

    public String getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(String string) {
        this.colorMode = string;
    }

    public Color getColor() {
        return this.color;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[4];
        this.color.getRGBComponents(fArray);
        this.color = color;
        this.opacity = fArray[3];
    }

    public void setColor(Color color, double d) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity < 0 or opacity > 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
        this.opacity = d;
    }

    public String getLightType() {
        return this.lightType;
    }

    public void setLightType(String string) {
        this.lightType = string;
    }

    public Vec4 getLightPosition() {
        return this.lightPosition;
    }

    public void setLightPosition(Vec4 vec4) {
        this.lightPosition = vec4;
    }

    public int getAttributeBits() {
        int n = 0;
        if (this.enableColor) {
            n |= 1;
        }
        if (this.enableBlending) {
            n |= 0x4000;
        }
        if (this.enableLighting) {
            n |= 0x40;
            n |= 0x1000;
        }
        return n;
    }

    public void apply(GL gL) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.enableAlphaTest) {
            this.setupAlphaTestState(gL);
        }
        if (this.enableBlending) {
            this.setupBlendingState(gL, this.colorMode);
        }
        if (this.enableColor) {
            this.setupColorState(gL, this.colorMode, this.color, this.opacity);
        }
        if (this.enableLighting) {
            this.setupLightingState(gL, this.lightType, this.lightPosition);
        }
    }

    protected void setupAlphaTestState(GL gL) {
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.0f);
    }

    protected void setupBlendingState(GL gL, String string) {
        if (gL == null) {
            String string2 = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        gL.glEnable(3042);
        if (string != null && string.equals(COLOR_NO_PREMULTIPLIED_ALPHA)) {
            boolean bl = gL.isExtensionAvailable(EXT_BLEND_FUNC_SEPARATE_STRING);
            if (bl) {
                gL.glBlendFuncSeparate(770, 771, 1, 771);
            } else {
                gL.glBlendFunc(770, 771);
            }
        } else if (string != null && string.equals(COLOR_PREMULTIPLIED_ALPHA)) {
            gL.glBlendFunc(1, 771);
        }
    }

    protected void setupColorState(GL gL, String string, Color color, double d) {
        if (gL == null) {
            String string2 = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (color == null) {
            String string3 = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = (float)WWMath.clamp(d, 0.0, 1.0);
        if (string != null && string.equals(COLOR_PREMULTIPLIED_ALPHA)) {
            fArray[0] = fArray[0] * fArray[3];
            fArray[1] = fArray[1] * fArray[3];
            fArray[2] = fArray[2] * fArray[3];
        }
        gL.glColor4fv(fArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupLightingState(GL gL, String string, Vec4 vec4) {
        if (gL == null) {
            String string2 = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        gL.glDisable(2903);
        gL.glDisable(16384);
        gL.glEnable(2896);
        gL.glEnable(16385);
        gL.glEnable(2977);
        gL.glLightModeli(2897, 1);
        gL.glLightModeli(2898, 1);
        gL.glShadeModel(7425);
        if (string != null && string.equals(LIGHT_DIRECTIONAL_FROM_VIEWER_POSITION)) {
            if (vec4 == null) {
                vec4 = OGLStateSupport.getDefaultLightDirection();
            }
            float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            float[] fArray4 = new float[]{(float)vec4.x, (float)vec4.y, (float)vec4.z, 0.0f};
            gL.glLightfv(16385, 4608, fArray, 0);
            gL.glLightfv(16385, 4609, fArray2, 0);
            gL.glLightfv(16385, 4610, fArray3, 0);
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            oGLStackHandler.pushModelviewIdentity(gL);
            try {
                gL.glLightfv(16385, 4611, fArray4, 0);
            }
            finally {
                oGLStackHandler.pop(gL);
            }
        }
    }

    protected static Vec4 getDefaultLightDirection() {
        return new Vec4(0.0, 0.0, -1.0, 0.0);
    }
}

