/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistry {
    private String name = "";
    private Map<Class<?>, ProviderRegistry<?>> serviceMap = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string != null ? string : "";
    }

    public Iterable<Class<?>> getServices() {
        return this.serviceMap.keySet();
    }

    public <T> boolean hasService(Class<T> clazz) {
        ProviderRegistry<T> providerRegistry = this.getProviderRegistry(clazz);
        return providerRegistry != null;
    }

    public <T> void addService(Class<T> clazz) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ProviderRegistry<T> providerRegistry = new ProviderRegistry<T>(clazz);
        this.serviceMap.put(clazz, providerRegistry);
        String string = Logging.getMessage("ServiceRegistry.RegisterServiceCategory", this.getName(), clazz);
        Logging.logger().finer(string);
    }

    public <T> Iterable<Class<? extends T>> getServiceProviders(Class<T> clazz) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateService(clazz);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ProviderRegistry<T> providerRegistry = this.getProviderRegistry(clazz);
        return providerRegistry.getProviders();
    }

    public <T> Iterable<? extends T> createServiceProviders(Class<T> clazz) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateService(clazz);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ProviderRegistry<T> providerRegistry = this.getProviderRegistry(clazz);
        return this.instantiateProviders(providerRegistry.getProviders());
    }

    public <T> boolean hasServiceProvider(Class<? extends T> clazz, Class<T> clazz2) {
        if (clazz2 == null) {
            String string = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateService(clazz2);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ProviderRegistry<? extends T> providerRegistry = this.getProviderRegistry(clazz2);
        return providerRegistry.hasProvider(clazz);
    }

    public <T> void registerServiceProvider(Class<? extends T> clazz, Class<T> clazz2) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ServiceProviderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (clazz2 == null) {
            String string = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateProvider(clazz, clazz2);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        string = this.validateService(clazz2);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ProviderRegistry<? extends T> providerRegistry = this.getProviderRegistry(clazz2);
        providerRegistry.registerProvider(clazz);
        string = Logging.getMessage("ServiceRegistry.RegisterServiceProvider", this.getName(), clazz, providerRegistry.getService());
        Logging.logger().finer(string);
    }

    public <T> void deregisterServiceProvider(Class<? extends T> clazz, Class<T> clazz2) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ServiceProviderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (clazz2 == null) {
            String string = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateProvider(clazz, clazz2);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        string = this.validateService(clazz2);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ProviderRegistry<? extends T> providerRegistry = this.getProviderRegistry(clazz2);
        providerRegistry.deregisterProvider(clazz);
        string = Logging.getMessage("ServiceRegistry.DeregisterServiceProvider", this.getName(), clazz, providerRegistry.getService());
        Logging.logger().finer(string);
    }

    public <T> void deregisterAll(Class<T> clazz) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateService(clazz);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ProviderRegistry<T> providerRegistry = this.getProviderRegistry(clazz);
        providerRegistry.deregisterAll();
        string = Logging.getMessage("ServiceRegistry.DeregisterAllServiceProviders", this.getName(), providerRegistry.getService());
        Logging.logger().finer(string);
    }

    public void deregisterAll() {
        for (ProviderRegistry<?> providerRegistry : this.serviceMap.values()) {
            providerRegistry.deregisterAll();
            String string = Logging.getMessage("ServiceRegistry.DeregisterAllServiceProviders", this.getName(), providerRegistry.getService());
            Logging.logger().finer(string);
        }
    }

    protected <T> ProviderRegistry<T> getProviderRegistry(Class<T> clazz) {
        return this.serviceMap.get(clazz);
    }

    protected <T> Iterable<? extends T> instantiateProviders(Iterable<Class<? extends T>> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Class<T> clazz : iterable) {
            String string;
            try {
                T t = clazz.newInstance();
                arrayList.add(t);
            }
            catch (IllegalAccessException illegalAccessException) {
                string = Logging.getMessage("ServiceRegistry.NoDefaultConstructor");
                Logging.logger().severe(string);
            }
            catch (InstantiationException instantiationException) {
                string = Logging.getMessage("ServiceRegistry.NonInstantiableServiceProvider");
                Logging.logger().severe(string);
            }
        }
        return arrayList;
    }

    protected <T> String validateService(Class<T> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        ProviderRegistry<T> providerRegistry = this.getProviderRegistry(clazz);
        if (providerRegistry == null) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("ServiceRegistry.UnknownService", clazz));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    protected <T> String validateProvider(Class<? extends T> clazz, Class<T> clazz2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!clazz2.isAssignableFrom(clazz)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("ServiceRegistry.InvalidServiceProviderType", clazz));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ProviderRegistry<T> {
        private Class<T> service;
        private List<Class<? extends T>> providerList;

        public ProviderRegistry(Class<T> clazz) {
            this.service = clazz;
            this.providerList = new ArrayList<Class<? extends T>>();
        }

        public Class<T> getService() {
            return this.service;
        }

        public Iterable<Class<? extends T>> getProviders() {
            return Collections.unmodifiableList(this.providerList);
        }

        public boolean hasProvider(Class<? extends T> clazz) {
            Boolean bl = this.providerList.contains(clazz);
            return bl != null;
        }

        public void registerProvider(Class<? extends T> clazz) {
            if (!this.providerList.contains(clazz)) {
                this.providerList.add(clazz);
            }
        }

        public void deregisterProvider(Class<? extends T> clazz) {
            if (!this.providerList.contains(clazz)) {
                this.providerList.remove(clazz);
            }
        }

        public void deregisterAll() {
            this.providerList.clear();
        }
    }
}

