/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.markers.Marker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpatialTree<S, T> {
    protected int depth;
    protected int maxDepth;
    protected boolean addToAllLevels;
    protected S coverage;
    protected List<S> subCoverage;
    protected ArrayList<SpatialTree<S, T>> children;
    protected List<T> items = new ArrayList<T>();

    protected abstract boolean intersects(S var1, T var2);

    protected abstract boolean intersectsCoverage(S var1, S var2);

    protected abstract SpatialTree<S, T> createInstance(S var1, int var2, int var3, boolean var4);

    protected abstract boolean contains(S var1, LatLon var2);

    protected abstract ArrayList<S> subdivide(S var1, int var2, int var3);

    public SpatialTree(S s, int n, int n2, boolean bl) {
        this(s, n, n2, bl, 2, 2);
    }

    public SpatialTree(S s, int n, int n2, boolean bl, int n3, int n4) {
        this.coverage = s;
        this.depth = n;
        this.maxDepth = n2;
        this.addToAllLevels = bl;
        if (n < n2) {
            this.subCoverage = this.subdivide(this.coverage, n3, n4);
            this.children = new ArrayList(n3 * n4);
            for (int i = 0; i < n3 * n4; ++i) {
                this.children.add(null);
            }
        }
    }

    public boolean add(T t) {
        boolean bl = false;
        if (this.depth == this.maxDepth || this.addToAllLevels) {
            bl = this.maxDepthAdd(t);
        }
        if (this.depth < this.maxDepth) {
            bl = this.normalAdd(t) || bl;
        }
        return bl;
    }

    protected boolean normalAdd(T t) {
        boolean bl = false;
        for (int i = 0; i < this.subCoverage.size() && !bl; ++i) {
            if (!this.intersects(this.subCoverage.get(i), t)) continue;
            if (this.children.get(i) == null) {
                this.children.set(i, this.createInstance(this.subCoverage.get(i), this.depth + 1, this.maxDepth, this.addToAllLevels));
            }
            bl = this.children.get(i).add(t);
        }
        return bl;
    }

    protected boolean maxDepthAdd(T t) {
        return this.intersects(this.coverage, t) && this.items.add(t);
    }

    public boolean remove(Sector sector, T t) {
        boolean bl = false;
        if (this.depth == this.maxDepth || this.addToAllLevels) {
            bl = this.maxDepthRemove(t);
        }
        if (this.depth < this.maxDepth) {
            bl = bl && this.normalRemove(sector, t);
        }
        return bl;
    }

    protected boolean maxDepthRemove(T t) {
        return this.items.remove(t);
    }

    protected boolean normalRemove(Sector sector, T t) {
        boolean bl = false;
        for (int i = 0; i < this.subCoverage.size(); ++i) {
            if (!this.intersects(this.subCoverage.get(i), t)) continue;
            if (this.children.get(i) == null) {
                this.children.set(i, this.createInstance(this.subCoverage.get(i), this.depth + 1, this.maxDepth, this.addToAllLevels));
            }
            bl = bl || this.children.get(i).remove(sector, t);
        }
        return bl;
    }

    public Collection<T> getItems(LatLon latLon, int n, Collection<T> collection) {
        if (!this.contains(this.coverage, latLon)) {
            return Collections.emptyList();
        }
        if (this.depth == n) {
            return this.getAll(collection);
        }
        if (this.depth < n) {
            for (int i = 0; i < this.subCoverage.size(); ++i) {
                if (!this.contains(this.subCoverage.get(i), latLon)) continue;
                SpatialTree<S, T> spatialTree = this.children.get(i);
                if (spatialTree != null) {
                    return spatialTree.getItems(latLon, n, collection);
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public Collection<T> getItems(S s, Collection<T> collection) {
        block6: {
            block5: {
                if (!this.intersectsCoverage(s, this.coverage)) {
                    return Collections.emptyList();
                }
                if (s.equals(this.coverage)) {
                    return this.getAll(collection);
                }
                if (collection == null) {
                    collection = new ArrayList<T>();
                }
                if (this.depth != this.maxDepth) break block5;
                for (T t : this.items) {
                    if (!this.intersects(s, t)) continue;
                    collection.add(t);
                }
                break block6;
            }
            if (this.depth >= this.maxDepth) break block6;
            for (int i = 0; i < this.subCoverage.size(); ++i) {
                if (!this.intersectsCoverage(s, this.subCoverage.get(i)) || this.children.get(i) == null) continue;
                this.children.get(i).getItems(s, collection);
            }
        }
        return collection;
    }

    public Collection<T> getAll(Collection<T> collection) {
        if (this.addToAllLevels) {
            return this.items;
        }
        if (this.children == null) {
            return this.items;
        }
        if (collection == null) {
            collection = new ArrayList<T>();
        }
        for (SpatialTree<S, T> spatialTree : this.children) {
            if (spatialTree == null) continue;
            spatialTree.getAll(collection);
        }
        return collection;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public S getCoverage() {
        return this.coverage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarkerTree
    extends SpatialTree<Sector, Marker> {
        public MarkerTree(int n) {
            this(Sector.FULL_SPHERE, 0, n, false);
        }

        public MarkerTree(Sector sector, int n, boolean bl) {
            super(sector, 0, n, bl);
        }

        protected MarkerTree(Sector sector, int n, int n2, boolean bl) {
            super(sector, n, n2, bl);
        }

        @Override
        protected SpatialTree<Sector, Marker> createInstance(Sector sector, int n, int n2, boolean bl) {
            return new MarkerTree(sector, n, n2, bl);
        }

        @Override
        protected boolean intersects(Sector sector, Marker marker) {
            return sector.contains(marker.getPosition());
        }

        @Override
        protected boolean intersectsCoverage(Sector sector, Sector sector2) {
            return sector.intersects(sector2);
        }

        @Override
        protected boolean contains(Sector sector, LatLon latLon) {
            return sector.contains(latLon);
        }

        @Override
        protected ArrayList<Sector> subdivide(Sector sector, int n, int n2) {
            ArrayList<Sector> arrayList = new ArrayList<Sector>(n * n2);
            double d = sector.getDeltaLon().degrees / (double)n2;
            double d2 = sector.getDeltaLat().degrees / (double)n;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    arrayList.add(Sector.fromDegrees(sector.getMinLatitude().degrees + (double)i * d2, sector.getMinLatitude().degrees + (double)(i + 1) * d2, sector.getMinLongitude().degrees + (double)j * d, sector.getMinLongitude().degrees + (double)(j + 1) * d));
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocationTree
    extends SpatialTree<Sector, LatLon> {
        public LocationTree(int n) {
            this(Sector.FULL_SPHERE, 0, n, false);
        }

        public LocationTree(Sector sector, int n, boolean bl) {
            super(sector, 0, n, bl);
        }

        protected LocationTree(Sector sector, int n, int n2, boolean bl) {
            super(sector, n, n2, bl);
        }

        @Override
        protected SpatialTree<Sector, LatLon> createInstance(Sector sector, int n, int n2, boolean bl) {
            return new LocationTree(sector, n, n2, bl);
        }

        @Override
        protected boolean intersects(Sector sector, LatLon latLon) {
            return sector.contains(latLon);
        }

        @Override
        protected boolean intersectsCoverage(Sector sector, Sector sector2) {
            return sector.intersects(sector2);
        }

        @Override
        protected boolean contains(Sector sector, LatLon latLon) {
            return sector.contains(latLon);
        }

        @Override
        protected ArrayList<Sector> subdivide(Sector sector, int n, int n2) {
            ArrayList<Sector> arrayList = new ArrayList<Sector>(n * n2);
            double d = sector.getDeltaLon().degrees / (double)n2;
            double d2 = sector.getDeltaLat().degrees / (double)n;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    arrayList.add(Sector.fromDegrees(sector.getMinLatitude().degrees + (double)i * d2, sector.getMinLatitude().degrees + (double)(i + 1) * d2, sector.getMinLongitude().degrees + (double)j * d, sector.getMinLongitude().degrees + (double)(j + 1) * d));
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SectorTree<S, T>
    extends SpatialTree<Sector, ItemInfo<T>> {
        public SectorTree(int n) {
            this(Sector.FULL_SPHERE, 0, n, false);
        }

        public SectorTree(Sector sector, int n, boolean bl) {
            this(sector, 0, n, bl);
        }

        protected SectorTree(Sector sector, int n, int n2, boolean bl) {
            super(sector, n, n2, bl);
        }

        @Override
        protected SpatialTree<Sector, ItemInfo<T>> createInstance(Sector sector, int n, int n2, boolean bl) {
            return new SectorTree<S, T>(sector, n, n2, bl);
        }

        @Override
        protected boolean intersects(Sector sector, ItemInfo<T> itemInfo) {
            return sector.intersects(itemInfo.sector);
        }

        @Override
        protected boolean intersectsCoverage(Sector sector, Sector sector2) {
            return sector.intersects(sector2);
        }

        @Override
        protected boolean contains(Sector sector, LatLon latLon) {
            return sector.contains(latLon);
        }

        @Override
        protected ArrayList<Sector> subdivide(Sector sector, int n, int n2) {
            ArrayList<Sector> arrayList = new ArrayList<Sector>(n * n2);
            double d = sector.getDeltaLon().degrees / (double)n2;
            double d2 = sector.getDeltaLat().degrees / (double)n;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    arrayList.add(Sector.fromDegrees(sector.getMinLatitude().degrees + (double)i * d2, sector.getMinLatitude().degrees + (double)(i + 1) * d2, sector.getMinLongitude().degrees + (double)j * d, sector.getMinLongitude().degrees + (double)(j + 1) * d));
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ItemInfo<T> {
        protected T item;
        protected Sector sector;

        protected ItemInfo(Sector sector, T t) {
            this.item = t;
            this.sector = sector;
        }

        protected boolean intersects(Sector sector) {
            return this.sector.intersects(sector);
        }
    }
}

