/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.util.Logging;

public class StatusDescription {
    public static final String UNIT_METRIC = "gov.nasa.worldwind.StatusBar.Metric";
    public static final String UNIT_IMPERIAL = "gov.nasa.worldwind.StatusBar.Imperial";
    private static final double METER_TO_FEET = 3.280839895;
    private static final double METER_TO_MILE = 6.21371192E-4;

    public static String makeAngleDescription(String string, Angle angle) {
        return StatusDescription.makeAngleDescription(string, angle, 4);
    }

    public static String makeAngleDescription(String string, Angle angle, int n) {
        String string2 = String.format("%s %7." + n + "f\u00b0", string, angle.degrees);
        return string2;
    }

    public static String makeEyeAltitudeDescription(double d) {
        return StatusDescription.makeEyeAltitudeDescription(d, UNIT_METRIC);
    }

    public static String makeEyeAltitudeDescription(double d, String string) {
        String string2 = Logging.getMessage("term.Altitude");
        String string3 = UNIT_IMPERIAL.equals(string) ? String.format(string2 + " %,d mi", (int)Math.round(d * 6.21371192E-4)) : String.format(string2 + " %,d km", (int)Math.round(d / 1000.0));
        return string3;
    }

    public static String makeCursorElevationDescription(double d) {
        return StatusDescription.makeCursorElevationDescription(d, UNIT_METRIC);
    }

    public static String makeCursorElevationDescription(double d, String string) {
        String string2 = Logging.getMessage("term.Elev");
        String string3 = UNIT_IMPERIAL.equals(string) ? String.format(string2 + " %,d feet", (int)(d * 3.280839895)) : String.format(string2 + " %,d meters", (int)d);
        return string3;
    }
}

