/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

public class WWMath {
    private static final double METER_TO_FEET = 3.280839895;
    private static final double METER_TO_MILE = 6.21371192E-4;

    public static double logBase2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static boolean isPowerOfTwo(int n) {
        return n == WWMath.powerOfTwoCeiling(n);
    }

    public static int powerOfTwoCeiling(int n) {
        int n2 = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        return (int)Math.pow(2.0, n2);
    }

    public static int powerOfTwoFloor(int n) {
        int n2 = (int)Math.floor(Math.log(n) / Math.log(2.0));
        return (int)Math.pow(2.0, n2);
    }

    public static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    public static double convertMetersToFeet(double d) {
        return d * 3.280839895;
    }

    public static double convertMetersToMiles(double d) {
        return d * 6.21371192E-4;
    }
}

