/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.measure;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.measure.MeasureToolController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureTool
extends AVListImpl
implements Disposable {
    public static final String SHAPE_LINE = "MeasureTool.ShapeLine";
    public static final String SHAPE_PATH = "MeasureTool.ShapePath";
    public static final String SHAPE_POLYGON = "MeasureTool.ShapePolygon";
    public static final String SHAPE_CIRCLE = "MeasureTool.ShapeCircle";
    public static final String SHAPE_ELLIPSE = "MeasureTool.ShapeEllipse";
    public static final String SHAPE_QUAD = "MeasureTool.ShapeQuad";
    public static final String SHAPE_SQUARE = "MeasureTool.ShapeSquare";
    public static final String EVENT_POSITION_ADD = "MeasureTool.AddPosition";
    public static final String EVENT_POSITION_REMOVE = "MeasureTool.RemovePosition";
    public static final String EVENT_POSITION_REPLACE = "MeasureTool.ReplacePosition";
    public static final String EVENT_METRIC_CHANGED = "MeasureTool.MetricChanged";
    public static final String EVENT_ARMED = "MeasureTool.Armed";
    public static final String EVENT_RUBBERBAND_START = "MeasureTool.RubberBandStart";
    public static final String EVENT_RUBBERBAND_STOP = "MeasureTool.RubberBandStop";
    protected final WorldWindow wwd;
    protected MeasureToolController controller;
    protected ArrayList<Position> positions = new ArrayList();
    protected ArrayList<Renderable> controlPoints = new ArrayList();
    protected RenderableLayer applicationLayer;
    protected CustomRenderableLayer layer;
    protected CustomRenderableLayer controlPointsLayer;
    protected CustomRenderableLayer shapeLayer;
    protected Polyline line;
    protected SurfaceShape surfaceShape;
    protected ScreenAnnotation annotation;
    protected Color lineColor = Color.YELLOW;
    protected Color fillColor = new Color(0.6f, 0.6f, 0.4f, 0.5f);
    protected double lineWidth = 2.0;
    protected String pathType = "gov.nasa.worldwind.avkey.GreatCircle";
    protected AnnotationAttributes controlPointsAttributes;
    protected AnnotationAttributes annotationAttributes;
    protected String measureShape = "MeasureTool.ShapeLine";
    protected boolean followTerrain = false;
    protected boolean showControlPoints = true;
    protected boolean showAnnotation = true;
    protected Rectangle2D.Double shapeRectangle = null;
    protected Position shapeCenterPosition = null;
    protected Angle shapeOrientation = null;
    protected int shapeIntervals = 64;

    public MeasureTool(WorldWindow worldWindow) {
        this(worldWindow, null);
    }

    public MeasureTool(WorldWindow worldWindow, RenderableLayer renderableLayer) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.applicationLayer = renderableLayer;
        this.layer = this.createCustomRenderableLayer();
        this.shapeLayer = this.createCustomRenderableLayer();
        this.controlPointsLayer = this.createCustomRenderableLayer();
        this.shapeLayer.setPickEnabled(false);
        this.layer.setName("Measure Tool");
        this.layer.addRenderable(this.shapeLayer);
        this.layer.addRenderable(this.controlPointsLayer);
        this.controlPointsLayer.setEnabled(this.showControlPoints);
        if (this.applicationLayer != null) {
            this.applicationLayer.addRenderable(this.layer);
        } else {
            this.wwd.getModel().getLayers().add(this.layer);
        }
        this.controlPointsAttributes = new AnnotationAttributes();
        this.controlPointsAttributes.setFrameShape("Render.FrameFactory.ShapeRectangle");
        this.controlPointsAttributes.setLeader("Render.FrameFactory.LeaderNone");
        this.controlPointsAttributes.setAdjustWidthToText("render.Annotation.SizeFixed");
        this.controlPointsAttributes.setSize(new Dimension(8, 8));
        this.controlPointsAttributes.setDrawOffset(new Point(0, -4));
        this.controlPointsAttributes.setInsets(new Insets(0, 0, 0, 0));
        this.controlPointsAttributes.setBorderWidth(0.0);
        this.controlPointsAttributes.setCornerRadius(0);
        this.controlPointsAttributes.setBackgroundColor(Color.BLUE);
        this.controlPointsAttributes.setTextColor(Color.GREEN);
        this.controlPointsAttributes.setHighlightScale(1.2);
        this.controlPointsAttributes.setDistanceMaxScale(1.0);
        this.controlPointsAttributes.setDistanceMinScale(1.0);
        this.controlPointsAttributes.setDistanceMinOpacity(1.0);
        this.annotationAttributes = new AnnotationAttributes();
        this.annotationAttributes.setFrameShape("Render.FrameFactory.ShapeNone");
        this.annotationAttributes.setInsets(new Insets(0, 0, 0, 0));
        this.annotationAttributes.setDrawOffset(new Point(0, 10));
        this.annotationAttributes.setTextAlign(1);
        this.annotationAttributes.setEffect("render.MultiLineTextRenderer.EffectOutline");
        this.annotationAttributes.setFont(Font.decode("Arial-Bold-14"));
        this.annotationAttributes.setTextColor(Color.WHITE);
        this.annotationAttributes.setSize(new Dimension(220, 0));
        this.annotation = new ScreenAnnotation("", new Point(0, 0), this.annotationAttributes);
        this.annotation.getAttributes().setVisible(false);
        this.annotation.getAttributes().setDrawOffset(null);
        this.shapeLayer.addRenderable(this.annotation);
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    protected CustomRenderableLayer createCustomRenderableLayer() {
        return new CustomRenderableLayer();
    }

    public void setController(MeasureToolController measureToolController) {
        if (this.controller != null) {
            this.wwd.getInputHandler().removeMouseListener(this.controller);
            this.wwd.getInputHandler().removeMouseMotionListener(this.controller);
            this.wwd.removePositionListener(this.controller);
            this.wwd.removeSelectListener(this.controller);
            this.wwd.removeRenderingListener(this.controller);
            this.controller = null;
        }
        if (measureToolController != null) {
            this.controller = measureToolController;
            this.controller.setMeasureTool(this);
            this.wwd.getInputHandler().addMouseListener(this.controller);
            this.wwd.getInputHandler().addMouseMotionListener(this.controller);
            this.wwd.addPositionListener(this.controller);
            this.wwd.addSelectListener(this.controller);
            this.wwd.addRenderingListener(this.controller);
        }
    }

    public MeasureToolController getController() {
        return this.controller;
    }

    public void setArmed(boolean bl) {
        if (this.controller != null) {
            this.controller.setArmed(bl);
        }
    }

    public boolean isArmed() {
        return this.controller != null && this.controller.isArmed();
    }

    public RenderableLayer getLayer() {
        return this.layer;
    }

    public Polyline getLine() {
        return this.line;
    }

    public SurfaceShape getSurfaceShape() {
        return this.surfaceShape;
    }

    public ArrayList<? extends Position> getPositions() {
        return this.positions;
    }

    public void setPositions(ArrayList<? extends Position> arrayList) {
        if (arrayList == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (arrayList.size() < 2) {
            return;
        }
        this.clear();
        boolean bl = arrayList.get(0).equals(arrayList.get(arrayList.size() - 1));
        if (arrayList.size() > 2 && bl) {
            this.setMeasureShape(SHAPE_POLYGON);
        } else {
            this.setMeasureShape(this.getPathType(arrayList));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Position position = arrayList.get(i);
            this.positions.add(position);
            if (i >= arrayList.size() - 1 && bl) continue;
            this.addControlPoint(position, "PositionIndex", this.positions.size() - 1);
        }
        if (this.measureShape.equals(SHAPE_LINE)) {
            this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
        }
        this.updateMeasureShape();
        this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
        this.wwd.redraw();
    }

    public ArrayList<Renderable> getControlPoints() {
        return this.controlPoints;
    }

    public AnnotationAttributes getControlPointsAttributes() {
        return this.controlPointsAttributes;
    }

    public AnnotationAttributes getAnnotationAttributes() {
        return this.annotationAttributes;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lineColor = color;
        if (this.line != null) {
            this.line.setColor(color);
        }
        if (this.surfaceShape != null) {
            this.surfaceShape.getAttributes().setOutlineMaterial(new Material(color));
            this.surfaceShape.getAttributes().setOutlineOpacity((double)color.getAlpha() / 255.0);
        }
        this.wwd.redraw();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setFillColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.fillColor = color;
        if (this.surfaceShape != null) {
            this.surfaceShape.getAttributes().setInteriorMaterial(new Material(color));
            this.surfaceShape.getAttributes().setInteriorOpacity((double)color.getAlpha() / 255.0);
        }
        this.wwd.redraw();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
        if (this.line != null) {
            this.line.setLineWidth(d);
        }
        if (this.surfaceShape != null) {
            this.surfaceShape.getAttributes().setOutlineWidth(d);
        }
        this.wwd.redraw();
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String string) {
        this.pathType = string;
        if (this.line != null) {
            this.line.setPathType(MeasureTool.polylinePathTypeFromKey(string));
        }
        if (this.surfaceShape != null) {
            this.surfaceShape.setPathType(string);
        }
        this.wwd.redraw();
    }

    protected static int polylinePathTypeFromKey(String string) {
        if (string != null && string == "gov.nasa.worldwind.avkey.GreatCircle") {
            return 0;
        }
        if (string != null && (string == "gov.nasa.worldwind.avkey.RhumbLine" || string == "gov.nasa.worldwind.avkey.Loxodrome")) {
            return 2;
        }
        return 1;
    }

    protected static String keyFromPolylinePathType(int n) {
        if (n == 0) {
            return "gov.nasa.worldwind.avkey.GreatCircle";
        }
        if (n == 2) {
            return "gov.nasa.worldwind.avkey.RhumbLine";
        }
        return "gov.nasa.worldwind.avkey.Linear";
    }

    public boolean isShowControlPoints() {
        return this.showControlPoints;
    }

    public void setShowControlPoints(boolean bl) {
        this.showControlPoints = bl;
        this.controlPointsLayer.setEnabled(bl);
        this.wwd.redraw();
    }

    public boolean isShowAnnotation() {
        return this.showAnnotation;
    }

    public void setShowAnnotation(boolean bl) {
        this.showAnnotation = bl;
    }

    public void clear() {
        while (this.positions.size() > 0 || this.controlPoints.size() > 0) {
            this.removeControlPoint();
        }
        this.shapeCenterPosition = null;
        this.shapeOrientation = null;
        this.shapeRectangle = null;
    }

    public String getMeasureShape() {
        return this.measureShape;
    }

    public void setMeasureShape(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!this.measureShape.equals(string)) {
            this.setArmed(false);
            this.clear();
            this.measureShape = string;
        }
    }

    public void setMeasureShape(String string, Position position, double d) {
        this.setMeasureShape(string, position, d * 2.0, d * 2.0, Angle.ZERO);
    }

    public void setMeasureShape(String string, Position position, double d, double d2, Angle angle) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (position == null) {
            String string3 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (angle == null) {
            String string4 = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (this.isRegularShape(string)) {
            this.setArmed(false);
            this.clear();
            if ((string.equals(SHAPE_CIRCLE) || string.equals(SHAPE_SQUARE)) && d != d2) {
                d = Math.max(d, d2);
                d2 = Math.max(d, d2);
            }
            this.measureShape = string;
            this.shapeCenterPosition = position;
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, d, d2);
            this.shapeOrientation = angle;
            this.updateShapeControlPoints();
            this.updateMeasureShape();
            this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
            this.wwd.redraw();
        }
    }

    public void setMeasureShape(Polyline polyline) {
        if (polyline == null) {
            String string = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setArmed(false);
        this.clear();
        if (this.surfaceShape != null) {
            this.shapeLayer.removeRenderable(this.surfaceShape);
            this.surfaceShape = null;
        }
        if (this.line != null) {
            this.shapeLayer.removeRenderable(this.line);
        }
        this.line = polyline;
        this.shapeLayer.addRenderable(polyline);
        this.setFollowTerrain(polyline.isFollowTerrain());
        this.setPathType(MeasureTool.keyFromPolylinePathType(polyline.getPathType()));
        int n = 0;
        for (Position position : polyline.getPositions()) {
            this.positions.add(position);
            this.addControlPoint(position, "PositionIndex", n++);
        }
        this.measureShape = this.getPathType(this.positions);
        this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
        this.wwd.redraw();
    }

    protected String getPathType(List<? extends Position> list) {
        return list.size() > 2 ? SHAPE_PATH : SHAPE_LINE;
    }

    public void setMeasureShape(SurfaceShape surfaceShape) {
        if (surfaceShape == null) {
            String string = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setArmed(false);
        this.clear();
        if (this.surfaceShape != null) {
            this.shapeLayer.removeRenderable(this.surfaceShape);
        }
        if (this.line != null) {
            this.shapeLayer.removeRenderable(this.line);
            this.line = null;
        }
        this.surfaceShape = surfaceShape;
        this.shapeLayer.addRenderable(surfaceShape);
        this.setPathType(surfaceShape.getPathType());
        if (surfaceShape instanceof SurfaceQuad) {
            this.measureShape = surfaceShape instanceof SurfaceSquare ? SHAPE_SQUARE : SHAPE_QUAD;
            SurfaceQuad surfaceQuad = (SurfaceQuad)surfaceShape;
            this.shapeCenterPosition = new Position(surfaceQuad.getCenter(), 0.0);
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, surfaceQuad.getWidth(), surfaceQuad.getHeight());
            this.shapeOrientation = surfaceQuad.getHeading();
            this.updateShapeControlPoints();
            this.updatePositionsFromShape();
        } else if (surfaceShape instanceof SurfaceEllipse) {
            this.measureShape = surfaceShape instanceof SurfaceCircle ? SHAPE_CIRCLE : SHAPE_ELLIPSE;
            SurfaceEllipse surfaceEllipse = (SurfaceEllipse)surfaceShape;
            this.shapeCenterPosition = new Position(surfaceEllipse.getCenter(), 0.0);
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, surfaceEllipse.getMajorRadius() * 2.0, surfaceEllipse.getMinorRadius() * 2.0);
            this.shapeOrientation = surfaceEllipse.getHeading();
            this.updateShapeControlPoints();
            this.updatePositionsFromShape();
        } else {
            this.measureShape = SHAPE_POLYGON;
            this.updatePositionsFromShape();
            for (int i = 0; i < this.positions.size() - 1; ++i) {
                this.addControlPoint(this.positions.get(i), "PositionIndex", i);
            }
        }
        this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
        this.wwd.redraw();
    }

    public boolean isRegularShape() {
        return this.isRegularShape(this.measureShape);
    }

    protected boolean isRegularShape(String string) {
        return string.equals(SHAPE_CIRCLE) || string.equals(SHAPE_ELLIPSE) || string.equals(SHAPE_QUAD) || string.equals(SHAPE_SQUARE);
    }

    public boolean isFollowTerrain() {
        return this.followTerrain;
    }

    public void setFollowTerrain(boolean bl) {
        this.followTerrain = bl;
        if (this.line != null) {
            this.line.setFollowTerrain(bl);
        }
    }

    public double getLength() {
        if (this.line != null) {
            return this.line.getLength();
        }
        Globe globe = this.wwd.getModel().getGlobe();
        if (this.surfaceShape != null) {
            return this.surfaceShape.getPerimeter(globe);
        }
        return -1.0;
    }

    public double getArea() {
        Globe globe = this.wwd.getModel().getGlobe();
        if (this.surfaceShape != null) {
            return this.surfaceShape.getArea(globe, this.followTerrain);
        }
        return -1.0;
    }

    public double getWidth() {
        if (this.shapeRectangle != null) {
            return this.shapeRectangle.width;
        }
        return -1.0;
    }

    public double getHeight() {
        if (this.shapeRectangle != null) {
            return this.shapeRectangle.height;
        }
        return -1.0;
    }

    public Angle getOrientation() {
        return this.shapeOrientation;
    }

    public Position getCenterPosition() {
        return this.shapeCenterPosition;
    }

    public void addControlPoint() {
        Position position = this.wwd.getCurrentPosition();
        if (position == null) {
            return;
        }
        if (this.isRegularShape()) {
            if (this.shapeCenterPosition == null) {
                this.shapeCenterPosition = position;
                this.updateShapeControlPoints();
            } else if (this.shapeRectangle == null) {
                this.updateShapeProperties("East", position);
                this.updateShapeControlPoints();
            }
        } else if (!this.measureShape.equals(SHAPE_POLYGON) || this.positions.size() <= 1) {
            this.positions.add(position);
            this.addControlPoint(this.positions.get(this.positions.size() - 1), "PositionIndex", this.positions.size() - 1);
            if (this.measureShape.equals(SHAPE_POLYGON) && this.positions.size() == 2) {
                this.positions.add(this.positions.get(0));
            }
            if (this.measureShape.equals(SHAPE_LINE) && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
        } else {
            this.positions.add(this.positions.size() - 1, position);
            this.addControlPoint(this.positions.get(this.positions.size() - 2), "PositionIndex", this.positions.size() - 2);
        }
        this.updateMeasureShape();
        this.firePropertyChange(EVENT_POSITION_ADD, null, position);
        this.wwd.redraw();
    }

    public void removeControlPoint() {
        Position position = null;
        if (this.isRegularShape()) {
            if (this.shapeRectangle != null) {
                this.shapeRectangle = null;
                this.shapeOrientation = null;
                this.positions.clear();
                while (this.controlPoints.size() > 1) {
                    this.controlPoints.remove(1);
                }
            } else if (this.shapeCenterPosition != null) {
                this.shapeCenterPosition = null;
                this.controlPoints.clear();
            }
        } else {
            if (this.positions.size() == 0) {
                return;
            }
            if (!this.measureShape.equals(SHAPE_POLYGON) || this.positions.size() == 1) {
                position = this.positions.get(this.positions.size() - 1);
                this.positions.remove(this.positions.size() - 1);
            } else {
                position = this.positions.get(this.positions.size() - 2);
                this.positions.remove(this.positions.size() - 2);
                if (this.positions.size() == 2) {
                    this.positions.remove(1);
                }
            }
            if (this.controlPoints.size() > 0) {
                this.controlPoints.remove(this.controlPoints.size() - 1);
            }
        }
        this.controlPointsLayer.setRenderables(this.controlPoints);
        this.updateMeasureShape();
        this.firePropertyChange(EVENT_POSITION_REMOVE, position, null);
        this.wwd.redraw();
    }

    public void moveControlPoint(ControlPoint controlPoint) {
        if (controlPoint == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (controlPoint.getValue("Control") != null) {
            this.updateShapeProperties((String)controlPoint.getValue("Control"), controlPoint.getPosition());
            this.updateShapeControlPoints();
        }
        if (controlPoint.getValue("PositionIndex") != null) {
            int n = (Integer)controlPoint.getValue("PositionIndex");
            Position position = this.computeSurfacePosition(controlPoint.getPosition());
            this.positions.set(n, position);
            if (this.measureShape.equals(SHAPE_POLYGON) && this.positions.size() > 2 && n == 0) {
                this.positions.set(this.positions.size() - 1, position);
            }
            if (this.measureShape.equals(SHAPE_LINE) && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
        }
        this.updateMeasureShape();
    }

    public void moveMeasureShape(Angle angle, Angle angle2) {
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isRegularShape()) {
            if (this.controlPoints.size() > 0) {
                ControlPoint controlPoint = (ControlPoint)this.controlPoints.get(0);
                controlPoint.setPosition(new Position(LatLon.greatCircleEndPosition((LatLon)controlPoint.getPosition(), angle, angle2), 0.0));
                this.moveControlPoint(controlPoint);
            }
        } else {
            for (int i = 0; i < this.positions.size(); ++i) {
                Position position = this.computeSurfacePosition(LatLon.greatCircleEndPosition((LatLon)this.positions.get(i), angle, angle2));
                this.positions.set(i, position);
                if (this.measureShape.equals(SHAPE_POLYGON) && i >= this.positions.size() - 1) continue;
                ((ControlPoint)this.controlPoints.get(i)).setPosition(new Position(position, 0.0));
            }
            if (this.measureShape.equals(SHAPE_LINE) && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
            this.updateMeasureShape();
        }
    }

    protected Position computeSurfacePosition(LatLon latLon) {
        Vec4 vec4 = this.wwd.getSceneController().getTerrain().getSurfacePoint(latLon.getLatitude(), latLon.getLongitude());
        if (vec4 != null) {
            return this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        }
        return new Position(latLon, this.wwd.getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()));
    }

    protected void updateShapeProperties(String string, Position position) {
        if (string.equals("Center")) {
            this.shapeCenterPosition = position;
        } else {
            double d;
            double d2;
            double d3 = string.equals("East") ? 90.0 : (string.equals("South") ? 180.0 : (string.equals("West") ? 270.0 : 0.0));
            this.shapeOrientation = LatLon.greatCircleAzimuth(this.shapeCenterPosition, position).subtractDegrees(d3);
            Angle angle = LatLon.greatCircleDistance(this.shapeCenterPosition, position);
            double d4 = Math.max(angle.radians * this.wwd.getModel().getGlobe().getRadius(), 0.1);
            if (string.equals("East") || string.equals("West")) {
                d2 = d4 * 2.0;
                double d5 = d = this.shapeRectangle != null ? this.shapeRectangle.height : d2;
                if (this.measureShape.equals(SHAPE_CIRCLE) || this.measureShape.equals(SHAPE_SQUARE)) {
                    d = d2;
                } else if (this.controller != null && this.controller.isActive()) {
                    d = d2 * 0.6;
                }
            } else {
                d = d4 * 2.0;
                double d6 = d2 = this.shapeRectangle != null ? this.shapeRectangle.width : d;
                if (this.measureShape.equals(SHAPE_CIRCLE) || this.measureShape.equals(SHAPE_SQUARE)) {
                    d2 = d;
                } else if (this.controller != null && this.controller.isActive()) {
                    d2 = d * 0.6;
                }
            }
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, d2, d);
        }
    }

    protected void updateShapeControlPoints() {
        if (this.shapeCenterPosition != null && this.controlPoints.size() < 1) {
            this.addControlPoint(Position.ZERO, "Control", "Center");
        }
        if (this.shapeCenterPosition != null) {
            ((ControlPoint)this.controlPoints.get(0)).setPosition(new Position(this.shapeCenterPosition, 0.0));
        }
        if (this.shapeRectangle != null && this.controlPoints.size() < 5) {
            this.addControlPoint(Position.ZERO, "Control", "North");
            this.addControlPoint(Position.ZERO, "Control", "East");
            this.addControlPoint(Position.ZERO, "Control", "South");
            this.addControlPoint(Position.ZERO, "Control", "West");
        }
        if (this.shapeRectangle != null) {
            Angle angle = Angle.fromRadians(this.shapeRectangle.width / 2.0 / this.wwd.getModel().getGlobe().getRadius());
            Angle angle2 = Angle.fromRadians(this.shapeRectangle.height / 2.0 / this.wwd.getModel().getGlobe().getRadius());
            Position position = new Position(LatLon.greatCircleEndPosition((LatLon)this.shapeCenterPosition, this.shapeOrientation, angle2), 0.0);
            ((ControlPoint)this.controlPoints.get(1)).setPosition(position);
            position = new Position(LatLon.greatCircleEndPosition((LatLon)this.shapeCenterPosition, this.shapeOrientation.addDegrees(90.0), angle), 0.0);
            ((ControlPoint)this.controlPoints.get(2)).setPosition(position);
            position = new Position(LatLon.greatCircleEndPosition((LatLon)this.shapeCenterPosition, this.shapeOrientation.addDegrees(180.0), angle2), 0.0);
            ((ControlPoint)this.controlPoints.get(3)).setPosition(position);
            position = new Position(LatLon.greatCircleEndPosition((LatLon)this.shapeCenterPosition, this.shapeOrientation.addDegrees(270.0), angle), 0.0);
            ((ControlPoint)this.controlPoints.get(4)).setPosition(position);
        }
    }

    protected void updateMeasureShape() {
        if (this.measureShape.equals(SHAPE_LINE) || this.measureShape.equals(SHAPE_PATH)) {
            if (this.positions.size() > 1 && this.line == null) {
                this.line = new Polyline();
                this.line.setFollowTerrain(this.isFollowTerrain());
                this.line.setLineWidth(this.getLineWidth());
                this.line.setColor(this.getLineColor());
                this.line.setPathType(MeasureTool.polylinePathTypeFromKey(this.getPathType()));
                this.shapeLayer.addRenderable(this.line);
            }
            if (this.positions.size() < 2 && this.line != null) {
                this.shapeLayer.removeRenderable(this.line);
                this.line = null;
            }
            if (this.positions.size() > 1 && this.line != null) {
                this.line.setPositions(this.positions);
            }
            if (this.surfaceShape != null) {
                this.shapeLayer.removeRenderable(this.surfaceShape);
                this.surfaceShape = null;
            }
        } else if (this.measureShape.equals(SHAPE_POLYGON)) {
            if (this.positions.size() >= 4 && this.surfaceShape == null) {
                this.surfaceShape = new SurfacePolygon(this.positions);
                this.surfaceShape.getAttributes().setInteriorMaterial(new Material(this.getFillColor()));
                this.surfaceShape.getAttributes().setInteriorOpacity((double)this.getFillColor().getAlpha() / 255.0);
                this.surfaceShape.getAttributes().setOutlineMaterial(new Material(this.getLineColor()));
                this.surfaceShape.getAttributes().setOutlineOpacity((double)this.getLineColor().getAlpha() / 255.0);
                this.surfaceShape.getAttributes().setOutlineWidth(this.getLineWidth());
                this.shapeLayer.addRenderable(this.surfaceShape);
            }
            if (this.positions.size() <= 3 && this.surfaceShape != null) {
                this.shapeLayer.removeRenderable(this.surfaceShape);
                this.surfaceShape = null;
            }
            if (this.surfaceShape != null) {
                ((SurfacePolygon)this.surfaceShape).setLocations(this.positions);
            }
            if (this.line != null) {
                this.shapeLayer.removeRenderable(this.line);
                this.line = null;
            }
        } else if (this.isRegularShape()) {
            if (this.shapeCenterPosition != null && this.shapeRectangle != null && this.surfaceShape == null) {
                if (this.measureShape.equals(SHAPE_QUAD)) {
                    this.surfaceShape = new SurfaceQuad(this.shapeCenterPosition, this.shapeRectangle.width, this.shapeRectangle.height, this.shapeOrientation);
                } else if (this.measureShape.equals(SHAPE_SQUARE)) {
                    this.surfaceShape = new SurfaceSquare(this.shapeCenterPosition, this.shapeRectangle.width);
                } else if (this.measureShape.equals(SHAPE_ELLIPSE)) {
                    this.surfaceShape = new SurfaceEllipse(this.shapeCenterPosition, this.shapeRectangle.width / 2.0, this.shapeRectangle.height / 2.0, this.shapeOrientation, this.shapeIntervals);
                } else if (this.measureShape.equals(SHAPE_CIRCLE)) {
                    this.surfaceShape = new SurfaceCircle(this.shapeCenterPosition, this.shapeRectangle.width / 2.0, this.shapeIntervals);
                }
                this.surfaceShape.getAttributes().setInteriorMaterial(new Material(this.getFillColor()));
                this.surfaceShape.getAttributes().setInteriorOpacity((double)this.getFillColor().getAlpha() / 255.0);
                this.surfaceShape.getAttributes().setOutlineMaterial(new Material(this.getLineColor()));
                this.surfaceShape.getAttributes().setOutlineOpacity((double)this.getLineColor().getAlpha() / 255.0);
                this.surfaceShape.getAttributes().setOutlineWidth(this.getLineWidth());
                this.shapeLayer.addRenderable(this.surfaceShape);
            }
            if (this.shapeRectangle == null && this.surfaceShape != null) {
                this.shapeLayer.removeRenderable(this.surfaceShape);
                this.surfaceShape = null;
                this.positions.clear();
            }
            if (this.surfaceShape != null) {
                if (this.measureShape.equals(SHAPE_QUAD) || this.measureShape.equals(SHAPE_SQUARE)) {
                    ((SurfaceQuad)this.surfaceShape).setCenter(this.shapeCenterPosition);
                    ((SurfaceQuad)this.surfaceShape).setSize(this.shapeRectangle.width, this.shapeRectangle.height);
                    ((SurfaceQuad)this.surfaceShape).setHeading(this.shapeOrientation);
                }
                if (this.measureShape.equals(SHAPE_ELLIPSE) || this.measureShape.equals(SHAPE_CIRCLE)) {
                    ((SurfaceEllipse)this.surfaceShape).setCenter(this.shapeCenterPosition);
                    ((SurfaceEllipse)this.surfaceShape).setRadii(this.shapeRectangle.width / 2.0, this.shapeRectangle.height / 2.0);
                    ((SurfaceEllipse)this.surfaceShape).setHeading(this.shapeOrientation);
                }
                this.updatePositionsFromShape();
            }
            if (this.line != null) {
                this.shapeLayer.removeRenderable(this.line);
                this.line = null;
            }
        }
    }

    protected void updatePositionsFromShape() {
        Globe globe = this.wwd.getModel().getGlobe();
        this.positions.clear();
        for (LatLon latLon : this.surfaceShape.getLocations(globe)) {
            this.positions.add(new Position(latLon, 0.0));
        }
    }

    @Override
    public void dispose() {
        this.setController(null);
        if (this.applicationLayer != null) {
            this.applicationLayer.removeRenderable(this.layer);
        } else {
            this.wwd.getModel().getLayers().remove(this.layer);
        }
        this.layer.removeAllRenderables();
        this.shapeLayer.removeAllRenderables();
        this.controlPointsLayer.removeAllRenderables();
    }

    protected void addControlPoint(Position position, String string, Object object) {
        ControlPoint controlPoint = new ControlPoint(new Position(position, 0.0), this.controlPointsAttributes, this);
        controlPoint.setValue(string, object);
        this.controlPoints.add(controlPoint);
        this.controlPointsLayer.setRenderables(this.controlPoints);
    }

    public void updateAnnotation(Position position) {
        if (position != null) {
            Object object;
            String string = "";
            if (this.measureShape.equals(SHAPE_CIRCLE) && this.shapeRectangle != null) {
                string = string + "Radius " + this.formatLength(this.shapeRectangle.width / 2.0);
            } else if (this.measureShape.equals(SHAPE_SQUARE) && this.shapeRectangle != null) {
                string = string + "Size " + this.formatLength(this.shapeRectangle.width);
            } else if (this.measureShape.equals(SHAPE_QUAD) && this.shapeRectangle != null) {
                string = string + "Width " + this.formatLength(this.shapeRectangle.width) + "\n" + "Height " + this.formatLength(this.shapeRectangle.height);
            } else if (this.measureShape.equals(SHAPE_ELLIPSE) && this.shapeRectangle != null) {
                string = string + "Major " + this.formatLength(this.shapeRectangle.width) + "\n" + "Minor " + this.formatLength(this.shapeRectangle.height);
            } else if (this.measureShape.equals(SHAPE_LINE) || this.measureShape.equals(SHAPE_PATH)) {
                string = string + "Length " + this.formatLength(this.getLength()) + "\n";
                string = string + String.format("Lat %7.4f\u00b0 Lon %7.4f\u00b0", position.getLatitude().degrees, position.getLongitude().degrees);
            } else if (this.measureShape.equals(SHAPE_POLYGON)) {
                string = string + "Perimeter " + this.formatLength(this.getLength()) + "\n";
                string = string + "Area " + this.formatArea(this.getArea()) + "\n";
                string = string + String.format("Lat %7.4f\u00b0 Lon %7.4f\u00b0", position.getLatitude().degrees, position.getLongitude().degrees);
            }
            this.annotation.setText(string);
            Vec4 vec4 = this.wwd.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude());
            if (vec4 == null) {
                object = this.wwd.getModel().getGlobe();
                vec4 = object.computePointFromPosition(position.getLatitude(), position.getLongitude(), object.getElevation(position.getLatitude(), position.getLongitude()));
            }
            if ((object = this.wwd.getView().project(vec4)) != null) {
                this.annotation.setScreenPoint(new Point((int)((Vec4)object).x, (int)((Vec4)object).y));
            }
            this.annotation.getAttributes().setVisible(true);
        } else {
            this.annotation.getAttributes().setVisible(false);
        }
    }

    protected String formatLength(double d) {
        String string = d <= 0.0 ? "na" : (d < 1000.0 ? String.format("%,7.1f m", d) : String.format("%,7.3f km", d / 1000.0));
        return string;
    }

    protected String formatArea(double d) {
        String string = d <= 0.0 ? "na" : (d < 1000000.0 ? String.format("%,7.1f m2", d) : String.format("%,7.3f km2", d / 1000000.0));
        return string;
    }

    public class ControlPoint
    extends GlobeAnnotation {
        MeasureTool parent;

        public ControlPoint(Position position, AnnotationAttributes annotationAttributes, MeasureTool measureTool2) {
            super("", position, annotationAttributes);
            this.parent = measureTool2;
        }

        public MeasureTool getParent() {
            return this.parent;
        }
    }

    protected class CustomRenderableLayer
    extends RenderableLayer
    implements PreRenderable,
    Renderable {
        protected CustomRenderableLayer() {
        }

        public void render(DrawContext drawContext) {
            if (drawContext.isPickingMode() && !this.isPickEnabled()) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            super.render(drawContext);
        }
    }
}

