/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.OrbitViewAnimator;
import gov.nasa.worldwind.view.OrbitViewInterpolator;

public class BasicOrbitViewStateIterator
implements ViewStateIterator {
    private final boolean doCoalesce;
    private final OrbitViewInterpolator interpolator;
    private final OrbitViewAnimator animator;
    private boolean hasNext = true;

    public BasicOrbitViewStateIterator(boolean bl, OrbitViewInterpolator orbitViewInterpolator, OrbitViewAnimator orbitViewAnimator) {
        if (orbitViewInterpolator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewStateIterator.InterpolatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewAnimator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewStateIterator.AnimatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doCoalesce = bl;
        this.interpolator = orbitViewInterpolator;
        this.animator = orbitViewAnimator;
    }

    public final boolean isCoalesce() {
        return this.doCoalesce;
    }

    public final void nextState(View view) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!(view instanceof OrbitView)) {
            String string = Logging.getMessage("view.OrbitView.ViewNotAnOrbitView");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.interpolator.nextInterpolant((OrbitView)view);
        double d2 = BasicOrbitViewStateIterator.clampDouble(d, 0.0, 1.0);
        if (d2 >= 1.0) {
            this.stop();
        }
        this.doNextState(d2, (OrbitView)view);
        view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
    }

    private static double clampDouble(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    protected void doNextState(double d, OrbitView orbitView) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.animator.doNextState(d, orbitView, this);
    }

    public final boolean hasNextState(View view) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!(view instanceof OrbitView)) {
            String string = Logging.getMessage("view.OrbitView.ViewNotAnOrbitView");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.hasNext;
    }

    public final void stop() {
        this.hasNext = false;
    }

    public final ViewStateIterator coalesceWith(View view, ViewStateIterator viewStateIterator) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!(view instanceof OrbitView)) {
            String string = Logging.getMessage("view.OrbitView.ViewNotAnOrbitView");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (viewStateIterator == null || !(viewStateIterator instanceof BasicOrbitViewStateIterator)) {
            return this;
        }
        if (!this.doCoalesce) {
            return this;
        }
        boolean bl = this.doCoalesce;
        OrbitViewInterpolator orbitViewInterpolator = this.interpolator.coalesceWith((OrbitView)view, ((BasicOrbitViewStateIterator)viewStateIterator).interpolator);
        OrbitViewAnimator orbitViewAnimator = this.animator.coalesceWith((OrbitView)view, ((BasicOrbitViewStateIterator)viewStateIterator).animator);
        return this.doCoalesce((OrbitView)view, bl, orbitViewInterpolator, orbitViewAnimator);
    }

    protected ViewStateIterator doCoalesce(OrbitView orbitView, boolean bl, OrbitViewInterpolator orbitViewInterpolator, OrbitViewAnimator orbitViewAnimator) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewInterpolator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewStateIterator.InterpolatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewAnimator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewStateIterator.AnimatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new BasicOrbitViewStateIterator(bl, orbitViewInterpolator, orbitViewAnimator);
    }
}

