/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.BasicOrbitViewAnimator;
import gov.nasa.worldwind.view.BasicOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.OrbitViewAnimator;
import gov.nasa.worldwind.view.OrbitViewPropertyAccessor;
import gov.nasa.worldwind.view.ScheduledOrbitViewInterpolator;

public class FlyToOrbitViewStateIterator
extends BasicOrbitViewStateIterator {
    protected FlyToOrbitViewStateIterator(long l, OrbitViewAnimator orbitViewAnimator) {
        super(false, new ScheduledOrbitViewInterpolator(l), orbitViewAnimator);
    }

    public static FlyToOrbitViewStateIterator createPanToIterator(OrbitView orbitView, Globe globe, Position position, Angle angle, Angle angle2, double d) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = orbitView.getCenterPosition();
        Angle angle3 = orbitView.getHeading();
        Angle angle4 = orbitView.getPitch();
        double d2 = orbitView.getZoom();
        return FlyToOrbitViewStateIterator.createPanToIterator(globe, position2, position, angle3, angle, angle4, angle2, d2, d);
    }

    public static FlyToOrbitViewStateIterator createPanToIterator(OrbitView orbitView, Globe globe, Position position, Angle angle, Angle angle2, double d, boolean bl) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = orbitView.getCenterPosition();
        Angle angle3 = orbitView.getHeading();
        Angle angle4 = orbitView.getPitch();
        double d2 = orbitView.getZoom();
        return FlyToOrbitViewStateIterator.createPanToIterator(globe, position2, position, angle3, angle, angle4, angle2, d2, d, bl);
    }

    public static FlyToOrbitViewStateIterator createPanToIterator(Globe globe, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = FlyToOrbitViewStateIterator.getScaledLengthMillis(position, position2, 4000L, 16000L);
        return FlyToOrbitViewStateIterator.createPanToIterator(globe, position, position2, angle, angle2, angle3, angle4, d, d2, l);
    }

    public static FlyToOrbitViewStateIterator createPanToIterator(Globe globe, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, boolean bl) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = FlyToOrbitViewStateIterator.getScaledLengthMillis(position, position2, 4000L, 16000L);
        return FlyToOrbitViewStateIterator.createPanToIterator(globe, position, position2, angle, angle2, angle3, angle4, d, d2, l, bl);
    }

    public static FlyToOrbitViewStateIterator createPanToIterator(Globe globe, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        PanAnimator panAnimator = new PanAnimator(globe, position, position2, angle, angle2, angle3, angle4, d, d2);
        return new FlyToOrbitViewStateIterator(l, panAnimator);
    }

    public static FlyToOrbitViewStateIterator createPanToIterator(Globe globe, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l, boolean bl) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        PanAnimator panAnimator = new PanAnimator(globe, position, position2, angle, angle2, angle3, angle4, d, d2, bl);
        return new FlyToOrbitViewStateIterator(l, panAnimator);
    }

    public static FlyToOrbitViewStateIterator createZoomToIterator(OrbitView orbitView, Angle angle, Angle angle2, double d) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle3 = orbitView.getHeading();
        Angle angle4 = orbitView.getPitch();
        double d2 = orbitView.getZoom();
        return FlyToOrbitViewStateIterator.createZoomToIterator(angle3, angle, angle4, angle2, d2, d);
    }

    public static FlyToOrbitViewStateIterator createZoomToIterator(Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = FlyToOrbitViewStateIterator.getScaledLengthMillis(d, d2, 1000L, 8000L);
        return FlyToOrbitViewStateIterator.createZoomToIterator(angle, angle2, angle3, angle4, d, d2, l);
    }

    public static FlyToOrbitViewStateIterator createZoomToIterator(Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ZoomAnimator zoomAnimator = new ZoomAnimator(angle, angle2, angle3, angle4, d, d2);
        return new FlyToOrbitViewStateIterator(l, zoomAnimator);
    }

    private static long getScaledLengthMillis(double d, double d2, long l, long l2) {
        double d3 = Math.abs(d2 - d) / Math.max(d2, d);
        d3 = FlyToOrbitViewStateIterator.clampDouble(d3, 0.0, 1.0);
        return (long)FlyToOrbitViewStateIterator.mixDouble(d3, l, l2);
    }

    private static long getScaledLengthMillis(LatLon latLon, LatLon latLon2, long l, long l2) {
        Angle angle = LatLon.greatCircleDistance(latLon, latLon2);
        double d = FlyToOrbitViewStateIterator.angularRatio(angle, Angle.POS180);
        return (long)FlyToOrbitViewStateIterator.mixDouble(d, l, l2);
    }

    private static double interpolantNormalized(double d, double d2, double d3) {
        if (d < d2) {
            return 0.0;
        }
        if (d > d3) {
            return 1.0;
        }
        return (d - d2) / (d3 - d2);
    }

    private static double interpolantSmoothed(double d, int n) {
        double d2 = d;
        for (int i = 0; i < n; ++i) {
            d2 = d2 * d2 * (3.0 - 2.0 * d2);
        }
        return d2;
    }

    private static double basicInterpolant(double d, double d2, double d3, int n) {
        double d4 = FlyToOrbitViewStateIterator.interpolantNormalized(d, d2, d3);
        return FlyToOrbitViewStateIterator.interpolantSmoothed(d4, n);
    }

    private static double angularRatio(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.divide(angle2);
        return FlyToOrbitViewStateIterator.clampDouble(d, 0.0, 1.0);
    }

    private static double clampDouble(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    private static double mixDouble(double d, double d2, double d3) {
        if (d < 0.0) {
            return d2;
        }
        if (d > 1.0) {
            return d3;
        }
        return d2 * (1.0 - d) + d3 * d;
    }

    private static class ZoomAnimator
    extends BasicOrbitViewAnimator {
        private final OrbitViewAnimator headingAnimator;
        private final OrbitViewAnimator pitchAnimator;
        private final OrbitViewAnimator zoomAnimator;

        private ZoomAnimator(Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2) {
            this.headingAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle, angle2, OrbitViewPropertyAccessor.createHeadingAccessor());
            this.pitchAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle3, angle4, OrbitViewPropertyAccessor.createPitchAccessor());
            this.zoomAnimator = new BasicOrbitViewAnimator.DoubleAnimator(d, d2, OrbitViewPropertyAccessor.createZoomAccessor());
        }

        protected void doNextStateImpl(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            if (orbitView == null) {
                String string = Logging.getMessage("nullValue.OrbitViewIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (basicOrbitViewStateIterator == null) {
                String string = Logging.getMessage("nullValue.OrbitViewStateIteratorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.nextZoomState(d, orbitView, basicOrbitViewStateIterator);
            this.nextHeadingState(d, orbitView, basicOrbitViewStateIterator);
            this.nextPitchState(d, orbitView, basicOrbitViewStateIterator);
        }

        private void nextHeadingState(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            double d2 = FlyToOrbitViewStateIterator.basicInterpolant(d, 0.0, 0.6, 1);
            this.headingAnimator.doNextState(d2, orbitView, basicOrbitViewStateIterator);
        }

        private void nextPitchState(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            double d2 = FlyToOrbitViewStateIterator.basicInterpolant(d, 0.0, 0.6, 1);
            this.pitchAnimator.doNextState(d2, orbitView, basicOrbitViewStateIterator);
        }

        private void nextZoomState(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            double d2 = FlyToOrbitViewStateIterator.basicInterpolant(d, 0.0, 1.0, 1);
            this.zoomAnimator.doNextState(d2, orbitView, basicOrbitViewStateIterator);
        }
    }

    private static class PanAnimator
    extends BasicOrbitViewAnimator {
        private final Globe globe;
        private final OrbitViewAnimator centerAnimator;
        private final OrbitViewAnimator zoomAnimator;
        private final OrbitViewAnimator headingAnimator;
        private final OrbitViewAnimator pitchAnimator;
        private final OrbitViewAnimator beginToMidZoomAnimator;
        private final OrbitViewAnimator endToMidZoomAnimator;
        private final boolean useMidZoom;
        private final boolean endCenterOnSurface;

        private PanAnimator(Globe globe, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2) {
            this(globe, position, position2, angle, angle2, angle3, angle4, d, d2, false);
        }

        private PanAnimator(Globe globe, Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, boolean bl) {
            this.globe = globe;
            this.endCenterOnSurface = bl;
            this.centerAnimator = this.createPositionAnimator(position, position2);
            this.zoomAnimator = new BasicOrbitViewAnimator.DoubleAnimator(d, d2, OrbitViewPropertyAccessor.createZoomAccessor());
            this.headingAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle, angle2, OrbitViewPropertyAccessor.createHeadingAccessor());
            this.pitchAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle3, angle4, OrbitViewPropertyAccessor.createPitchAccessor());
            double d3 = PanAnimator.computeMidZoom(this.globe, position, position2, d, d2);
            this.useMidZoom = PanAnimator.useMidZoom(d, d2, d3);
            this.beginToMidZoomAnimator = new BasicOrbitViewAnimator.DoubleAnimator(d, d3, OrbitViewPropertyAccessor.createZoomAccessor());
            this.endToMidZoomAnimator = new BasicOrbitViewAnimator.DoubleAnimator(d2, d3, OrbitViewPropertyAccessor.createZoomAccessor());
        }

        private BasicOrbitViewAnimator.PositionAnimator createPositionAnimator(Position position, Position position2) {
            return new BasicOrbitViewAnimator.PositionAnimator(position, position2, OrbitViewPropertyAccessor.createCenterPositionAccessor()){

                public Position nextPosition(double d, OrbitView orbitView) {
                    Position position = super.nextPosition(d, orbitView);
                    if (PanAnimator.this.endCenterOnSurface) {
                        Position position2 = position;
                        double d2 = this.getBegin().getElevation();
                        double d3 = PanAnimator.this.globe.getElevation(this.getEnd().getLatitude(), this.getEnd().getLongitude());
                        position = new Position(position2, (1.0 - d) * d2 + d * d3);
                    }
                    return position;
                }
            };
        }

        private static double computeMidZoom(Globe globe, LatLon latLon, LatLon latLon2, double d, double d2) {
            Angle angle = LatLon.greatCircleDistance(latLon, latLon2);
            double d3 = FlyToOrbitViewStateIterator.angularRatio(angle, Angle.POS180);
            double d4 = Math.min(d, d2);
            double d5 = 3.0 * globe.getRadius();
            return FlyToOrbitViewStateIterator.mixDouble(d3, d4, d5);
        }

        private static boolean useMidZoom(double d, double d2, double d3) {
            double d4;
            double d5 = Math.abs(d2 - d);
            return d5 < (d4 = Math.abs(d3 - Math.max(d, d2)));
        }

        protected void doNextStateImpl(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            if (orbitView == null) {
                String string = Logging.getMessage("nullValue.OrbitViewIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (basicOrbitViewStateIterator == null) {
                String string = Logging.getMessage("nullValue.OrbitViewStateIteratorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.nextCenterState(d, orbitView, basicOrbitViewStateIterator);
            this.nextZoomState(d, orbitView, basicOrbitViewStateIterator);
            this.nextHeadingState(d, orbitView, basicOrbitViewStateIterator);
            this.nextPitchState(d, orbitView, basicOrbitViewStateIterator);
        }

        private void nextCenterState(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            double d2 = this.useMidZoom ? 0.2 : 0.0;
            double d3 = this.useMidZoom ? 0.8 : 0.8;
            double d4 = FlyToOrbitViewStateIterator.basicInterpolant(d, d2, d3, 1);
            this.centerAnimator.doNextState(d4, orbitView, basicOrbitViewStateIterator);
        }

        private void nextHeadingState(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            double d2 = this.useMidZoom ? 0.0 : 0.6;
            double d3 = FlyToOrbitViewStateIterator.basicInterpolant(d, d2, 1.0, 1);
            this.headingAnimator.doNextState(d3, orbitView, basicOrbitViewStateIterator);
        }

        private void nextPitchState(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            double d2 = FlyToOrbitViewStateIterator.basicInterpolant(d, 0.0, 0.8, 1);
            this.pitchAnimator.doNextState(d2, orbitView, basicOrbitViewStateIterator);
        }

        private void nextZoomState(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            if (this.useMidZoom) {
                double d2 = this.zoomInterpolant(d, 0.0, 1.0, 1);
                if (d <= 0.5) {
                    this.beginToMidZoomAnimator.doNextState(d2, orbitView, basicOrbitViewStateIterator);
                } else {
                    this.endToMidZoomAnimator.doNextState(d2, orbitView, basicOrbitViewStateIterator);
                }
            } else {
                double d3 = FlyToOrbitViewStateIterator.basicInterpolant(d, 0.0, 1.0, 1);
                this.zoomAnimator.doNextState(d3, orbitView, basicOrbitViewStateIterator);
            }
        }

        private double zoomInterpolant(double d, double d2, double d3, int n) {
            double d4 = FlyToOrbitViewStateIterator.interpolantNormalized(d, d2, d3);
            d4 = d4 <= 0.5 ? 2.0 * d4 : 1.0 - (2.0 * d4 - 1.0);
            return FlyToOrbitViewStateIterator.interpolantSmoothed(d4, n);
        }
    }
}

