/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.wms;

import gov.nasa.worldwind.exception.ServiceException;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.wms.BoundingBox;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import gov.nasa.worldwind.wms.CapabilitiesV111;
import gov.nasa.worldwind.wms.CapabilitiesV130;
import gov.nasa.worldwind.wms.SimpleNamespaceContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Capabilities {
    public static final String WMS_SERVICE_NAME = "OGC:WMS";
    protected Document doc;
    protected Element service;
    protected Element capability;
    protected XPath xpath;
    private HashMap<Element, Layer> namedLayerElements = new HashMap();
    private HashMap<String, Layer> namedLayers = new HashMap();
    protected HashMap<Element, Style> styleElements = new HashMap();

    public static Capabilities retrieve(URI uRI, String string) throws Exception {
        return Capabilities.retrieve(uRI, string, null, null);
    }

    public static Capabilities retrieve(URI uRI, Integer n, Integer n2) throws Exception {
        return Capabilities.retrieve(uRI, null, n, n2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Capabilities retrieve(URI uRI, String string, Integer n, Integer n2) throws Exception {
        Capabilities capabilities;
        if (uRI == null) {
            String string2 = Logging.getMessage("nullValue.URIIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        InputStream inputStream = null;
        try {
            CapabilitiesRequest capabilitiesRequest = new CapabilitiesRequest(uRI, string);
            URL uRL = capabilitiesRequest.getUri().toURL();
            URLRetriever uRLRetriever = URLRetriever.createRetriever(uRL, new RetrievalPostProcessor(){

                public ByteBuffer run(Retriever retriever) {
                    return retriever.getBuffer();
                }
            });
            if (uRLRetriever == null) {
                String string3 = Logging.getMessage("generic.UnrecognizedProtocol");
                Logging.logger().severe(string3);
                throw new WWRuntimeException(string3);
            }
            if (n != null) {
                uRLRetriever.setConnectTimeout(n);
            }
            if (n2 != null) {
                uRLRetriever.setReadTimeout(n2);
            }
            uRLRetriever.call();
            if (!uRLRetriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                String string4 = Logging.getMessage("generic.RetrievalFailed", uRI.toString());
                Logging.logger().severe(string4);
                throw new WWRuntimeException(string4);
            }
            if (uRLRetriever.getBuffer() == null || uRLRetriever.getBuffer().limit() == 0) {
                String string5 = Logging.getMessage("generic.RetrievalReturnedNoContent", uRI.toString());
                Logging.logger().severe(string5);
                throw new WWRuntimeException(string5);
            }
            if (uRLRetriever.getContentType().equalsIgnoreCase("application/vnd.ogc.se_xml")) {
                String string6 = WWXML.extractOGCServiceException(uRLRetriever.getBuffer());
                String string7 = Logging.getMessage("OGC.ServiceException", uRI.toString() + ": " + string6 != null ? string6 : "");
                Logging.logger().severe(string7);
                throw new WWRuntimeException(string7);
            }
            inputStream = WWIO.getInputStreamFromByteBuffer(uRLRetriever.getBuffer());
            capabilities = Capabilities.parse(WWXML.createDocumentBuilder(true).parse(inputStream));
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.URIInvalid", uRI.toString()), uRISyntaxException);
                throw uRISyntaxException;
                catch (ParserConfigurationException parserConfigurationException) {
                    Logging.logger().fine(Logging.getMessage("WMS.ParserConfigurationException", uRI.toString()));
                    throw parserConfigurationException;
                }
                catch (IOException iOException) {
                    Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionAttemptingToReadFrom", uRI.toString()), iOException);
                    throw iOException;
                }
                catch (SAXException sAXException) {
                    Logging.logger().fine(Logging.getMessage("WMS.ParsingError", uRI.toString()));
                    throw sAXException;
                }
            }
            catch (Throwable throwable) {
                WWIO.closeStream(inputStream, uRI.toString());
                throw throwable;
            }
        }
        WWIO.closeStream(inputStream, uRI.toString());
        return capabilities;
    }

    public static Capabilities parse(Document document) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        simpleNamespaceContext.addNamespace("", "http://www.opengis.net/wms");
        xPath.setNamespaceContext(new SimpleNamespaceContext());
        try {
            String string = WWXML.checkOGCException(document);
            if (string != null) {
                String string2 = Logging.getMessage("WMS.ServiceException", string);
                Logging.logger().severe(string2);
                throw new ServiceException(string);
            }
            String string3 = xPath.evaluate(Capabilities.altPaths("*/@wms:version"), document);
            if (string3 == null || string3.length() == 0) {
                return null;
            }
            if (string3.compareTo("1.3") < 0) {
                return new CapabilitiesV111(document, xPath);
            }
            return new CapabilitiesV130(document, xPath);
        }
        catch (XPathExpressionException xPathExpressionException) {
            Logging.logger().log(Level.SEVERE, "WMS.ParsingError", xPathExpressionException);
            return null;
        }
    }

    protected Capabilities(Document document, XPath xPath) {
        this.doc = document;
        this.xpath = xPath;
        try {
            this.service = (Element)this.xpath.evaluate(Capabilities.altPaths("*/wms:Service"), document, XPathConstants.NODE);
            if (this.service == null) {
                String string = Logging.getMessage("WMS.NoServiceElement", "XML document");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.capability = (Element)this.xpath.evaluate(Capabilities.altPaths("*/wms:Capability"), document, XPathConstants.NODE);
            if (this.capability == null) {
                String string = Logging.getMessage("WMS.NoCapabilityElement", "XML document");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            Logging.logger().log(Level.SEVERE, "WMS.ParsingError", xPathExpressionException);
        }
    }

    private static String altPaths(String string) {
        return string != null ? string + "|" + string.replaceAll("wms:", "") : null;
    }

    protected String getText(String string) {
        return this.getText(null, string);
    }

    protected String getText(Element element, String string) {
        try {
            return this.xpath.evaluate(Capabilities.altPaths(string), element != null ? element : this.doc);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    protected String[] getTextArray(Element element, String string) {
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate(Capabilities.altPaths(string), element != null ? element : this.doc, XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            String[] stringArray = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                stringArray[i] = nodeList.item(i).getTextContent();
            }
            return stringArray;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    protected String[] getUniqueText(Element element, String string) {
        String[] stringArray = this.getTextArray(element, string);
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[1]);
    }

    protected Element getElement(Element element, String string) {
        try {
            Node node = (Node)this.xpath.evaluate(Capabilities.altPaths(string), element != null ? element : this.doc, XPathConstants.NODE);
            if (node == null) {
                return null;
            }
            return node instanceof Element ? (Element)node : null;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    protected Element[] getElements(Element element, String string) {
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate(Capabilities.altPaths(string), element != null ? element : this.doc, XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            Element[] elementArray = new Element[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                elementArray[i] = (Element)node;
            }
            return elementArray;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public Element[] getUniqueElements(Element element, String string, String string2) {
        Element[] elementArray = this.getElements(element, string);
        if (elementArray == null) {
            return null;
        }
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        for (Element element2 : elementArray) {
            String string3 = this.getText(element2, string2);
            if (string3 == null) continue;
            hashMap.put(string3, element2);
        }
        return hashMap.values().toArray(new Element[1]);
    }

    private void fillLayerList() {
        if (this.namedLayers.size() == 0) {
            Element[] elementArray = this.getElements(this.capability, "descendant::wms:Layer[wms:Name]");
            if (elementArray == null || elementArray.length == 0) {
                return;
            }
            for (Element element : elementArray) {
                String string = this.getLayerName(element);
                if (string == null) continue;
                Layer layer = new Layer(element);
                this.namedLayers.put(string, layer);
                this.namedLayerElements.put(element, layer);
            }
        }
    }

    public Element[] getNamedLayers() {
        if (this.namedLayerElements.size() == 0) {
            this.fillLayerList();
        }
        return this.namedLayerElements.keySet().toArray(new Element[this.namedLayerElements.size()]);
    }

    public Element getLayerByName(String string) {
        Layer layer;
        if (this.namedLayers.size() == 0) {
            this.fillLayerList();
        }
        return (layer = this.namedLayers.get(string)) != null ? layer.element : null;
    }

    public Long getLayerLatestLastUpdateTime(Capabilities capabilities, String[] stringArray) {
        if (capabilities == null) {
            String string = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (stringArray == null) {
            String string = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = null;
        for (String string2 : stringArray) {
            String string3;
            Element element = capabilities.getLayerByName(string2);
            if (element == null || (string3 = capabilities.getLayerLastUpdate(element)) == null || string != null && string3.compareTo(string) <= 0) continue;
            string = string3;
        }
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = Logging.getMessage("generic.ConversionError", string);
                Logging.logger().warning(string4);
            }
        }
        return null;
    }

    public Double[] getLayerExtremeElevations(Capabilities capabilities, String[] stringArray) {
        if (capabilities == null) {
            String string = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (stringArray == null) {
            String string = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = null;
        String string2 = null;
        for (String string3 : stringArray) {
            String string4;
            Element element = capabilities.getLayerByName(string3);
            if (element == null) continue;
            String string5 = capabilities.getLayerExtremeElevationsMin(element);
            if (string5 != null && (string == null || string5.compareTo(string5) > 0)) {
                string = string5;
            }
            if ((string4 = capabilities.getLayerExtremeElevationsMax(element)) == null || string2 != null && string4.compareTo(string4) <= 0) continue;
            string2 = string4;
        }
        if (string != null || string2 != null) {
            try {
                Object[] objectArray = new Double[]{null, null};
                if (string != null) {
                    objectArray[0] = Double.parseDouble(string);
                }
                if (string2 != null) {
                    objectArray[1] = Double.parseDouble(string2);
                }
                return objectArray;
            }
            catch (NumberFormatException numberFormatException) {
                String string6 = Logging.getMessage("generic.ConversionError", string != null ? string : ("" + string2 != null ? string2 : ""));
                Logging.logger().severe(string6);
            }
        }
        return null;
    }

    public String getVersion() {
        return this.getText("*/@wms:version");
    }

    public String getUpdateSequence() {
        return this.getText("*/@wms:updateSequence");
    }

    public String getAbstract() {
        return this.getText(this.service, "wms:Abstract");
    }

    public String getAccessConstraints() {
        return this.getText(this.service, "wms:AccessConstraints");
    }

    public String getContactOrganization() {
        return this.getText(this.service, "wms:ContactInformation/wms:ContactPersonPrimary/wms:ContactOrganization");
    }

    public String getContactPerson() {
        return this.getText(this.service, "wms:ContactInformation/wms:ContactPersonPrimary/wms:ContactPerson");
    }

    public String getFees() {
        return this.getText(this.service, "wms:Fees");
    }

    public String[] getKeywordList() {
        return this.getTextArray(this.service, "wms:KeywordList/wms:Keyword");
    }

    public String getLayerLimit() {
        return this.getText(this.service, "wms:LayerLimit");
    }

    public String getMaxWidth() {
        return this.getText(this.service, "wms:MaxWidth");
    }

    public String getMaxHeight() {
        return this.getText(this.service, "wms:MaxHeight");
    }

    public String getServiceName() {
        return this.getText(this.service, "wms:Name");
    }

    public String getTitle() {
        return this.getText(this.service, "wms:Title");
    }

    public String getOnlineResource() {
        return this.getText(this.capability, "wms:OnlineResource/@xlink:href");
    }

    public String[] getGetCapabilitiesFormats() {
        return this.getTextArray(this.capability, "wms:Request/wms:GetCapabilities/wms:Format");
    }

    public String getGetCapabilitiesRequestGetURL() {
        return this.getText(this.capability, "wms:Request/wms:GetCapabilities/wms:DCPType/wms:HTTP/wms:Get/wms:OnlineResource/@xlink:href");
    }

    public String getGetCapabilitiesRequestPostURL() {
        return this.getText(this.capability, "wms:Request/wms:GetCapabilities/wms:DCPType/wms:HTTP/wms:Post/wms:OnlineResource/@xlink:href");
    }

    public String[] getExceptionFormats() {
        return this.getTextArray(this.capability, "wms:Exception/wms:Format");
    }

    public String getFeatureInfoRequestGetURL() {
        return this.getText(this.capability, "wms:Request/wms:GetFeatureInfo/wms:DCPType/wms:HTTP/wms:Get/wms:OnlineResource/@xlink:href");
    }

    public String getFeatureInfoRequestPostURL() {
        return this.getText(this.capability, "wms:Request/wms:GetFeatureInfo/wms:DCPType/wms:HTTP/wms:Post/wms:OnlineResource/@xlink:href");
    }

    public String[] getGetMapFormats() {
        return this.getTextArray(this.capability, "wms:Request/wms:GetMap/wms:Format");
    }

    public String getGetMapRequestGetURL() {
        return this.getText(this.capability, "wms:Request/wms:GetMap/wms:DCPType/wms:HTTP/wms:Get/wms:OnlineResource/@xlink:href");
    }

    public String getGetMapRequestPostURL() {
        return this.getText(this.capability, "wms:Request/wms:GetMap/wms:DCPType/wms:HTTP/wms:Post/wms:OnlineResource/@xlink:href");
    }

    public String getVendorSpecificCapabilities() {
        return this.getText(this.capability, "wms:VendorSpecificCapabilities");
    }

    public Element getLayer() {
        return this.getElement(this.capability, "wms:Layer");
    }

    public String getLayerAbstract(Element element) {
        return this.getText(element, "wms:Abstract");
    }

    public String getLayerAttributionTitle(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:Attribution/wms:Title");
    }

    public String getLayerAttributionURL(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:Attribution/wms:OnlineResource/@xlink:href");
    }

    public String getLayerAttributionLogoFormat(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:Attribution/wms:LogoURL/wms:Format");
    }

    public String getLayerAttributionLogoHeight(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:Attribution/wms:LogoURL/@wms:height");
    }

    public String getLayerAttributionLogoURL(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:Attribution/wms:LogoURL/wms:OnlineResource/@xlink:href");
    }

    public String getLayerAttributionLogoWidth(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:Attribution/wms:LogoURL/@wms:width");
    }

    public Element[] getLayerAuthorityURLs(Element element) {
        return this.getUniqueElements(element, "ancestor-or-self::wms:Layer/wms:AuthorityURL", "@wms:type");
    }

    public abstract BoundingBox[] getLayerBoundingBoxes(Element var1);

    public String getLayerCascaded(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/@cascaded");
    }

    public String[] getLayerCRS(Element element) {
        return this.getUniqueText(element, "ancestor-or-self::wms:Layer/wms:CRS");
    }

    public String getLayerDataURLFormat(Element element) {
        return this.getText(element, "wms:DataURL/wms:Format");
    }

    public String getLayerDataURL(Element element) {
        return this.getText(element, "wms:DataURL/wms:OnlineResource/@xlink:href");
    }

    public Element[] getLayerDimensions(Element element) {
        Element[] elementArray = this.getElements(element, "ancestor-or-self::wms:Layer/wms:Dimension");
        if (elementArray == null || elementArray.length == 0) {
            return null;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Element element2 : elementArray) {
            String string = this.getDimensionName(element2);
            if (string != null && arrayList2.contains(string)) continue;
            arrayList.add(element2);
            arrayList2.add(string);
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    public Element[] getLayerExtents(Element element) {
        Element[] elementArray = this.getElements(element, "ancestor-or-self::wms:Layer/wms:Extent");
        if (elementArray == null || elementArray.length == 0) {
            return null;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Element element2 : elementArray) {
            String string = this.getDimensionName(element2);
            if (string != null && arrayList2.contains(string)) continue;
            arrayList.add(element2);
            arrayList2.add(string);
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    public abstract BoundingBox getLayerGeographicBoundingBox(Element var1);

    public String getLayerFeatureListFormat(Element element) {
        return this.getText(element, "wms:FeatureListURL/wms:Format");
    }

    public String getLayerFeatureListURL(Element element) {
        return this.getText(element, "wms:FeatureListURL/wms:OnlineResource/@xlink:href");
    }

    public String getLayerFixedHeight(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/@fixedHeight");
    }

    public String getLayerFixedWidth(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/@fixedWidth");
    }

    public Element[] getLayerIdentifiers(Element element) {
        return this.getUniqueElements(element, "wms:Identifier", "wms:authority");
    }

    public String[] getLayerKeywordList(Element element) {
        return this.getTextArray(element, "wms:KeywordList/wms:Keyword");
    }

    public abstract String getLayerMaxScaleDenominator(Element var1);

    public Element[] getLayerMetadataURLs(Element element) {
        return this.getElements(element, "wms:MetadataURL");
    }

    public abstract String getLayerMinScaleDenominator(Element var1);

    public String getLayerName(Element element) {
        Layer layer = this.namedLayerElements.get(element);
        return layer != null && layer.name != null ? layer.name : this.getText(element, "wms:Name");
    }

    public String getLayerNoSubsets(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/@noSubsets");
    }

    public String getLayerOpaque(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/@opaque");
    }

    public String getLayerQueryable(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/@queryable");
    }

    public String[] getLayerSRS(Element element) {
        return this.getUniqueText(element, "ancestor-or-self::wms:Layer/wms:SRS");
    }

    public Element[] getLayerStyles(Element element) {
        Layer layer = this.namedLayerElements.get(element);
        if (layer == null) {
            return null;
        }
        if (layer.styleElements != null && layer.styleElements.size() != 0) {
            return layer.styleElements.keySet().toArray(new Element[1]);
        }
        Element[] elementArray = this.getUniqueElements(element, "ancestor-or-self::wms:Layer/wms:Style", "Name");
        if (elementArray == null) {
            return null;
        }
        layer.styleElements = new HashMap();
        for (Element element2 : elementArray) {
            Style style = new Style(element2, layer);
            layer.styleElements.put(element2, style);
            this.styleElements.put(element2, style);
        }
        return layer.styleElements.keySet().toArray(new Element[1]);
    }

    public Element[] getLayerSubLayers(Element element) {
        return this.getElements(element, "wms:Layer");
    }

    public String getLayerTitle(Element element) {
        Layer layer = this.namedLayerElements.get(element);
        if (layer == null) {
            return null;
        }
        return layer.title != null ? layer.title : (layer.title = this.getText(element, "wms:Title"));
    }

    public Element getLayerStyleByName(Element element, String string) {
        Layer layer = this.namedLayerElements.get(element);
        if (layer == null) {
            return null;
        }
        if (layer.styleElements == null || layer.styleElements.size() == 0) {
            this.getLayerStyles(element);
            if (layer.styleElements == null || layer.styleElements.size() == 0) {
                return null;
            }
        }
        Collection<Style> collection = layer.styleElements.values();
        for (Style style : collection) {
            if (style == null || style.name == null || !style.name.equals(string)) continue;
            return style.element;
        }
        return null;
    }

    public String getLayerLastUpdate(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:LastUpdate");
    }

    public String getLayerExtremeElevationsMin(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:ExtremeElevations/@min");
    }

    public String getLayerExtremeElevationsMax(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:ExtremeElevations/@max");
    }

    public String getStyleAbstract(Element element) {
        return this.getText(element, "wms:Abstract");
    }

    public String getStyleLegendFormat(Element element) {
        return this.getText(element, "wms:LegendURL/wms:Format");
    }

    public String getStyleLegendHeight(Element element) {
        return this.getText(element, "wms:LegendURL/@height");
    }

    public String getStyleLegendURL(Element element) {
        return this.getText(element, "wms:LegendURL/wms:OnlineResource/@xlink:href");
    }

    public String getStyleLegendWidth(Element element) {
        return this.getText(element, "wms:LegendURL/@width");
    }

    public String getStyleName(Element element) {
        Style style = this.styleElements.get(element);
        return style != null && style.title != null ? style.title : this.getText(element, "wms:Name");
    }

    public String getStyleName(Element element, Element element2) {
        Layer layer = this.namedLayerElements.get(element);
        if (layer == null || layer.styleElements == null) {
            return this.getStyleName(element, element2);
        }
        Style style = layer.styleElements.get(element2);
        return style != null && style.name != null ? style.title : this.getText(element2, "wms:Name");
    }

    public String getStyleSheetURLFormat(Element element) {
        return this.getText(element, "wms:StyleSheetURL/wms:Format");
    }

    public String getStyleSheetURL(Element element) {
        return this.getText(element, "wms:StyleSheetURL/wms:OnlineResource/@xlink:href");
    }

    public String getStyleTitle(Element element) {
        Style style = this.styleElements.get(element);
        return style != null && style.title != null ? style.title : this.getText(element, "wms:Title");
    }

    public String getStyleTitle(Element element, Element element2) {
        Layer layer = this.namedLayerElements.get(element);
        if (layer == null || layer.styleElements == null) {
            return this.getStyleTitle(element2);
        }
        Style style = this.styleElements.get(element2);
        return style != null && style.title != null ? style.title : this.getText(element2, "wms:Title");
    }

    public String getStyleURL(Element element) {
        return this.getText(element, "wms:StyleURL/wms:OnlineResource/@xlink:href");
    }

    public String getStyleURLFormat(Element element) {
        return this.getText(element, "wms:StyleURL/wms:Format");
    }

    public String getAuthorityName(Element element) {
        return this.getText(element, "@wms:name");
    }

    public String getAuthorityURL(Element element) {
        return this.getText(element, "wms:OnlineResource/@xlink:href");
    }

    public String getIdentifier(Element element) {
        return this.getText(element, ".");
    }

    public String getIdentifierAuthority(Element element) {
        return this.getText(element, "@wms:authority");
    }

    public String getMetadataFormat(Element element) {
        return this.getText(element, "wms:Format");
    }

    public String getMetadataURL(Element element) {
        return this.getText(element, "wms:OnlineResource/@xlink:href");
    }

    public String getMetadataType(Element element) {
        return this.getText(element, "@wms:type");
    }

    public String getWestBoundLongitude(Element element) {
        return this.getText(element, "wms:westBoundLongitude");
    }

    public String getEastBoundLongitude(Element element) {
        return this.getText(element, "wms:eastBoundLongitude");
    }

    public String getSouthBoundLatitude(Element element) {
        return this.getText(element, "wms:southBoundLatitude");
    }

    public String getNorthBoundLatitude(Element element) {
        return this.getText(element, "wms:northBoundLatitude");
    }

    public String getBoundingBoxCRS(Element element) {
        return this.getText(element, "@wms:CRS");
    }

    public String getBoundingBoxMinx(Element element) {
        return this.getText(element, "@wms:minx");
    }

    public String getBoundingBoxMiny(Element element) {
        return this.getText(element, "@wms:miny");
    }

    public String getBoundingBoxMaxx(Element element) {
        return this.getText(element, "@wms:maxx");
    }

    public String getBoundingBoxMaxy(Element element) {
        return this.getText(element, "@wms:maxy");
    }

    public String getBoundingBoxResx(Element element) {
        return this.getText(element, "@wms:resx");
    }

    public String getBoundingBoxResy(Element element) {
        return this.getText(element, "@wms:resy");
    }

    public String getBoundingBoxSRS(Element element) {
        return this.getText(element, "@wms:SRS");
    }

    public String getDimensionName(Element element) {
        return this.getText(element, "@wms:name");
    }

    public String getDimensionUnits(Element element) {
        return this.getText(element, "@wms:units");
    }

    public String getDimensionUnitSymbol(Element element) {
        return this.getText(element, "@wms:unitSymbol");
    }

    public String getDimensionDefault(Element element) {
        return this.getText(element, "@wms:default");
    }

    public String getDimensionMultipleValues(Element element) {
        return this.getText(element, "@wms:multipleValues");
    }

    public String getDimensionNearestValue(Element element) {
        return this.getText(element, "@wms:nearestValue");
    }

    public String getDimensionCurrent(Element element) {
        return this.getText(element, "@wms:current");
    }

    public String getDimensionExtent(Element element) {
        return this.getText(element, ".");
    }

    public String getExtentName(Element element) {
        return this.getText(element, "@wms:name");
    }

    public String getExtentDefault(Element element) {
        return this.getText(element, "@wms:default");
    }

    public String getExtentMultipleValues(Element element) {
        return this.getText(element, "@wms:multipleValues");
    }

    public String getExtentNearestValue(Element element) {
        return this.getText(element, "@wms:nearestValue");
    }

    public String getExtentCurrent(Element element) {
        return this.getText(element, "@wms:current");
    }

    public String getExtentText(Element element) {
        return this.getText(element, ".");
    }

    protected static class Style {
        protected final Layer layer;
        protected final Element element;
        protected String name;
        protected String title;

        public Style(Element element, Layer layer) {
            this.element = element;
            this.layer = layer;
        }
    }

    protected static class Layer {
        protected HashMap<Element, Style> styleElements = new HashMap();
        protected final Element element;
        protected Layer layer;
        protected String name;
        protected String title;

        public Layer(Element element) {
            this.element = element;
        }
    }
}

