/*
 * Decompiled with CFR 0.152.
 */
package name.gano;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.util.SectorSelector;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.Mercator.examples.OSMMapnikLayer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.Progress;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class BulkDownload_GPS
extends ApplicationTemplate {
    public static AppFrame start(String appName, Class appFrameClass) {
        if (Configuration.isMacOS() && appName != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
        }
        try {
            final AppFrame frame = (AppFrame)((Object)appFrameClass.newInstance());
            frame.setTitle(appName);
            frame.setDefaultCloseOperation(2);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    frame.setVisible(true);
                }
            });
            return frame;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        ApplicationTemplate.start((String)"World Wind Layer Download", AppFrame.class);
    }

    public static class DownloadMonitorPanel
    extends JPanel {
        private BulkRetrievalThread thread;
        private Progress progress;
        private Timer updateTimer;
        private JLabel descriptionLabel;
        private JProgressBar progressBar;
        private JButton cancelButton;

        public DownloadMonitorPanel(BulkRetrievalThread thread) {
            this.thread = thread;
            this.progress = thread.getProgress();
            this.initComponents();
            this.updateTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DownloadMonitorPanel.this.updateStatus();
                }
            });
            this.updateTimer.start();
        }

        private void updateStatus() {
            String text = this.thread.getRetrievable().getName();
            text = text.length() > 30 ? text.substring(0, 27) + "..." : text;
            text = text + " (" + BulkDownloadPanel.makeSizeDescription(this.progress.getCurrentSize()) + " / " + BulkDownloadPanel.makeSizeDescription(this.progress.getTotalSize()) + ")";
            this.descriptionLabel.setText(text);
            int percent = 0;
            if (this.progress.getTotalCount() > 0) {
                percent = (int)((float)this.progress.getCurrentCount() / (float)this.progress.getTotalCount() * 100.0f);
            }
            this.progressBar.setValue(Math.min(percent, 100));
            String tooltip = BulkDownloadPanel.makeSectorDescription(this.thread.getSector());
            this.descriptionLabel.setToolTipText(tooltip);
            this.progressBar.setToolTipText(this.makeProgressDescription());
            if (!this.thread.isAlive()) {
                this.cancelButton.setText("Remove");
                this.cancelButton.setBackground(Color.GREEN);
                this.updateTimer.stop();
            }
        }

        private void cancelButtonActionPerformed(ActionEvent event) {
            if (this.thread.isAlive()) {
                this.thread.interrupt();
                this.cancelButton.setBackground(Color.ORANGE);
                this.cancelButton.setText("Remove");
                this.updateTimer.stop();
            } else {
                Container top = this.getTopLevelAncestor();
                this.getParent().remove(this);
                top.validate();
            }
        }

        private void initComponents() {
            int border = 2;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel descriptionPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            descriptionPanel.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
            String text = this.thread.getRetrievable().getName();
            text = text.length() > 40 ? text.substring(0, 37) + "..." : text;
            this.descriptionLabel = new JLabel(text);
            descriptionPanel.add(this.descriptionLabel);
            this.add(descriptionPanel);
            JPanel progressPanel = new JPanel();
            progressPanel.setLayout(new BoxLayout(progressPanel, 0));
            progressPanel.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setPreferredSize(new Dimension(100, 16));
            progressPanel.add(this.progressBar);
            progressPanel.add(Box.createHorizontalStrut(8));
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setBackground(Color.RED);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DownloadMonitorPanel.this.cancelButtonActionPerformed(event);
                }
            });
            progressPanel.add(this.cancelButton);
            this.add(progressPanel);
        }

        private String makeProgressDescription() {
            String text = "";
            if (this.progress.getTotalCount() > 0) {
                int percent = (int)((float)this.progress.getCurrentCount() / (float)this.progress.getTotalCount() * 100.0f);
                text = percent + "% of ";
                text = text + BulkDownloadPanel.makeSizeDescription(this.progress.getTotalSize());
            }
            return text;
        }
    }

    public static class BulkRetrievablePanel
    extends JPanel {
        private BulkRetrievable retrievable;
        private JCheckBox selectCheckBox;
        private JLabel descriptionLabel;
        private Thread updateThread;
        private Sector sector;

        BulkRetrievablePanel(BulkRetrievable retrievable) {
            this.retrievable = retrievable;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.selectCheckBox = new JCheckBox(this.retrievable.getName());
            this.selectCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected() && BulkRetrievablePanel.this.sector != null) {
                        BulkRetrievablePanel.this.updateDescription(BulkRetrievablePanel.this.sector);
                    }
                }
            });
            this.add((Component)this.selectCheckBox, "West");
            this.descriptionLabel = new JLabel();
            this.add((Component)this.descriptionLabel, "East");
        }

        public void updateDescription(final Sector sector) {
            if (this.updateThread != null && this.updateThread.isAlive()) {
                this.updateThread.interrupt();
            }
            this.sector = sector;
            if (!this.selectCheckBox.isSelected()) {
                this.doUpdateDescription(null);
                return;
            }
            this.updateThread = new Thread(new Runnable(){

                public void run() {
                    BulkRetrievablePanel.this.descriptionLabel.setText("...");
                    BulkRetrievablePanel.this.doUpdateDescription(sector);
                }
            });
            this.updateThread.setDaemon(true);
            this.updateThread.start();
        }

        private void doUpdateDescription(Sector sector) {
            if (sector != null) {
                try {
                    this.descriptionLabel.setText(BulkDownloadPanel.makeSizeDescription(this.retrievable.getEstimatedMissingDataSize(sector, 0.0)));
                }
                catch (Exception e) {
                    this.descriptionLabel.setText("-");
                }
            } else {
                this.descriptionLabel.setText("-");
            }
        }

        public String toString() {
            return this.retrievable.getName();
        }
    }

    private static class BulkDownloadPanel
    extends JPanel {
        private WorldWindow wwd;
        private Sector currentSector;
        private ArrayList<BulkRetrievablePanel> retrievables;
        private JButton selectButton;
        private JLabel sectorLabel;
        private JButton startButton;
        private JPanel monitorPanel;
        private SectorSelector selector;
        Timer updateTimer;

        public BulkDownloadPanel(WorldWindow wwd) {
            this.wwd = wwd;
            MSVirtualEarthLayer ms = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Hybrid");
            ApplicationTemplate.insertBeforeCompass((WorldWindow)wwd, (Layer)ms);
            OSMMapnikLayer osm = new OSMMapnikLayer();
            osm.setEnabled(false);
            ApplicationTemplate.insertBeforeCompass((WorldWindow)wwd, (Layer)osm);
            ViewControlsLayer vcl = new ViewControlsLayer();
            vcl.setPosition("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast");
            vcl.setScale(0.6);
            vcl.setLocationOffset(new Vec4(0.0, 35.0, 0.0, 0.0));
            wwd.addSelectListener((SelectListener)new ViewControlsSelectListener(wwd, vcl));
            ApplicationTemplate.insertBeforeCompass((WorldWindow)wwd, (Layer)vcl);
            this.retrievables = new ArrayList();
            for (Layer layer : this.wwd.getModel().getLayers()) {
                if (!(layer instanceof BulkRetrievable)) continue;
                this.retrievables.add(new BulkRetrievablePanel((BulkRetrievable)layer));
            }
            CompoundElevationModel cem = (CompoundElevationModel)wwd.getModel().getGlobe().getElevationModel();
            for (ElevationModel elevationModel : cem.getElevationModels()) {
                if (!(elevationModel instanceof BulkRetrievable)) continue;
                this.retrievables.add(new BulkRetrievablePanel((BulkRetrievable)elevationModel));
            }
            this.selector = new SectorSelector(wwd);
            this.selector.setInteriorColor(new Color(1.0f, 1.0f, 1.0f, 0.1f));
            this.selector.setBorderColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            this.selector.setBorderWidth(3.0);
            this.selector.addPropertyChangeListener("gov.nasa.worldwind.SectorSelector", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BulkDownloadPanel.this.updateSector();
                }
            });
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
            this.initComponents();
        }

        private void updateSector() {
            this.currentSector = this.selector.getSector();
            if (this.currentSector != null) {
                this.sectorLabel.setText(BulkDownloadPanel.makeSectorDescription(this.currentSector));
                this.selectButton.setText("Clear sector");
                this.startButton.setEnabled(true);
            } else {
                this.sectorLabel.setText("-");
                this.selectButton.setText("Select sector");
                this.startButton.setEnabled(false);
            }
            this.updateRetrievablePanels(this.currentSector);
        }

        private void updateRetrievablePanels(Sector sector) {
            for (BulkRetrievablePanel panel : this.retrievables) {
                panel.updateDescription(sector);
            }
        }

        private void selectButtonActionPerformed(ActionEvent event) {
            if (this.selector.getSector() != null) {
                this.selector.disable();
            } else {
                this.selector.enable();
            }
            this.updateSector();
        }

        private void startButtonActionPerformed(ActionEvent event) {
            for (BulkRetrievablePanel panel : this.retrievables) {
                if (!panel.selectCheckBox.isSelected()) continue;
                BulkRetrievable retrievable = panel.retrievable;
                BulkRetrievalThread thread = retrievable.makeLocal(this.currentSector, 0.0);
                this.monitorPanel.add(new DownloadMonitorPanel(thread));
            }
            this.getTopLevelAncestor().validate();
        }

        private void initComponents() {
            int border = 6;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Download")));
            this.setToolTipText("Layer imagery bulk download.");
            JPanel sectorPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            sectorPanel.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
            this.selectButton = new JButton("Select sector");
            this.selectButton.setToolTipText("Press Select then press and drag button 1 on globe");
            this.selectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    BulkDownloadPanel.this.selectButtonActionPerformed(event);
                }
            });
            sectorPanel.add(this.selectButton);
            this.sectorLabel = new JLabel("-");
            this.sectorLabel.setPreferredSize(new Dimension(350, 16));
            this.sectorLabel.setHorizontalAlignment(0);
            sectorPanel.add(this.sectorLabel);
            this.add(sectorPanel);
            JPanel retrievablesPanel = new JPanel();
            retrievablesPanel.setLayout(new BoxLayout(retrievablesPanel, 1));
            retrievablesPanel.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
            for (BulkRetrievablePanel panel : this.retrievables) {
                retrievablesPanel.add(panel);
            }
            this.add(retrievablesPanel);
            JPanel startPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            startPanel.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
            this.startButton = new JButton("Start download");
            this.startButton.setEnabled(false);
            this.startButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    BulkDownloadPanel.this.startButtonActionPerformed(event);
                }
            });
            startPanel.add(this.startButton);
            this.add(startPanel);
            this.monitorPanel = new JPanel();
            this.monitorPanel.setLayout(new BoxLayout(this.monitorPanel, 1));
            this.monitorPanel.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
            JPanel dummyPanel = new JPanel(new BorderLayout());
            dummyPanel.add((Component)this.monitorPanel, "North");
            JScrollPane scrollPane = new JScrollPane(dummyPanel);
            scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            scrollPane.setPreferredSize(new Dimension(350, 100));
            this.add(scrollPane);
        }

        public static String makeSectorDescription(Sector sector) {
            return String.format("S %7.4f\u00b0 W %7.4f\u00b0 N %7.4f\u00b0 E %7.4f\u00b0", sector.getMinLatitude().degrees, sector.getMinLongitude().degrees, sector.getMaxLatitude().degrees, sector.getMaxLongitude().degrees);
        }

        public static String makeSizeDescription(long size) {
            return String.format("%.1f MB", (double)size / 1024.0 / 1024.0);
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            super.setIconImage(Toolkit.getDefaultToolkit().getImage(((Object)((Object)this)).getClass().getResource("/icons/Earth-Scan-24x24.png")));
            this.getLayerPanel().add((Component)new BulkDownloadPanel((WorldWindow)this.getWwd()), (Object)"South");
            this.getLayerPanel().update((WorldWindow)this.getWwd());
        }
    }
}

