/*
 * Decompiled with CFR 0.152.
 */
package name.gano;

import gov.nasa.worldwind.WorldWind;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import name.gano.utils.CacheCleaner;

public class CacheInspectorDialog
extends JDialog {
    CacheCleaner.CacheLocationData cld;
    private JTextArea cacheDataTextArea;
    private JTextField cacheTextField;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;

    public CacheInspectorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        File writeCache = WorldWind.getDataFileStore().getWriteLocation();
        this.cacheTextField.setText(writeCache.getAbsolutePath());
        this.analyzeCache();
    }

    public void analyzeCache() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                File writeCache = WorldWind.getDataFileStore().getWriteLocation();
                String dataStr = "";
                CacheInspectorDialog.this.cld = CacheCleaner.analyseCacheLocation(writeCache);
                int lenPathRoot = writeCache.getAbsolutePath().length();
                for (CacheCleaner.CacheDirectory cd : CacheInspectorDialog.this.cld.directories) {
                    dataStr = dataStr + cd.file.getAbsolutePath().substring(lenPathRoot) + " size: " + String.format("%.3f", (double)cd.sizeInBytes / Math.pow(2.0, 20.0)) + " MB \n";
                }
                dataStr = dataStr + " ------------- \n";
                dataStr = dataStr + "Total Number of Directories: " + CacheInspectorDialog.this.cld.directories.size() + "\n";
                dataStr = dataStr + "Total Number of Files: " + CacheInspectorDialog.this.cld.fileCount + "\n";
                dataStr = dataStr + "Total size (MB): " + String.format("%.3f", (double)CacheInspectorDialog.this.cld.sizeInBytes / Math.pow(2.0, 20.0));
                CacheInspectorDialog.this.cacheDataTextArea.setText(dataStr);
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cacheTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.cacheDataTextArea = new JTextArea();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Imagery Cache Info");
        this.jLabel1.setText("Cache:");
        this.jLabel2.setText("Info:");
        this.jButton1.setText("Clean Cache");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CacheInspectorDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.cacheDataTextArea.setColumns(20);
        this.cacheDataTextArea.setRows(5);
        this.cacheDataTextArea.setText("Anaylzing Cache.....");
        this.jScrollPane1.setViewportView(this.cacheDataTextArea);
        this.jButton2.setText("Refresh Data");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CacheInspectorDialog.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addGap(18, 18, 18).addComponent(this.jButton2)).addComponent(this.cacheTextField, -1, 231, Short.MAX_VALUE))))).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jScrollPane1, -1, 259, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cacheTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 145, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2))));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.cacheDataTextArea.setText("Anaylzing Cache.....");
        this.analyzeCache();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete all the cached imagery?");
        if (result == 0) {
            this.cacheDataTextArea.setText("Cleaning Cache....");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CacheCleaner.cleanupCacheLocation(CacheInspectorDialog.this.cld, 0L);
                    CacheInspectorDialog.this.cacheDataTextArea.append(".. done!");
                }
            });
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CacheInspectorDialog dialog = new CacheInspectorDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

