/*
 * Decompiled with CFR 0.152.
 */
package name.gano;

import gnu.io.CommPortIdentifier;
import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.util.LayerManagerLayer;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.FlatGlobe;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.layers.Mercator.examples.OSMMapnikLayer;
import gov.nasa.worldwind.layers.Mercator.examples.VirtualEarthLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.SkyColorLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.measure.LengthMeasurer;
import gov.nasa.worldwind.view.BasicOrbitView;
import gov.nasa.worldwind.view.FlatOrbitView;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import name.gano.BulkDownload_GPS;
import name.gano.CacheInspectorDialog;
import name.gano.LocationSearchDialog;
import name.gano.gps.GPSSimulatedNmeaDevice;
import name.gano.jfreechart.GPSBarPainter;
import name.gano.jfreechart.SctterPlotItemGPSRenderer;
import name.gano.jfreechart.XYGPSDataItem;
import name.gano.utils.CustomFileFilter;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSPosition;
import org.dinopolis.gpstool.gpsinput.GPSRawDataListener;
import org.dinopolis.gpstool.gpsinput.GPSSerialDevice;
import org.dinopolis.gpstool.gpsinput.SatelliteInfo;
import org.dinopolis.gpstool.gpsinput.nmea.GPSNmeaDataProcessor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RefineryUtilities;

public class GpsInspector
extends JFrame
implements PropertyChangeListener {
    public final String versionString = "v1.0 (28 April 2009)";
    static boolean simulation = false;
    boolean saveRawData2File = false;
    File gpsOutputfile;
    BufferedWriter gpsFileBufferedWriter;
    long timeSinceLateFileWrite = -1L;
    float lastSpeed = -1.0f;
    float MIN_MPH_SPEED_TRUST_HEADING = 1.5f;
    static GPSNmeaDataProcessor gps_data_processor;
    GPSDevice gps_device;
    private JFreeChart signalChart;
    private DefaultCategoryDataset signalDataSet = new DefaultCategoryDataset();
    private String snrSeriesTitle = "Signal Strength (SNR)";
    private GPSBarPainter gpsBarPainter;
    private JFreeChart polarChart;
    XYSeriesCollection polarPlotData = new XYSeriesCollection();
    XYSeries seriesFix = new XYSeries((Comparable)((Object)"Used in Fix Calc"));
    XYSeries seriesZero = new XYSeries((Comparable)((Object)"0 Signal"));
    XYSeries seriesNotUsed = new XYSeries((Comparable)((Object)"Not Used in Fix but Tracking"));
    public static final int DARK_THEME = 0;
    public static final int LIGHT_THEME = 1;
    public static final int SHAWN_THEME = 2;
    WorldWindowGLCanvas wwd;
    BasicModel wwdModel;
    private Globe roundGlobe;
    private FlatGlobe flatGlobe;
    BasicMarker bm;
    BasicMarker destinationMarker;
    Position currentPos;
    LayerManagerLayer lml;
    boolean layerManagerVisible = false;
    ArrayList<Marker> markers;
    LatLon destLatLon = LatLon.ZERO;
    Polyline dest2PosLine;
    RenderableLayer lineLayer = new RenderableLayer();
    ArrayList<LatLon> destPosArrayList = new ArrayList();
    Polyline pathLine;
    private SimpleDateFormat timeDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
    float altitude_meters = 0.0f;
    private JTextField altitude_label;
    private JButton bulkDownloaderButton;
    private ButtonGroup buttonGroup1;
    private JButton cacheButton;
    private JButton clearPathButton;
    private JCheckBox decimalCheckBox;
    private JTextField destDistTextField;
    private JTextField destLatTextField;
    private JTextField destLonTextField;
    private JPanel destinationPanel;
    private JTextField fixInfoTextField;
    private JTextField fixQualTextField;
    private JTextField fixTimeTextField;
    private JCheckBox followCheckBox;
    private JCheckBox followTerrainCheckBox;
    private JPanel globePanel;
    private JTextField hdopTextField;
    private JTextField heading2DestTextField;
    private JCheckBox headingCheckBox;
    private JTextField heading_label;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;
    private JTextField latitude_label;
    private JButton layerListButton;
    private JTextField longitude_label;
    private JCheckBox offlineModeCheckBox;
    private JTextField pdopTextField;
    private JComboBox portComboBox;
    private JComboBox projectionCombo;
    private JTextField rateTextField;
    private JTextArea rawDataTextArea;
    private JCheckBox record2FileCheckBox;
    private JRadioButton replayRadioButton;
    private JPanel satLocPanel;
    private JCheckBox savePathCheckBox;
    private JButton scanButton;
    private JButton setDestLocationButton;
    private JCheckBox showPathCheckBox;
    private JPanel signalPanel;
    private JRadioButton simRadioButton;
    private JTextField speedTextField;
    private JTextField speed_label;
    private JButton startButton;
    private JTextField toaTextField;
    private JCheckBox useDestinationCheckBox;
    private JToggleButton utcToggleButton;
    private JTextField vdopTextField;
    private JLabel versionLabel;
    Integer[] satellites_ids = new Integer[12];
    String[] fixQualityStr = new String[]{"Invalid", "GPS fix (SPS)", "DGPS fix", "PPS fix", "Real Time Kinematic", "Float RTK", "estimated (dead reckoning)", "Manual input mode", "Simulation mode"};

    public GpsInspector() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception ex1) {
            // empty catch block
        }
        this.initComponents();
        super.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/Earth-Scan-24x24.png")));
        this.setSize(675, 500);
        this.versionLabel.setText("v1.0 (28 April 2009)");
        this.signalChart = this.createBarChart(this.signalDataSet);
        this.applyTheme(0, this.signalChart);
        this.gpsBarPainter = new GPSBarPainter();
        ((BarRenderer)((CategoryPlot)this.signalChart.getPlot()).getRenderer()).setBarPainter(this.gpsBarPainter);
        ((BarRenderer)((CategoryPlot)this.signalChart.getPlot()).getRenderer()).setShadowVisible(false);
        ChartPanel chartP = new ChartPanel(this.signalChart);
        this.signalPanel.add((Component)chartP, "Center");
        this.polarPlotData.addSeries(this.seriesFix);
        this.polarPlotData.addSeries(this.seriesZero);
        this.polarPlotData.addSeries(this.seriesNotUsed);
        this.polarChart = this.createPolarPlot(this.polarPlotData);
        ChartPanel chartPP = new ChartPanel(this.polarChart);
        this.satLocPanel.add((Component)chartPP, "Center");
        this.wwd = new WorldWindowGLCanvas();
        this.globePanel.add((Component)this.wwd, "Center");
        this.wwdModel = new BasicModel();
        this.wwd.setModel((Model)this.wwdModel);
        if (this.isFlatGlobe()) {
            this.flatGlobe = (FlatGlobe)this.wwd.getModel().getGlobe();
            this.roundGlobe = new Earth();
        } else {
            this.flatGlobe = new EarthFlat();
            this.roundGlobe = this.wwd.getModel().getGlobe();
        }
        MarkerLayer layer = this.buildMarkerLayer();
        GpsInspector.insertBeforeCompass((WorldWindow)this.wwd, (Layer)layer);
        ViewControlsLayer vcl = new ViewControlsLayer();
        vcl.setPosition("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast");
        vcl.setScale(0.6);
        vcl.setLocationOffset(new Vec4(0.0, 35.0, 0.0, 0.0));
        this.wwd.addSelectListener((SelectListener)new ViewControlsSelectListener((WorldWindow)this.wwd, vcl));
        GpsInspector.insertBeforeCompass((WorldWindow)this.wwd, (Layer)vcl);
        this.lml = new LayerManagerLayer((WorldWindow)this.wwd);
        this.lml.setEnabled(false);
        this.lml.setLocationOffset(new Vec4(0.0, 40.0, 0.0, 0.0));
        MSVirtualEarthLayer ms = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Hybrid");
        GpsInspector.insertBeforeCompass((WorldWindow)this.wwd, (Layer)ms);
        VirtualEarthLayer ve = new VirtualEarthLayer();
        ve.setEnabled(false);
        GpsInspector.insertBeforeCompass((WorldWindow)this.wwd, (Layer)ve);
        OSMMapnikLayer osm = new OSMMapnikLayer();
        osm.setEnabled(false);
        GpsInspector.insertBeforeCompass((WorldWindow)this.wwd, (Layer)osm);
        for (Layer currentLayer : this.wwd.getModel().getLayers()) {
            if (currentLayer instanceof WorldMapLayer) {
                ((WorldMapLayer)currentLayer).setEnabled(false);
            }
            if (!(currentLayer instanceof CompassLayer)) continue;
            ((CompassLayer)currentLayer).setShowTilt(true);
        }
        this.destPosArrayList.add(new LatLon(this.destLatLon));
        this.destPosArrayList.add(new LatLon(this.currentPos.getLatLon()));
        this.dest2PosLine = new Polyline(this.destPosArrayList, 0.0);
        this.dest2PosLine.setAntiAliasHint(4353);
        this.dest2PosLine.setFollowTerrain(true);
        this.dest2PosLine.setLineWidth(2.0);
        this.dest2PosLine.setColor(new Color(0.0f, 0.0f, 1.0f, 0.5f));
        this.dest2PosLine.setPathType(0);
        this.pathLine = new Polyline(new ArrayList());
        this.pathLine.setAntiAliasHint(4353);
        this.pathLine.setFollowTerrain(true);
        this.pathLine.setLineWidth(1.0);
        this.pathLine.setColor(Color.MAGENTA);
        this.pathLine.setPathType(1);
        this.lineLayer.setPickEnabled(false);
        this.wwd.getModel().getLayers().add((Layer)this.lineLayer);
    }

    private JFreeChart createBarChart(DefaultCategoryDataset dataset) {
        JFreeChart result = ChartFactory.createBarChart("Signal Strength of Tracked Satellites", "Satellite ID", "SNR", dataset, PlotOrientation.VERTICAL, false, true, false);
        return result;
    }

    private JFreeChart createPolarPlot(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createPolarChart("Satellite Locations", dataset, false, true, false);
        PolarPlot plot = (PolarPlot)chart.getPlot();
        chart.setBackgroundPaint(new Color(220, 220, 220));
        ChartTheme dark = StandardChartTheme.createDarknessTheme();
        dark.apply(chart);
        plot.setOutlinePaint(Color.BLACK);
        SctterPlotItemGPSRenderer rend = new SctterPlotItemGPSRenderer();
        plot.setRenderer(rend);
        ValueAxis axis = plot.getAxis();
        axis.setRange(0.0, 90.0);
        TickUnits tu = new TickUnits();
        tu.add(new NumberTickUnit(15.0));
        axis.setStandardTickUnits(tu);
        return chart;
    }

    private void applyTheme(int themeNum, JFreeChart chart) {
        switch (themeNum) {
            case 0: {
                ChartTheme dark = StandardChartTheme.createDarknessTheme();
                dark.apply(chart);
                BarRenderer renderer = (BarRenderer)chart.getCategoryPlot().getRenderer();
                chart.getPlot().setOutlinePaint(Color.DARK_GRAY);
                renderer.setSeriesPaint(0, new Color(51, 102, 153));
                break;
            }
            case 1: {
                ChartTheme jfree = StandardChartTheme.createJFreeTheme();
                jfree.apply(chart);
                break;
            }
            case 2: {
                ChartTheme jfree = StandardChartTheme.createJFreeTheme();
                jfree.apply(chart);
                Color lines = new Color(120, 166, 255);
                chart.setBackgroundPaint(new Color(220, 220, 220));
                BarRenderer renderer = (BarRenderer)chart.getCategoryPlot().getRenderer();
                renderer.setBarPainter(new StandardBarPainter());
                renderer.setSeriesPaint(0, new Color(51, 102, 153));
                renderer.setSeriesPaint(1, new Color(255, 0, 0));
                renderer.setShadowVisible(false);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.startButton = new JButton();
        this.jButton2 = new JButton();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.portComboBox = new JComboBox();
        this.speedTextField = new JTextField();
        this.scanButton = new JButton();
        this.jLabel8 = new JLabel();
        this.versionLabel = new JLabel();
        this.simRadioButton = new JRadioButton();
        this.replayRadioButton = new JRadioButton();
        this.jLabel9 = new JLabel();
        this.record2FileCheckBox = new JCheckBox();
        this.rateTextField = new JTextField();
        this.jLabel16 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel1 = new JLabel();
        this.latitude_label = new JTextField();
        this.jLabel2 = new JLabel();
        this.longitude_label = new JTextField();
        this.jLabel3 = new JLabel();
        this.altitude_label = new JTextField();
        this.jLabel4 = new JLabel();
        this.speed_label = new JTextField();
        this.jLabel5 = new JLabel();
        this.heading_label = new JTextField();
        this.jLabel10 = new JLabel();
        this.fixTimeTextField = new JTextField();
        this.utcToggleButton = new JToggleButton();
        this.jLabel11 = new JLabel();
        this.fixInfoTextField = new JTextField();
        this.jLabel12 = new JLabel();
        this.fixQualTextField = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.pdopTextField = new JTextField();
        this.hdopTextField = new JTextField();
        this.vdopTextField = new JTextField();
        this.decimalCheckBox = new JCheckBox();
        this.jPanel12 = new JPanel();
        this.savePathCheckBox = new JCheckBox();
        this.showPathCheckBox = new JCheckBox();
        this.clearPathButton = new JButton();
        this.followTerrainCheckBox = new JCheckBox();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.destinationPanel = new JPanel();
        this.useDestinationCheckBox = new JCheckBox();
        this.jPanel10 = new JPanel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.destLatTextField = new JTextField();
        this.destLonTextField = new JTextField();
        this.jLabel19 = new JLabel();
        this.jButton6 = new JButton();
        this.setDestLocationButton = new JButton();
        this.jPanel11 = new JPanel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.destDistTextField = new JTextField();
        this.toaTextField = new JTextField();
        this.heading2DestTextField = new JTextField();
        this.jPanel9 = new JPanel();
        this.globePanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.projectionCombo = new JComboBox();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.layerListButton = new JButton();
        this.headingCheckBox = new JCheckBox();
        this.followCheckBox = new JCheckBox();
        this.offlineModeCheckBox = new JCheckBox();
        this.bulkDownloaderButton = new JButton();
        this.cacheButton = new JButton();
        this.jPanel5 = new JPanel();
        this.signalPanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.satLocPanel = new JPanel();
        this.jPanel8 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.rawDataTextArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("GPS Inspector");
        this.jPanel1.setPreferredSize(new Dimension(50, 50));
        this.jTabbedPane1.setMinimumSize(new Dimension(0, 0));
        this.jTabbedPane1.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setPreferredSize(new Dimension(50, 50));
        this.startButton.setText("start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.startButtonActionPerformed(evt);
            }
        });
        this.jButton2.setText("stop");
        this.jButton2.setPreferredSize(new Dimension(40, 25));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Serial Port:");
        this.jLabel7.setText("Speed:");
        this.portComboBox.setEditable(true);
        this.portComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"COM1", "COM2", "COM3", "COM4", "/dev/ttyUSB0", "/dev/ttyS1", "/dev/ttyS2", "/dev/ttyS3", "/dev/ttyS4"}));
        this.speedTextField.setText("4800");
        this.scanButton.setText("scan for list of ports");
        this.scanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.scanButtonActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Created by: Shawn Gano, shawn@gano.name");
        this.versionLabel.setHorizontalAlignment(4);
        this.versionLabel.setText("v x.x.x");
        this.simRadioButton.setText("Simulate GPS Device");
        this.simRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.simRadioButtonActionPerformed(evt);
            }
        });
        this.replayRadioButton.setText("Replay from File");
        this.replayRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.replayRadioButtonActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Rate:");
        this.record2FileCheckBox.setText("Record to file");
        this.rateTextField.setText("1.0");
        this.jLabel16.setIcon(new ImageIcon(this.getClass().getResource("/icons/Earth-Scan-128x128.png")));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.record2FileCheckBox)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 194, Short.MAX_VALUE).addComponent(this.versionLabel, -2, 146, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.startButton, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.speedTextField).addComponent(this.portComboBox, 0, 117, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanButton)).addComponent(this.jButton2, -2, 62, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.replayRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rateTextField, -2, 56, -2)).addComponent(this.simRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 236, Short.MAX_VALUE).addComponent(this.jLabel16, -2, 137, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.portComboBox, -2, -1, -2).addComponent(this.scanButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.speedTextField, -2, -1, -2)).addGap(24, 24, 24).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startButton).addComponent(this.jButton2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.record2FileCheckBox).addGap(24, 24, 24).addComponent(this.simRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replayRadioButton).addComponent(this.jLabel9).addComponent(this.rateTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 108, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.versionLabel)).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("GPS Controls", this.jPanel2);
        this.jPanel4.setPreferredSize(new Dimension(200, 200));
        this.jPanel7.setPreferredSize(new Dimension(200, 200));
        this.jLabel1.setText("Latitude:");
        this.jLabel2.setText("Longitude:");
        this.jLabel3.setText("Altitude [ft]:");
        this.jLabel3.setToolTipText("MSL");
        this.jLabel4.setText("Speed [mph]:");
        this.jLabel5.setText("Heading [deg]:");
        this.jLabel5.setToolTipText("Heading in Degrees from North True");
        this.jLabel10.setText("Fix Time:");
        this.utcToggleButton.setText("UTC/Local");
        this.utcToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.utcToggleButtonActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Fix Info:");
        this.jLabel12.setText("Fix Quality:");
        this.jLabel13.setText("PDOP:");
        this.jLabel13.setToolTipText("Position Dilution of Precision");
        this.jLabel14.setText("HDOP:");
        this.jLabel14.setToolTipText("Horizontal Dilution of Precision");
        this.jLabel15.setText("VDOP:");
        this.jLabel15.setToolTipText("Vertical Dilution of Precision");
        this.decimalCheckBox.setText("decimal format");
        this.jPanel12.setBorder(BorderFactory.createTitledBorder("Display Options"));
        this.savePathCheckBox.setText("Save Path");
        this.showPathCheckBox.setText("Show Path");
        this.showPathCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.showPathCheckBoxActionPerformed(evt);
            }
        });
        this.clearPathButton.setText("Clear Path");
        this.clearPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.clearPathButtonActionPerformed(evt);
            }
        });
        this.followTerrainCheckBox.setSelected(true);
        this.followTerrainCheckBox.setText("Follow Terrain");
        this.followTerrainCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.followTerrainCheckBoxActionPerformed(evt);
            }
        });
        this.jButton7.setText("Calc Dist");
        this.jButton7.setToolTipText("Calcualte Distance of the Path");
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.jButton7ActionPerformed(evt);
            }
        });
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addComponent(this.savePathCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPathCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearPathButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.followTerrainCheckBox).addGap(40, 40, 40).addComponent(this.jButton7).addContainerGap(105, Short.MAX_VALUE)));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.savePathCheckBox).addComponent(this.showPathCheckBox).addComponent(this.clearPathButton).addComponent(this.followTerrainCheckBox).addComponent(this.jButton7)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton8.setText("DOP Scale");
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.jButton8ActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fixTimeTextField, -2, 196, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.utcToggleButton)).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.heading_label, -1, 156, Short.MAX_VALUE).addComponent(this.speed_label, -1, 156, Short.MAX_VALUE).addComponent(this.altitude_label, -1, 156, Short.MAX_VALUE).addComponent(this.longitude_label, -1, 156, Short.MAX_VALUE).addComponent(this.latitude_label, -1, 156, Short.MAX_VALUE))).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fixInfoTextField, -2, 187, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton8).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fixQualTextField, -2, 123, -2).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vdopTextField, -1, 123, Short.MAX_VALUE).addComponent(this.hdopTextField, -1, 123, Short.MAX_VALUE).addComponent(this.pdopTextField, GroupLayout.Alignment.TRAILING, -1, 123, Short.MAX_VALUE)))))).addGap(274, 274, 274)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.decimalCheckBox).addContainerGap(478, Short.MAX_VALUE)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jPanel12, -1, -1, Short.MAX_VALUE).addGap(122, 122, 122)))));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.fixInfoTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.latitude_label, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.longitude_label, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.altitude_label, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.speed_label, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.heading_label, -2, -1, -2))).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fixQualTextField, -2, -1, -2).addComponent(this.jLabel12)).addGap(18, 18, 18).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.pdopTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.hdopTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.vdopTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8))).addGap(19, 19, 19).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.fixTimeTextField, -2, -1, -2).addComponent(this.utcToggleButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel12, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.decimalCheckBox).addContainerGap()));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel7, -1, 583, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel7, -1, 334, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Position Info", this.jPanel4);
        this.useDestinationCheckBox.setText("Use Destination");
        this.useDestinationCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.useDestinationCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel10.setBorder(BorderFactory.createTitledBorder("Destination Description"));
        this.jLabel17.setText("Latitude:");
        this.jLabel18.setText("Longitude:");
        this.jLabel19.setText("or:");
        this.jButton6.setText("search");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.jButton6ActionPerformed(evt);
            }
        });
        this.setDestLocationButton.setText("Set Location");
        this.setDestLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.setDestLocationButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.setDestLocationButton)).addGroup(jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17).addComponent(this.jLabel18)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.destLonTextField).addComponent(this.destLatTextField, -1, 102, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6))).addGap(293, 293, 293)));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.destLatTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.destLonTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.setDestLocationButton)).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.jButton6))));
        this.jPanel11.setBorder(BorderFactory.createTitledBorder("Calculated Values"));
        this.jLabel20.setText("Direct Distance  [mi]:");
        this.jLabel21.setText("Estimate time to arrive:");
        this.jLabel22.setText("Heading [true] :");
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel21, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel20, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.heading2DestTextField, -2, 107, -2).addComponent(this.toaTextField, -2, 107, -2).addComponent(this.destDistTextField, -2, 107, -2)).addContainerGap(314, Short.MAX_VALUE)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.destDistTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent(this.toaTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel22).addComponent(this.heading2DestTextField, -2, -1, -2)).addContainerGap(46, Short.MAX_VALUE)));
        GroupLayout destinationPanelLayout = new GroupLayout(this.destinationPanel);
        this.destinationPanel.setLayout(destinationPanelLayout);
        destinationPanelLayout.setHorizontalGroup(destinationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, destinationPanelLayout.createSequentialGroup().addContainerGap().addGroup(destinationPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel11, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel10, GroupLayout.Alignment.LEADING, -1, 563, Short.MAX_VALUE).addComponent(this.useDestinationCheckBox, GroupLayout.Alignment.LEADING)).addContainerGap()));
        destinationPanelLayout.setVerticalGroup(destinationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(destinationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.useDestinationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel10, -1, 130, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel11, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Destination", this.destinationPanel);
        this.globePanel.setMinimumSize(new Dimension(0, 0));
        this.globePanel.setPreferredSize(new Dimension(50, 31));
        this.globePanel.setLayout(new BorderLayout());
        this.jToolBar1.setRollover(true);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/icons/emblem-web.png")));
        this.jButton1.setToolTipText("3D Globe");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/icons/treasure-map-24x24.png")));
        this.jButton3.setToolTipText("2D Map using selected projection");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.jButton3ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton3);
        this.projectionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Mercator", "Sinusoidal", "Modified Sin.", "Lat/Lon"}));
        this.projectionCombo.setSelectedIndex(3);
        this.projectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.projectionComboActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.projectionCombo);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/icons/Zoom-In-24x24.png")));
        this.jButton4.setToolTipText("Zoom to current location");
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setVerticalTextPosition(3);
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.jButton4ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton4);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/icons/Zoom-Out-24x24.png")));
        this.jButton5.setToolTipText("Zoom Out to View Whole Earth");
        this.jButton5.setFocusable(false);
        this.jButton5.setHorizontalTextPosition(0);
        this.jButton5.setVerticalTextPosition(3);
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.jButton5ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton5);
        this.layerListButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Task-List-24x24.png")));
        this.layerListButton.setToolTipText("Toggle Layer List");
        this.layerListButton.setFocusable(false);
        this.layerListButton.setHorizontalTextPosition(0);
        this.layerListButton.setVerticalTextPosition(3);
        this.layerListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.layerListButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.layerListButton);
        this.headingCheckBox.setText("Auto Heading");
        this.headingCheckBox.setFocusable(false);
        this.jToolBar1.add(this.headingCheckBox);
        this.followCheckBox.setText("Follow Position");
        this.followCheckBox.setFocusable(false);
        this.jToolBar1.add(this.followCheckBox);
        this.offlineModeCheckBox.setText("Offline Mode");
        this.offlineModeCheckBox.setToolTipText("Uses only cached imagery and doesn't use a network connection");
        this.offlineModeCheckBox.setFocusable(false);
        this.offlineModeCheckBox.setHorizontalAlignment(11);
        this.offlineModeCheckBox.setVerticalTextPosition(3);
        this.offlineModeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.offlineModeCheckBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.offlineModeCheckBox);
        this.bulkDownloaderButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/My-Downloads-24x24.png")));
        this.bulkDownloaderButton.setToolTipText("Imagery Layer Bulk Downloader (cache for offline use)");
        this.bulkDownloaderButton.setFocusable(false);
        this.bulkDownloaderButton.setHorizontalTextPosition(0);
        this.bulkDownloaderButton.setVerticalTextPosition(3);
        this.bulkDownloaderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.bulkDownloaderButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.bulkDownloaderButton);
        this.cacheButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Trash-Full-24x24.png")));
        this.cacheButton.setToolTipText("Imagery Cache Info/Cleaner");
        this.cacheButton.setFocusable(false);
        this.cacheButton.setHorizontalTextPosition(0);
        this.cacheButton.setVerticalTextPosition(3);
        this.cacheButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GpsInspector.this.cacheButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cacheButton);
        this.globePanel.add((Component)this.jToolBar1, "Last");
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.globePanel, -1, 583, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.globePanel, -1, 338, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Globe", this.jPanel9);
        this.signalPanel.setLayout(new BorderLayout());
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.signalPanel, -1, 583, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.signalPanel, -1, 338, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Signal Strength", this.jPanel5);
        this.satLocPanel.setLayout(new BorderLayout());
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.satLocPanel, -1, 583, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.satLocPanel, -1, 338, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Sat Locations", this.jPanel6);
        this.rawDataTextArea.setBackground(new Color(0, 0, 0));
        this.rawDataTextArea.setColumns(20);
        this.rawDataTextArea.setForeground(new Color(51, 255, 0));
        this.rawDataTextArea.setRows(5);
        this.rawDataTextArea.setText("Raw GPS Data:\n");
        this.jScrollPane1.setViewportView(this.rawDataTextArea);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 338, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Raw Data", this.jPanel8);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 588, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING, -1, 366, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 588, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, 366, Short.MAX_VALUE));
        this.pack();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startButtonActionPerformed(ActionEvent evt) {
        simulation = this.simRadioButton.isSelected();
        if (this.record2FileCheckBox.isSelected()) {
            this.saveRawData2File = this.promptUserForLogFile();
            this.timeSinceLateFileWrite = -1L;
            if (!this.saveRawData2File) {
                this.record2FileCheckBox.setSelected(false);
            }
        } else {
            this.saveRawData2File = false;
        }
        this.rawDataTextArea.setText("");
        gps_data_processor = new GPSNmeaDataProcessor();
        gps_data_processor.addGPSRawDataListener(new GPSRawDataListener(){

            public void gpsRawDataReceived(char[] data, int offset, int length) {
                String newData = new String(data, offset, length);
                GpsInspector.this.rawDataTextArea.append(newData);
                GpsInspector.this.rawDataTextArea.setCaretPosition(GpsInspector.this.rawDataTextArea.getDocument().getLength());
                int idealSize = 50000;
                int maxExcess = 200;
                int excess = GpsInspector.this.rawDataTextArea.getDocument().getLength() - idealSize;
                if (excess >= maxExcess) {
                    GpsInspector.this.rawDataTextArea.replaceRange("", 0, excess);
                }
                if (GpsInspector.this.saveRawData2File) {
                    try {
                        if (GpsInspector.this.timeSinceLateFileWrite > 0L) {
                            long currTime = System.currentTimeMillis();
                            long diff = currTime - GpsInspector.this.timeSinceLateFileWrite;
                            GpsInspector.this.timeSinceLateFileWrite = currTime;
                            GpsInspector.this.gpsFileBufferedWriter.write("##" + diff + "\n");
                        } else {
                            GpsInspector.this.timeSinceLateFileWrite = System.currentTimeMillis();
                        }
                        GpsInspector.this.gpsFileBufferedWriter.write(newData.trim());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Error saving to file (file will no longer be written to): \n" + e.toString(), "ERROR", 0);
                        try {
                            GpsInspector.this.gpsFileBufferedWriter.close();
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        GpsInspector.this.saveRawData2File = false;
                    }
                }
            }
        });
        gps_data_processor.addGPSDataChangeListener(this);
        int speedBaud = 4800;
        String portName = "COM1";
        try {
            speedBaud = Integer.parseInt(this.speedTextField.getText());
            portName = this.portComboBox.getSelectedItem().toString();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Data Entry Error: \n" + e.toString(), "ERROR", 0);
            return;
        }
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.put("port_name", portName);
        environment.put("port_speed", new Integer(speedBaud));
        if (this.replayRadioButton.isSelected()) {
            JFileChooser fc = new JFileChooser();
            CustomFileFilter gpsFilter = new CustomFileFilter("gps", "*.gps");
            fc.addChoosableFileFilter(gpsFilter);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal != 0) return;
            File inFile = fc.getSelectedFile();
            float rate = Float.parseFloat(this.rateTextField.getText());
            this.gps_device = new GPSSimulatedNmeaDevice(inFile, rate);
        } else {
            this.gps_device = simulation ? new GPSSimulatedNmeaDevice() : new GPSSerialDevice();
        }
        try {
            this.gps_device.init(environment);
            gps_data_processor.setGPSDevice(this.gps_device);
            gps_data_processor.open();
            System.out.println("GPSInfo:");
            String[] infos = gps_data_processor.getGPSInfo();
            String gpsInfo = "";
            for (int index = 0; index < infos.length; ++index) {
                gpsInfo = gpsInfo + infos[index] + "\n";
            }
            this.startButton.setEnabled(false);
            JOptionPane.showMessageDialog(this, "Connected to GPS Successfully: \n" + gpsInfo, "Success", 1);
            return;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error connection to GPS: " + e.toString(), "Error", 0);
            e.printStackTrace();
            this.startButton.setEnabled(true);
        }
    }

    private boolean promptUserForLogFile() {
        JFileChooser fc = new JFileChooser();
        CustomFileFilter gpsFilter = new CustomFileFilter("gps", "*.gps");
        fc.addChoosableFileFilter(gpsFilter);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            String extension;
            File file = fc.getSelectedFile();
            String fileExtension = "gps";
            if (fc.getFileFilter() == gpsFilter) {
                fileExtension = "gps";
            }
            if ((extension = GpsInspector.getExtension(file)) != null) {
                fileExtension = extension;
            } else {
                this.gpsOutputfile = new File(file.getAbsolutePath() + "." + fileExtension);
                try {
                    this.gpsFileBufferedWriter = new BufferedWriter(new FileWriter(this.gpsOutputfile));
                    this.gpsFileBufferedWriter.write("# NMEA GPS data followed by ## then the time in ms before next message was sent\n");
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Error opening file: \n" + e.toString(), "File Error", 0);
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.startButton.setEnabled(true);
        try {
            gps_data_processor.close();
            if (this.saveRawData2File) {
                this.gpsFileBufferedWriter.close();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString());
        }
    }

    private void scanButtonActionPerformed(ActionEvent evt) {
        ((DefaultComboBoxModel)this.portComboBox.getModel()).removeAllElements();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            ((DefaultComboBoxModel)this.portComboBox.getModel()).addElement(portId.getName());
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.enableFlatGlobe(false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.enableFlatGlobe(true);
    }

    private void projectionComboActionPerformed(ActionEvent evt) {
        this.updateProjection();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        LatLon latLon = this.currentPos.getLatLon();
        if (latLon != null) {
            OrbitView view = (OrbitView)this.wwd.getView();
            Globe globe = this.wwd.getModel().getGlobe();
            view.applyStateIterator((ViewStateIterator)FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)view, (Globe)globe, (Position)new Position(latLon, 0.0), (Angle)view.getHeading(), (Angle)view.getPitch(), (double)3000.0));
        }
    }

    private void simRadioButtonActionPerformed(ActionEvent evt) {
        this.replayRadioButton.setSelected(false);
    }

    private void replayRadioButtonActionPerformed(ActionEvent evt) {
        this.simRadioButton.setSelected(false);
    }

    private void utcToggleButtonActionPerformed(ActionEvent evt) {
        if (this.utcToggleButton.isSelected()) {
            this.timeDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.timeDateFormat.setTimeZone(TimeZone.getDefault());
        }
        this.fixTimeTextField.setText("");
    }

    private void layerListButtonActionPerformed(ActionEvent evt) {
        boolean bl = this.layerManagerVisible = !this.layerManagerVisible;
        if (this.layerManagerVisible) {
            this.wwd.getModel().getLayers().add((Layer)this.lml);
            this.lml.setMinimized(false);
        } else {
            this.wwd.getModel().getLayers().remove((Layer)this.lml);
        }
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        LatLon latLon = this.currentPos.getLatLon();
        if (latLon != null) {
            OrbitView view = (OrbitView)this.wwd.getView();
            Globe globe = this.wwd.getModel().getGlobe();
            view.applyStateIterator((ViewStateIterator)FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)view, (Globe)globe, (Position)new Position(latLon, 0.0), (Angle)view.getHeading(), (Angle)view.getPitch(), (double)2.0E7));
        }
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        LocationSearchDialog dialog = new LocationSearchDialog((Frame)this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isLocationSelected()) {
            LatLon ll = dialog.getLocLatLon();
            this.destLatTextField.setText(ll.getLatitude().getDegrees() + "");
            this.destLonTextField.setText(ll.getLongitude().getDegrees() + "");
            this.destLatLon = ll;
            this.destinationMarker.setPosition(new Position(this.destLatLon.getLatitude(), this.destLatLon.getLongitude(), 0.0));
            this.useDestinationCheckBox.setSelected(true);
            this.manageDestinationObjects();
        }
    }

    private void setDestLocationButtonActionPerformed(ActionEvent evt) {
        try {
            this.destLatLon = new LatLon(Angle.fromDegrees((double)Double.parseDouble(this.destLatTextField.getText())), Angle.fromDegrees((double)Double.parseDouble(this.destLonTextField.getText())));
            this.destinationMarker.setPosition(new Position(this.destLatLon.getLatitude(), this.destLatLon.getLongitude(), 0.0));
            this.useDestinationCheckBox.setSelected(true);
            this.manageDestinationObjects();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Data Error: \n" + e.toString(), "Data Error", 0);
        }
    }

    private void useDestinationCheckBoxActionPerformed(ActionEvent evt) {
        this.manageDestinationObjects();
    }

    private void followTerrainCheckBoxActionPerformed(ActionEvent evt) {
        this.pathLine.setFollowTerrain(this.followTerrainCheckBox.isSelected());
    }

    private void showPathCheckBoxActionPerformed(ActionEvent evt) {
        if (this.showPathCheckBox.isSelected()) {
            this.lineLayer.addRenderable((Renderable)this.pathLine);
        } else {
            this.lineLayer.removeRenderable((Renderable)this.pathLine);
        }
    }

    private void clearPathButtonActionPerformed(ActionEvent evt) {
        ((ArrayList)this.pathLine.getPositions()).clear();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        LengthMeasurer lm = new LengthMeasurer((ArrayList)this.pathLine.getPositions());
        lm.setFollowTerrain(this.followTerrainCheckBox.isSelected());
        lm.setPathType(1);
        double len = lm.getLength(this.roundGlobe);
        JOptionPane.showMessageDialog(this, "The Path Distance is:\n Meters: " + len + "\n Miles: " + 6.21371192E-4 * len, "Path Distance", 1);
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "1 = Ideal\n2-3 = Execellent\n4-6 = Good\n7-8 = Moderate\n9-20 = Fair\n21-50 = Poor\nSee the DOP wikipedia page for more info", "DOP", 1);
    }

    private void offlineModeCheckBoxActionPerformed(ActionEvent evt) {
        WorldWind.getNetworkStatus().setOfflineMode(this.offlineModeCheckBox.isSelected());
    }

    private void bulkDownloaderButtonActionPerformed(ActionEvent evt) {
        BulkDownload_GPS.start("Bulk Imagery Download Tool", BulkDownload_GPS.AppFrame.class);
    }

    private void cacheButtonActionPerformed(ActionEvent evt) {
        CacheInspectorDialog d = new CacheInspectorDialog((Frame)this, false);
        d.setLocationRelativeTo(this);
        d.setSize(400, 400);
        d.setVisible(true);
    }

    private void manageDestinationObjects() {
        if (this.useDestinationCheckBox.isSelected()) {
            this.destinationMarker.setPosition(new Position(this.destLatLon.getLatitude(), this.destLatLon.getLongitude(), 0.0));
            this.markers.add((Marker)this.destinationMarker);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GpsInspector.this.destPosArrayList.clear();
                    GpsInspector.this.destPosArrayList.add(new LatLon(GpsInspector.this.destLatLon));
                    GpsInspector.this.destPosArrayList.add(new LatLon(GpsInspector.this.currentPos.getLatLon()));
                    GpsInspector.this.dest2PosLine.setPositions(GpsInspector.this.destPosArrayList, 0.0);
                }
            });
            this.lineLayer.addRenderable((Renderable)this.dest2PosLine);
        } else {
            this.markers.remove(this.destinationMarker);
            this.lineLayer.removeRenderable((Renderable)this.dest2PosLine);
        }
        this.wwd.redraw();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                GpsInspector app = new GpsInspector();
                RefineryUtilities.centerFrameOnScreen((Window)app);
                app.setVisible(true);
            }
        });
    }

    public boolean isFlatGlobe() {
        return this.wwd.getModel().getGlobe() instanceof FlatGlobe;
    }

    public void enableFlatGlobe(boolean flat) {
        if (this.isFlatGlobe() == flat) {
            return;
        }
        if (!flat) {
            this.wwd.getModel().setGlobe(this.roundGlobe);
            FlatOrbitView flatOrbitView = (FlatOrbitView)this.wwd.getView();
            BasicOrbitView orbitView = new BasicOrbitView();
            orbitView.setCenterPosition(flatOrbitView.getCenterPosition());
            orbitView.setZoom(flatOrbitView.getZoom());
            orbitView.setHeading(flatOrbitView.getHeading());
            orbitView.setPitch(flatOrbitView.getPitch());
            this.wwd.setView((View)orbitView);
            LayerList layers = this.wwd.getModel().getLayers();
            for (int i = 0; i < layers.size(); ++i) {
                if (!(layers.get(i) instanceof SkyColorLayer)) continue;
                layers.set(i, (Layer)new SkyGradientLayer());
            }
        } else {
            this.wwd.getModel().setGlobe((Globe)this.flatGlobe);
            this.flatGlobe.setProjection(this.getProjection());
            BasicOrbitView orbitView = (BasicOrbitView)this.wwd.getView();
            FlatOrbitView flatOrbitView = new FlatOrbitView();
            flatOrbitView.setCenterPosition(orbitView.getCenterPosition());
            flatOrbitView.setZoom(orbitView.getZoom());
            flatOrbitView.setHeading(orbitView.getHeading());
            flatOrbitView.setPitch(orbitView.getPitch());
            this.wwd.setView((View)flatOrbitView);
            LayerList layers = this.wwd.getModel().getLayers();
            for (int i = 0; i < layers.size(); ++i) {
                if (!(layers.get(i) instanceof SkyGradientLayer)) continue;
                layers.set(i, (Layer)new SkyColorLayer());
            }
        }
        this.wwd.redraw();
    }

    private String getProjection() {
        String item = (String)this.projectionCombo.getSelectedItem();
        if (item.equals("Mercator")) {
            return "gov.nasa.worldwind.globes.projectionMercator";
        }
        if (item.equals("Sinusoidal")) {
            return "gov.nasa.worldwind.globes.projectionSinusoidal";
        }
        if (item.equals("Modified Sin.")) {
            return "gov.nasa.worldwind.globes.projectionModifiedSinusoidal";
        }
        if (item.equals("Lat/Lon")) {
            return "gov.nasa.worldwind.globes.projectionLatLon";
        }
        return "gov.nasa.worldwind.globes.projectionLatLon";
    }

    private void updateProjection() {
        if (!this.isFlatGlobe()) {
            return;
        }
        this.flatGlobe.setProjection(this.getProjection());
        this.wwd.redraw();
    }

    private MarkerLayer buildMarkerLayer() {
        try {
            BasicMarkerAttributes attrs = new BasicMarkerAttributes(Material.WHITE, "gov.nasa.worldwind.render.markers.DirectionalCone", 1.0);
            this.markers = new ArrayList();
            this.currentPos = new Position(Angle.fromDegrees((double)29.5), Angle.fromDegrees((double)-95.1), 10.0);
            this.bm = new BasicMarker(this.currentPos, (MarkerAttributes)attrs, Angle.fromDegrees((double)90.0));
            this.bm.setHeading(Angle.fromDegrees((double)90.0));
            this.markers.add((Marker)this.bm);
            BasicMarkerAttributes attrs2 = new BasicMarkerAttributes(Material.RED, "gov.nasa.worldwind.render.markers.Sphere", 1.0);
            this.destinationMarker = new BasicMarker(this.currentPos, (MarkerAttributes)attrs2, Angle.fromDegrees((double)90.0));
            MarkerLayer layer = new MarkerLayer(this.markers);
            layer.setOverrideMarkerElevation(true);
            layer.setElevation(0.0);
            layer.setEnablePickSizeReturn(true);
            return layer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void insertBeforeCompass(WorldWindow wwd, Layer layer) {
        int compassPosition = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            if (!(l instanceof CompassLayer)) continue;
            compassPosition = layers.indexOf((Object)l);
        }
        layers.add(compassPosition, layer);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object value = event.getNewValue();
        if (name.equals("ids_satellites")) {
            this.satellites_ids = (Integer[])value;
        } else if (name.equals("satellite_info")) {
            this.signalDataSet.clear();
            this.seriesFix.clear();
            this.seriesZero.clear();
            this.seriesNotUsed.clear();
            SatelliteInfo[] infos = (SatelliteInfo[])value;
            for (int count = 0; count < infos.length; ++count) {
                SatelliteInfo info = infos[count];
                int signalType = XYGPSDataItem.USED_FIX;
                if (info.getSNR() == 0) {
                    signalType = XYGPSDataItem.NOT_TRACKING;
                } else if (!this.isSatUsedInFixSolution(info.getPRN())) {
                    signalType = XYGPSDataItem.NOT_USED_FIX;
                }
                if (count != infos.length - 1) {
                    this.gpsBarPainter.setSignalType(count, signalType);
                    this.signalDataSet.addValue(info.getSNR(), (Comparable)((Object)this.snrSeriesTitle), (Comparable)((Object)("" + info.getPRN())));
                    this.seriesFix.add(new XYGPSDataItem(info.getAzimuth(), info.getElevation(), info.getPRN(), "" + info.getPRN(), signalType), false);
                    continue;
                }
                this.gpsBarPainter.setSignalType(count, signalType);
                this.signalDataSet.setValue(info.getSNR(), (Comparable)((Object)this.snrSeriesTitle), (Comparable)((Object)("" + info.getPRN())));
                this.seriesFix.add(new XYGPSDataItem(info.getAzimuth(), info.getElevation(), info.getPRN(), "" + info.getPRN(), signalType), true);
            }
        } else if (name.equals("location")) {
            GPSPosition pos = (GPSPosition)value;
            if (this.decimalCheckBox.isSelected()) {
                this.latitude_label.setText(String.format("%.8f", pos.getLatitude()));
                this.longitude_label.setText(String.format("%.8f", pos.getLongitude()));
            } else {
                this.latitude_label.setText(this.decimalDegrees2DegMinSecStr(pos.getLatitude(), false));
                this.longitude_label.setText(this.decimalDegrees2DegMinSecStr(pos.getLongitude(), true));
            }
            this.currentPos = new Position(Angle.fromDegrees((double)pos.getLatitude()), Angle.fromDegrees((double)pos.getLongitude()), 0.0);
            this.bm.setPosition(this.currentPos);
            if (this.followCheckBox.isSelected()) {
                ((OrbitView)this.wwd.getView()).setCenterPosition(this.currentPos);
            }
            if (this.useDestinationCheckBox.isSelected()) {
                double distMiles = 6.21371192E-4 * LatLon.ellipsoidalDistance((LatLon)this.currentPos.getLatLon(), (LatLon)this.destLatLon, (double)6378136.3, (double)6356752.3142);
                this.destDistTextField.setText("" + String.format("%.3f", distMiles));
                Angle destHead = LatLon.greatCircleAzimuth((LatLon)this.currentPos.getLatLon(), (LatLon)this.destLatLon);
                if (destHead.getDegrees() < 0.0) {
                    destHead = destHead.addDegrees(360.0);
                }
                if (this.decimalCheckBox.isSelected()) {
                    this.heading2DestTextField.setText(destHead.toDecimalDegreesString(4));
                } else {
                    this.heading2DestTextField.setText(destHead.toDMSString());
                }
                if (this.lastSpeed >= this.MIN_MPH_SPEED_TRUST_HEADING) {
                    double hrs = distMiles / (double)this.lastSpeed;
                    int hr = (int)hrs;
                    int min = (int)((hrs - (double)hr) * 60.0);
                    int sec = (int)(((hrs - (double)hr) * 60.0 - (double)min) * 60.0);
                    this.toaTextField.setText(String.format("%6d:%2d:%2d", hr, min, sec));
                } else {
                    this.toaTextField.setText("NA");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GpsInspector.this.destPosArrayList.clear();
                        GpsInspector.this.destPosArrayList.add(new LatLon(GpsInspector.this.destLatLon));
                        GpsInspector.this.destPosArrayList.add(new LatLon(GpsInspector.this.currentPos.getLatLon()));
                        GpsInspector.this.dest2PosLine.setPositions(GpsInspector.this.destPosArrayList, 0.0);
                    }
                });
            }
            if (this.savePathCheckBox.isSelected()) {
                ((ArrayList)this.pathLine.getPositions()).add(new Position((LatLon)this.currentPos, (double)this.altitude_meters));
            }
            this.wwd.redraw();
        } else if (name.equals("altitude")) {
            this.altitude_meters = ((Float)value).floatValue();
            this.altitude_label.setText(this.altitude_meters * 3.28084f + "");
        } else if (name.equals("speed")) {
            float ft = ((Float)value).floatValue();
            this.lastSpeed = ft * 0.6213712f;
            this.speed_label.setText(this.lastSpeed + "");
        } else if (name.equals("heading")) {
            Float ft = (Float)value;
            if (this.lastSpeed >= this.MIN_MPH_SPEED_TRUST_HEADING) {
                this.heading_label.setText(ft + "");
                this.bm.setHeading(Angle.fromDegrees((double)ft.floatValue()));
                this.wwd.redraw();
                if (this.headingCheckBox.isSelected()) {
                    ((OrbitView)this.wwd.getView()).setHeading(Angle.fromDegrees((double)((Float)value).doubleValue()));
                }
            } else {
                this.heading_label.setText("NA");
            }
        } else if (name.equals("Time_of_fix")) {
            this.fixTimeTextField.setText(this.timeDateFormat.format(((GregorianCalendar)value).getTime()));
        } else if (name.equals("Fix_Information")) {
            switch ((Integer)value) {
                case 1: {
                    this.fixInfoTextField.setText("No Fix");
                    break;
                }
                case 2: {
                    this.fixInfoTextField.setText("2D Fix");
                    break;
                }
                case 3: {
                    this.fixInfoTextField.setText("3D Fix");
                }
            }
        } else if (name.equals("Fix_Quality")) {
            this.fixQualTextField.setText(this.fixQualityStr[(Integer)value]);
        } else if (name.equals("position_dop")) {
            this.pdopTextField.setText(String.format("%.2f", (Float)value));
        } else if (name.equals("horizontal_dop")) {
            this.hdopTextField.setText(String.format("%.2f", (Float)value));
        } else if (name.equals("vertical_dop")) {
            this.vdopTextField.setText(String.format("%.2f", (Float)value));
        }
    }

    private boolean isSatUsedInFixSolution(int satID) {
        try {
            for (int i = 0; i < this.satellites_ids.length; ++i) {
                if (satID != this.satellites_ids[i]) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public String decimalDegrees2DegMinSecStr(double degrees, boolean eastWest) {
        boolean neg = false;
        if (degrees < 0.0) {
            neg = true;
        }
        degrees = Math.abs(degrees);
        int deg = (int)degrees;
        degrees = (degrees - (double)deg) * 60.0;
        int min = (int)degrees;
        double sec = (degrees - (double)min) * 60.0;
        if (!eastWest) {
            String dir = "N";
            if (neg) {
                dir = "S";
            }
            return String.format("%d\u00b0 %d' %.4f\" " + dir, deg, min, sec);
        }
        String dir = "E";
        if (neg) {
            dir = "W";
        }
        return String.format("%d\u00b0 %d' %.4f\" " + dir, deg, min, sec);
    }
}

