/*
 * Decompiled with CFR 0.152.
 */
package name.gano;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.poi.PointOfInterest;
import gov.nasa.worldwind.poi.YahooGazetteer;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LocationSearchDialog
extends JDialog {
    private YahooGazetteer yahooGaz = new YahooGazetteer();
    private List<PointOfInterest> results;
    private boolean locationSelected = false;
    private LatLon locLatLon;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField queryTextField;
    private JList resultsList;

    public LocationSearchDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        DefaultListModel listModel = new DefaultListModel();
        this.resultsList.setModel(listModel);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.queryTextField = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.resultsList = new JList();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Arial", 1, 14));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/icons/Earth-Scan-24x24.png")));
        this.jLabel1.setText("Location Search");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -1, 273, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel2.setText("Location:");
        this.queryTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                LocationSearchDialog.this.queryTextFieldKeyPressed(evt);
            }
        });
        this.jButton1.setText("Search");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocationSearchDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Results:");
        this.jScrollPane1.setViewportView(this.resultsList);
        this.jButton2.setText("Select Location");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocationSearchDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Cancel");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocationSearchDialog.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.queryTextField, -1, 219, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 60, Short.MAX_VALUE).addComponent(this.jButton2)).addComponent(this.jScrollPane1, -1, 230, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.queryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jScrollPane1, -1, 129, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton3)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.results = this.yahooGaz.findPlaces(this.queryTextField.getText());
        ((DefaultListModel)this.resultsList.getModel()).removeAllElements();
        for (PointOfInterest p : this.results) {
            ((DefaultListModel)this.resultsList.getModel()).addElement(p);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.locationSelected = false;
        this.setVisible(false);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int i = this.resultsList.getSelectedIndex();
        if (i >= 0) {
            this.locationSelected = true;
            this.locLatLon = this.results.get(i).getLatlon();
            this.setVisible(false);
        }
    }

    private void queryTextFieldKeyPressed(KeyEvent evt) {
        if (10 == evt.getKeyCode()) {
            this.jButton1.doClick();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LocationSearchDialog dialog = new LocationSearchDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public boolean isLocationSelected() {
        return this.locationSelected;
    }

    public LatLon getLocLatLon() {
        return this.locLatLon;
    }
}

