/*
 * Decompiled with CFR 0.152.
 */
package name.gano;

import java.util.Hashtable;
import name.gano.gps.GPSSimulatedNmeaDevice;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSRawDataListener;
import org.dinopolis.gpstool.gpsinput.GPSSerialDevice;
import org.dinopolis.gpstool.gpsinput.nmea.GPSNmeaDataProcessor;

public class TestGPS {
    static boolean simulation = true;
    static GPSNmeaDataProcessor gps_data_processor;
    static int serial_port_speed;
    static String serial_port_name;

    public static void main(String[] args) {
        gps_data_processor = new GPSNmeaDataProcessor();
        gps_data_processor.addGPSRawDataListener(new GPSRawDataListener(){

            public void gpsRawDataReceived(char[] data, int offset, int length) {
                System.out.print("RAWLOG: " + new String(data, offset, length));
            }
        });
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        if (serial_port_name != null) {
            environment.put("port_name", serial_port_name);
        }
        if (serial_port_speed > -1) {
            environment.put("port_speed", new Integer(serial_port_speed));
        }
        GPSDevice gps_device = simulation ? new GPSSimulatedNmeaDevice() : new GPSSerialDevice();
        try {
            gps_device.init(environment);
            gps_data_processor.setGPSDevice(gps_device);
            gps_data_processor.open();
            System.out.println("GPSInfo:");
            String[] infos = gps_data_processor.getGPSInfo();
            for (int index = 0; index < infos.length; ++index) {
                System.out.println(infos[index]);
            }
            Thread.sleep(15000L);
            gps_data_processor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        serial_port_speed = 4800;
        serial_port_name = "COM3";
    }
}

