/*
 * Decompiled with CFR 0.152.
 */
package name.gano.jfreechart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.RectangularShape;
import name.gano.jfreechart.XYGPSDataItem;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;

public class GPSBarPainter
extends StandardBarPainter {
    private Paint itemPaint = Color.YELLOW;
    private Stroke outlineStroke = new BasicStroke(2.0f);
    private int[] signalType = new int[12];

    public void paintBar(Graphics2D g2, BarRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base) {
        GradientPaintTransformer t = renderer.getGradientPaintTransformer();
        if (t != null && this.itemPaint instanceof GradientPaint) {
            this.itemPaint = t.transform((GradientPaint)this.itemPaint, (Shape)bar);
        }
        g2.setPaint(this.itemPaint);
        if (this.signalType[column] != XYGPSDataItem.NOT_USED_FIX) {
            g2.fill(bar);
        } else {
            g2.setPaint(this.itemPaint);
            g2.setStroke(this.outlineStroke);
            g2.draw(bar);
        }
    }

    public Color getBarColor() {
        return (Color)this.itemPaint;
    }

    public void setBarColor(Color barColor) {
        this.itemPaint = barColor;
    }

    public int getSignalType(int satIndex) {
        return this.signalType[satIndex];
    }

    public void setSignalType(int satIndex, int signalType) {
        this.signalType[satIndex] = signalType;
    }
}

