/*
 * Decompiled with CFR 0.152.
 */
package name.gano.jfreechart;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.data.xy.XYDataset;

public class ScatterPolarItemRenderer
extends DefaultPolarItemRenderer {
    public static final int FILLED_CIRCLE = 0;
    public static final int CIRCLE = 1;
    public static final int FILLED_SQUARE = 2;
    public static final int SQUARE = 3;
    private int defaultSize = 6;
    protected HashMap<Integer, Integer> seriesSize = new HashMap();
    private int defaultShape = 0;
    protected HashMap<Integer, Integer> seriesShape = new HashMap();

    public void drawSeries(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, PolarPlot plot, XYDataset dataset, int seriesIndex) {
        Polygon poly = new Polygon();
        int numPoints = dataset.getItemCount(seriesIndex);
        g2.setPaint(this.lookupSeriesPaint(seriesIndex));
        g2.setStroke(this.lookupSeriesStroke(seriesIndex));
        for (int i = 0; i < numPoints; ++i) {
            double theta = dataset.getXValue(seriesIndex, i);
            double radius = dataset.getYValue(seriesIndex, i);
            Point p = plot.translateValueThetaRadiusToJava2D(theta, radius, dataArea);
            this.drawScatterPoint(p, seriesIndex, g2);
        }
    }

    protected void drawScatterPoint(Point p, int seriesIndex, Graphics2D g2) {
        int size = this.seriesSize.containsKey(seriesIndex) ? this.seriesSize.get(seriesIndex).intValue() : this.getDefaultSize();
        int shape = this.seriesShape.containsKey(seriesIndex) ? this.seriesShape.get(seriesIndex).intValue() : this.getDefaultScatterShape();
        switch (shape) {
            case 0: {
                g2.fillOval(p.x - size / 2, p.y - size / 2, size, size);
                break;
            }
            case 1: {
                g2.drawOval(p.x - size / 2, p.y - size / 2, size, size);
                break;
            }
            case 2: {
                g2.drawRect(p.x - size / 2, p.y - size / 2, size, size);
                break;
            }
            case 3: {
                g2.fillRect(p.x - size / 2, p.y - size / 2, size, size);
                break;
            }
            default: {
                g2.drawOval(p.x, p.y, size, size);
            }
        }
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    public int getSeriesSize(int series) {
        return this.seriesSize.get(series);
    }

    public void setSeriesSize(int series, int size) {
        this.seriesSize.put(series, size);
    }

    public int getDefaultScatterShape() {
        return this.defaultShape;
    }

    public void setDefaultScatterShape(int defaultShape) {
        this.defaultShape = defaultShape;
    }

    public int getSeriesScatterShape(int series) {
        return this.seriesShape.get(series);
    }

    public void setSeriesScatterShape(int series, int shape) {
        this.seriesShape.put(series, shape);
    }
}

