/*
 * Decompiled with CFR 0.152.
 */
package name.gano.jfreechart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import name.gano.jfreechart.ScatterPolarItemRenderer;
import name.gano.jfreechart.XYGPSDataItem;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class SctterPlotItemGPSRenderer
extends ScatterPolarItemRenderer {
    private Color labelColor = Color.BLACK;
    private Color labelColorUnFilled = Color.YELLOW;

    public SctterPlotItemGPSRenderer() {
        this.setDefaultSize(18);
    }

    public void drawSeries(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, PolarPlot plot, XYDataset dataset, int seriesIndex) {
        Polygon poly = new Polygon();
        int numPoints = dataset.getItemCount(seriesIndex);
        g2.setPaint(this.lookupSeriesPaint(seriesIndex));
        g2.setStroke(this.lookupSeriesStroke(seriesIndex));
        for (int i = 0; i < numPoints; ++i) {
            double theta = dataset.getXValue(seriesIndex, i);
            double radius = dataset.getYValue(seriesIndex, i);
            Point p = plot.translateValueThetaRadiusToJava2D(theta, radius, dataArea);
            XYGPSDataItem gpsItem = (XYGPSDataItem)((XYSeriesCollection)dataset).getSeries(seriesIndex).getDataItem(i);
            this.drawScatterPoint(p, gpsItem, seriesIndex, g2);
        }
    }

    protected void drawScatterPoint(Point p, XYGPSDataItem gpsItem, int seriesIndex, Graphics2D g2) {
        Paint paint_old = g2.getPaint();
        int size = this.seriesSize.containsKey(seriesIndex) ? ((Integer)this.seriesSize.get(seriesIndex)).intValue() : this.getDefaultSize();
        int shape = this.seriesShape.containsKey(seriesIndex) ? ((Integer)this.seriesShape.get(seriesIndex)).intValue() : this.getDefaultScatterShape();
        if (gpsItem.getSignalType() == XYGPSDataItem.NOT_USED_FIX) {
            shape = 1;
        } else if (gpsItem.getSignalType() == XYGPSDataItem.NOT_TRACKING) {
            g2.setPaint(Color.RED);
            shape = 3;
        }
        switch (shape) {
            case 0: {
                g2.fillOval(p.x - size / 2, p.y - size / 2, size, size);
                break;
            }
            case 1: {
                g2.drawOval(p.x - size / 2, p.y - size / 2, size, size);
                break;
            }
            case 2: {
                g2.fillRect(p.x - size / 2, p.y - size / 2, size, size);
                break;
            }
            case 3: {
                g2.drawRect(p.x - size / 2, p.y - size / 2, size, size);
                break;
            }
            default: {
                g2.drawOval(p.x, p.y, size, size);
            }
        }
        if (shape == 1 || shape == 3) {
            g2.setPaint(this.labelColorUnFilled);
        } else {
            g2.setPaint(this.labelColor);
        }
        int fontSize = g2.getFont().getSize();
        g2.drawString(gpsItem.getLabel(), p.x - fontSize / 2 - 2 * (gpsItem.getLabel().length() - 1), p.y + fontSize / 2 - 1);
        g2.setPaint(paint_old);
    }

    public Color getLabelColorUnFilled() {
        return this.labelColorUnFilled;
    }

    public void setLabelColorUnFilled(Color labelColorUnFilled) {
        this.labelColorUnFilled = labelColorUnFilled;
    }
}

