/*
 * Decompiled with CFR 0.152.
 */
package name.gano.utils;

import gov.nasa.worldwind.WorldWind;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheCleaner {
    private static long HIGH_WATER_IN_BYTES = 20000L * (long)Math.pow(2.0, 20.0);
    private static long LOW_WATER_IN_BYTES = (long)((double)HIGH_WATER_IN_BYTES * 0.8);

    public static CacheLocationData analyseCacheLocation(File location) {
        CacheLocationData cld = new CacheLocationData(location);
        cld.directories = CacheCleaner.getDirectories(location);
        for (CacheDirectory cd : cld.directories) {
            cld.fileCount += (long)cd.fileCount;
            cld.sizeInBytes += cd.sizeInBytes;
        }
        Collections.sort(cld.directories);
        return cld;
    }

    public static List<CacheDirectory> getDirectories(File directory) {
        LinkedList<CacheDirectory> cacheDirList = new LinkedList<CacheDirectory>();
        if (directory.exists()) {
            File[] files;
            CacheDirectory cd = new CacheDirectory(directory);
            LinkedList<CacheDirectory> subDirs = new LinkedList<CacheDirectory>();
            for (File f : files = directory.listFiles()) {
                if (f.isFile()) {
                    ++cd.fileCount;
                    cd.sizeInBytes += f.length();
                    continue;
                }
                if (!f.isDirectory()) continue;
                subDirs.addAll(CacheCleaner.getDirectories(f));
            }
            if (cd.fileCount > 0) {
                cacheDirList.add(cd);
            }
            if (subDirs.size() > 0) {
                cacheDirList.addAll(subDirs);
            }
        }
        return cacheDirList;
    }

    public static void cleanupCacheLocation(CacheLocationData location, long lowWaterInBytes) {
        for (CacheDirectory dir : location.directories) {
            File[] files;
            if (location.sizeInBytes <= lowWaterInBytes) break;
            for (File f : files = dir.file.listFiles()) {
                long size = f.length();
                if (!f.delete()) continue;
                --location.fileCount;
                location.sizeInBytes -= size;
            }
            dir.file.delete();
        }
    }

    public static void main(String[] args) {
        File writeCache = WorldWind.getDataFileStore().getWriteLocation();
        System.out.println("Analyzing: " + writeCache.getAbsolutePath());
        CacheLocationData cld = CacheCleaner.analyseCacheLocation(writeCache);
        System.out.println("Size: " + (int)((double)cld.sizeInBytes / Math.pow(2.0, 20.0)) + "Mb in " + cld.fileCount + " file(s) from " + cld.directories.size() + " dir(s)");
        if (cld.sizeInBytes >= HIGH_WATER_IN_BYTES) {
            System.out.println("Cleaning down to " + (int)((double)LOW_WATER_IN_BYTES / Math.pow(2.0, 20.0)) + "Mb");
            CacheCleaner.cleanupCacheLocation(cld, LOW_WATER_IN_BYTES);
            System.out.println("Size: " + (int)((double)cld.sizeInBytes / Math.pow(2.0, 20.0)) + "Mb in " + cld.fileCount + " file(s)");
        } else {
            System.out.println("No cleanup needed until " + (int)((double)HIGH_WATER_IN_BYTES / Math.pow(2.0, 20.0)) + "Mb");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheDirectory
    implements Comparable<CacheDirectory> {
        public File file;
        public int fileCount;
        public long sizeInBytes;

        public CacheDirectory(File file) {
            this.file = file;
            this.fileCount = 0;
            this.sizeInBytes = 0L;
        }

        @Override
        public int compareTo(CacheDirectory that) {
            return (int)(this.file.lastModified() - that.file.lastModified());
        }
    }

    public static class CacheLocationData {
        public File cacheLocation;
        public List<CacheDirectory> directories;
        public long fileCount;
        public long sizeInBytes;

        public CacheLocationData(File location) {
            this.cacheLocation = location;
            this.fileCount = 0L;
            this.sizeInBytes = 0L;
        }
    }
}

