/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSException;

public class GPSFileDevice
implements GPSDevice {
    public static final String PATH_NAME_KEY = "path_name";
    protected File file_ = null;
    protected FileInputStream inputstream_ = null;
    protected FileOutputStream outputstream_ = null;

    public void init(Hashtable environment) throws GPSException {
        String file_name = (String)environment.get(PATH_NAME_KEY);
        if (file_name == null) {
            throw new GPSException("File name not found in environment!");
        }
        this.file_ = new File(file_name);
    }

    public void open() throws GPSException {
    }

    public void close() throws GPSException {
        try {
            if (this.inputstream_ != null) {
                this.inputstream_.close();
            }
            if (this.outputstream_ != null) {
                this.outputstream_.close();
            }
        }
        catch (IOException e) {
            throw new GPSException(e.getMessage());
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.file_ == null) {
            return null;
        }
        if (this.inputstream_ == null) {
            this.inputstream_ = new FileInputStream(this.file_);
        }
        return this.inputstream_;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.file_ == null) {
            return null;
        }
        if (this.outputstream_ == null) {
            this.outputstream_ = new FileOutputStream(this.file_);
        }
        return this.outputstream_;
    }
}

