/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSException;

public class GPSNetworkGpsdDevice
implements GPSDevice {
    public static final String GPSD_HOST_KEY = "gps_host";
    public static final String GPSD_PORT_KEY = "gpsd_port";
    public static final String RAW_DATA_LOG_FILENAME_KEY = "data_logfile";
    protected static final String DEFAULT_GPSD_HOST = "localhost";
    protected static final int DEFAULT_GPSD_PORT = 2947;
    protected String gpsd_host_;
    protected int gpsd_port_;
    protected Socket gpsd_socket_;
    protected InputStream in_stream_;
    protected OutputStream out_stream_;

    public void init(Hashtable environment) throws GPSException {
        try {
            this.gpsd_host_ = (String)environment.get(GPSD_HOST_KEY);
            if (this.gpsd_host_ == null) {
                this.gpsd_host_ = DEFAULT_GPSD_HOST;
            }
            this.gpsd_port_ = environment.containsKey(GPSD_PORT_KEY) ? (Integer)environment.get(GPSD_PORT_KEY) : 2947;
        }
        catch (Exception e) {
            throw new GPSException("Invalid environment set for network gpsd connection: " + e.getMessage());
        }
    }

    public void open() throws GPSException {
        try {
            int data;
            this.gpsd_socket_ = new Socket(this.gpsd_host_, this.gpsd_port_);
            this.in_stream_ = new BufferedInputStream(this.gpsd_socket_.getInputStream());
            this.out_stream_ = new BufferedOutputStream(this.gpsd_socket_.getOutputStream());
            OutputStreamWriter out = new OutputStreamWriter(this.out_stream_);
            out.write("R\n\r");
            out.flush();
            InputStreamReader in = new InputStreamReader(this.in_stream_);
            while ((data = in.read()) != 13) {
            }
        }
        catch (UnknownHostException uhe) {
            throw new GPSException(uhe.getMessage());
        }
        catch (IOException ioe) {
            throw new GPSException(ioe.getMessage());
        }
        catch (SecurityException se) {
            throw new GPSException(se.getMessage());
        }
    }

    public void close() throws GPSException {
        try {
            if (this.in_stream_ != null) {
                this.in_stream_.close();
            }
            if (this.out_stream_ != null) {
                this.out_stream_.close();
            }
            if (this.gpsd_socket_ != null) {
                this.gpsd_socket_.close();
            }
        }
        catch (IOException ioe) {
            throw new GPSException(ioe.getMessage());
        }
        this.in_stream_ = null;
        this.out_stream_ = null;
        this.gpsd_socket_ = null;
    }

    public InputStream getInputStream() throws IOException {
        return this.in_stream_;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out_stream_;
    }
}

