/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.dinopolis.gpstool.gpsinput.GPSRawDataListener;

public class GPSRawDataFileLogger
implements GPSRawDataListener {
    protected Writer out_;
    protected String log_filename_;
    protected boolean always_close_ = false;
    protected boolean io_error_occured_ = false;

    public GPSRawDataFileLogger(String log_filename) {
        this.log_filename_ = log_filename;
    }

    public void gpsRawDataReceived(char[] raw_data, int offset, int length) {
        if (this.io_error_occured_) {
            return;
        }
        try {
            if (this.always_close_ || this.out_ == null) {
                this.out_ = new FileWriter(this.log_filename_, true);
            }
            this.out_.write(raw_data, offset, length);
            this.out_.flush();
            if (this.always_close_) {
                this.out_.close();
            }
        }
        catch (IOException ioe) {
            System.err.println("Cannot open/write to logfile '" + this.log_filename_ + "' - stop logging!");
            ioe.printStackTrace();
            this.io_error_occured_ = true;
        }
    }
}

