/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import java.io.FileInputStream;
import java.util.List;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.util.io.Tokenizer;

public class GarminTemperaturCorrection {
    double[] average_freq = new double[120];
    double[] real_freq = new double[120];

    public GarminTemperaturCorrection() {
    }

    public GarminTemperaturCorrection(GarminPacket garmin_packet) {
        this.addData(garmin_packet);
    }

    public void addData(GarminPacket garmin_packet) {
        int temperatur = garmin_packet.getNextAsSignedInt();
        int unknown = garmin_packet.getNextAsWord();
        double freq1 = garmin_packet.getNextAsDouble();
        double freq2 = garmin_packet.getNextAsDouble();
        this.average_freq[temperatur + 34] = freq1;
        this.real_freq[temperatur + 34] = freq2;
    }

    public double[] getAverageFrequencies() {
        return this.average_freq;
    }

    public double[] getRealFrequencies() {
        return this.real_freq;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GarminTemperaturCorrection[");
        buffer.append("]");
        return buffer.toString();
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println("need to give a filename to read packet data from!");
                return;
            }
            Tokenizer tokenizer = new Tokenizer(new FileInputStream(args[0]));
            tokenizer.setDelimiters(" ");
            List tokens = tokenizer.nextLine();
            GarminPacket first = new GarminPacket(39, tokens.size());
            for (int index = 0; index < tokens.size(); ++index) {
                first.put(Integer.parseInt((String)tokens.get(index)));
            }
            GarminTemperaturCorrection temp_correction = new GarminTemperaturCorrection(first);
            while (tokenizer.hasNextLine()) {
                tokens = tokenizer.nextLine();
                GarminPacket data = new GarminPacket(39, tokens.size());
                for (int index = 0; index < tokens.size(); ++index) {
                    data.put(Integer.parseInt((String)tokens.get(index)));
                }
                temp_correction.addData(data);
            }
            double[] average_freq = temp_correction.getAverageFrequencies();
            double[] real_freq = temp_correction.getRealFrequencies();
            for (int count = 0; count < average_freq.length; ++count) {
                System.out.println(count - 34 + ", " + average_freq[count] + ", " + real_freq[count]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

