/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.GPSTrackpoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrackpoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminUnsupportedMethodException;

public class GarminTrackpointD300
implements GarminTrackpoint {
    public double latitude_;
    public double longitude_;
    public long time_;
    public boolean new_track_;
    protected static final int TRACKPOINT_TYPE = 300;

    public GarminTrackpointD300() {
    }

    public GarminTrackpointD300(int[] buffer) {
        this.latitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 2);
        this.longitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 6);
        this.time_ = GarminDataConverter.getGarminLongWord(buffer, 10);
        this.new_track_ = GarminDataConverter.getGarminBoolean(buffer, 14);
    }

    public GarminTrackpointD300(GarminPacket pack) {
        this.latitude_ = pack.getNextAsSemicircleDegrees();
        this.longitude_ = pack.getNextAsSemicircleDegrees();
        this.time_ = pack.getNextAsLongWord();
        this.new_track_ = pack.getNextAsBoolean();
    }

    public GarminTrackpointD300(GPSTrackpoint trackpoint) {
        this.latitude_ = trackpoint.getLatitude();
        this.longitude_ = trackpoint.getLongitude();
        this.time_ = GarminDataConverter.convertDateToGarminTime(trackpoint.getDate());
        this.new_track_ = trackpoint.isNewTrack();
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 13;
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        int[] data = new int[data_length];
        data = GarminDataConverter.setGarminSemicircleDegrees(this.latitude_, data, 0);
        data = GarminDataConverter.setGarminSemicircleDegrees(this.longitude_, data, 4);
        data = GarminDataConverter.setGarminLongWord(this.time_, data, 8);
        data = GarminDataConverter.setGarminBoolean(this.new_track_, data, 12);
        pack.put(data);
        return pack;
    }

    public int getType() throws GarminUnsupportedMethodException {
        return 300;
    }

    public double getLatitude() throws GarminUnsupportedMethodException {
        return this.latitude_;
    }

    public void setLatitude(double latitude) throws GarminUnsupportedMethodException {
        this.latitude_ = latitude;
    }

    public double getLongitude() throws GarminUnsupportedMethodException {
        return this.longitude_;
    }

    public void setLongitude(double longitude) throws GarminUnsupportedMethodException {
        this.longitude_ = longitude;
    }

    public long getTime() throws GarminUnsupportedMethodException {
        return this.time_;
    }

    public void setTime(long time) throws GarminUnsupportedMethodException {
        this.time_ = time;
    }

    public float getAltitude() throws GarminUnsupportedMethodException {
        return 1.0E25f;
    }

    public void setAltitude(float altitude) throws GarminUnsupportedMethodException {
        throw new GarminUnsupportedMethodException("Trackpoint D300 does not support altitude.");
    }

    public float getDepth() throws GarminUnsupportedMethodException {
        return 1.0E25f;
    }

    public void setDepth(float depth) throws GarminUnsupportedMethodException {
        throw new GarminUnsupportedMethodException("Trackpoint D300 does not support depth.");
    }

    public boolean isNewTrack() throws GarminUnsupportedMethodException {
        return this.new_track_;
    }

    public void setNewTrack(boolean new_track) throws GarminUnsupportedMethodException {
        this.new_track_ = new_track;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GarminTrackpoint[");
        buffer.append("lat=").append(this.latitude_).append(", ");
        buffer.append("lon=").append(this.longitude_).append(", ");
        buffer.append("time=").append(this.time_).append(", ");
        buffer.append("new_track=").append(this.new_track_);
        buffer.append("]");
        return buffer.toString();
    }
}

