/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.GPSWaypoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointBase;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointSymbols;

public class GarminWaypointD103
extends GarminWaypointBase {
    protected int display_option_;
    protected int symbol_;
    protected int symbol_type_;
    protected static final byte WAYPOINT_TYPE = 103;
    protected static final String[] DISPLAY_OPTIONS = new String[]{"symbol+name", "symbol", "symbol+comment"};
    protected static final int[] SYMBOL_TYPE = new int[]{18, 10, 8220, 170, 7, 150, 0, 19, 177, 14, 178, 151, 171, 156, 8196};

    public GarminWaypointD103() {
    }

    public GarminWaypointD103(int[] buffer) {
        this.identification_ = GarminDataConverter.getGarminString(buffer, 2, 6).trim();
        this.latitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 8);
        this.longitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 12);
        this.comment_ = GarminDataConverter.getGarminString(buffer, 20, 40).trim();
        this.symbol_ = GarminDataConverter.getGarminByte(buffer, 60);
        this.symbol_type_ = SYMBOL_TYPE[this.symbol_];
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.display_option_ = GarminDataConverter.getGarminByte(buffer, 61);
    }

    public GarminWaypointD103(GarminPacket pack) {
        this.identification_ = pack.getNextAsString(6).trim();
        this.latitude_ = pack.getNextAsSemicircleDegrees();
        this.longitude_ = pack.getNextAsSemicircleDegrees();
        pack.getNextAsLongWord();
        this.comment_ = pack.getNextAsString(40).trim();
        this.symbol_ = pack.getNextAsByte();
        this.symbol_type_ = SYMBOL_TYPE[this.symbol_];
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.display_option_ = pack.getNextAsByte();
    }

    public GarminWaypointD103(GPSWaypoint waypoint) {
        int val = -1;
        String tmp = waypoint.getIdentification();
        this.identification_ = tmp == null ? "" : tmp;
        this.latitude_ = waypoint.getLatitude();
        this.longitude_ = waypoint.getLongitude();
        tmp = waypoint.getComment();
        this.comment_ = tmp == null ? "" : tmp;
        this.symbol_type_ = (short)GarminWaypointSymbols.getSymbolId(waypoint.getSymbolName());
        if (this.symbol_type_ < 0) {
            this.symbol_type_ = 18;
        }
        for (int i = 0; i < SYMBOL_TYPE.length; ++i) {
            if (SYMBOL_TYPE[i] != this.symbol_type_) continue;
            val = i;
        }
        if (val == -1) {
            val = 0;
        }
        this.symbol_ = val;
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.display_option_ = 0;
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 60;
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsString(this.identification_, 6, false);
        pack.setNextAsSemicircleDegrees(this.latitude_);
        pack.setNextAsSemicircleDegrees(this.longitude_);
        pack.setNextAsLongWord(0L);
        pack.setNextAsString(this.comment_, 40, false);
        pack.setNextAsByte(this.symbol_);
        pack.setNextAsByte(this.display_option_);
        return pack;
    }

    public byte getType() {
        return 103;
    }

    public String getDisplayOptions() {
        return DISPLAY_OPTIONS[this.display_option_];
    }

    public void setSymbolName(String name) throws UnsupportedOperationException {
        this.symbol_type_ = (short)GarminWaypointSymbols.getSymbolId(name);
        if (this.symbol_type_ < 0) {
            this.symbol_type_ = 18;
        }
        int val = -1;
        for (int i = 0; i < SYMBOL_TYPE.length; ++i) {
            if (SYMBOL_TYPE[i] != this.symbol_type_) continue;
            val = i;
        }
        if (val == -1) {
            val = 0;
        }
        this.symbol_ = val;
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
    }
}

