/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import java.awt.Color;
import org.dinopolis.gpstool.gpsinput.GPSWaypoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD103;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointSymbols;

public class GarminWaypointD107
extends GarminWaypointD103 {
    protected Color color_;
    protected short color_index_;
    protected float distance_;
    protected static final byte WAYPOINT_TYPE = 107;
    protected static final Color[] COLORS = new Color[]{Color.black, Color.red, Color.green, Color.blue};
    protected static final int DEFAULT_COLOR_INDEX = 0;

    public GarminWaypointD107() {
    }

    public GarminWaypointD107(int[] buffer) {
        this.identification_ = GarminDataConverter.getGarminString(buffer, 2, 6).trim();
        this.latitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 8);
        this.longitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 12);
        this.comment_ = GarminDataConverter.getGarminString(buffer, 20, 40).trim();
        this.symbol_ = GarminDataConverter.getGarminByte(buffer, 60);
        this.symbol_type_ = SYMBOL_TYPE[this.symbol_];
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.display_option_ = GarminDataConverter.getGarminByte(buffer, 61);
        this.distance_ = GarminDataConverter.getGarminFloat(buffer, 62);
        this.color_index_ = GarminDataConverter.getGarminByte(buffer, 63);
        if (this.color_index_ == 255) {
            this.color_index_ = 0;
        }
        this.color_ = COLORS[this.color_index_];
    }

    public GarminWaypointD107(GarminPacket pack) {
        this.identification_ = pack.getNextAsString(6).trim();
        this.latitude_ = pack.getNextAsSemicircleDegrees();
        this.longitude_ = pack.getNextAsSemicircleDegrees();
        pack.getNextAsLongWord();
        this.comment_ = pack.getNextAsString(40).trim();
        this.symbol_ = pack.getNextAsByte();
        this.symbol_type_ = SYMBOL_TYPE[this.symbol_];
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.display_option_ = pack.getNextAsByte();
        this.distance_ = pack.getNextAsFloat();
        this.color_index_ = pack.getNextAsByte();
        if (this.color_index_ == 255) {
            this.color_index_ = 0;
        }
        this.color_ = COLORS[this.color_index_];
    }

    public GarminWaypointD107(GPSWaypoint waypoint) {
        int val = -1;
        String tmp = waypoint.getIdentification();
        this.identification_ = tmp == null ? "" : tmp;
        this.latitude_ = waypoint.getLatitude();
        this.longitude_ = waypoint.getLongitude();
        tmp = waypoint.getComment();
        this.comment_ = tmp == null ? "" : tmp;
        this.symbol_type_ = (short)GarminWaypointSymbols.getSymbolId(waypoint.getSymbolName());
        if (this.symbol_type_ < 0) {
            this.symbol_type_ = 18;
        }
        for (int i = 0; i < SYMBOL_TYPE.length; ++i) {
            if (SYMBOL_TYPE[i] != this.symbol_type_) continue;
            val = i;
        }
        if (val == -1) {
            val = 0;
        }
        this.symbol_ = val;
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.display_option_ = 0;
        this.distance_ = 0.0f;
        this.color_index_ = (short)255;
        if (this.color_index_ == 255) {
            this.color_index_ = 0;
        }
        this.color_ = COLORS[this.color_index_];
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 65;
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsString(this.identification_, 6, false);
        pack.setNextAsSemicircleDegrees(this.latitude_);
        pack.setNextAsSemicircleDegrees(this.longitude_);
        pack.setNextAsLongWord(0L);
        pack.setNextAsString(this.comment_, 40, false);
        pack.setNextAsByte(this.symbol_);
        pack.setNextAsByte(this.display_option_);
        pack.setNextAsFloat(this.distance_);
        pack.setNextAsByte(this.color_index_);
        return pack;
    }

    public Color getColor() {
        return this.color_;
    }
}

