/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.GPSWaypoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD108;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointSymbols;

public class GarminWaypointD109
extends GarminWaypointD108 {
    protected short color_value_;
    protected short dtype_;
    protected long ete_;
    protected static final byte WAYPOINT_TYPE = 109;
    protected static final String[] DISPLAY_OPTIONS = new String[]{"symbol+name", "symbol", "symbol+comment"};
    protected static final String[] CLASS_NAMES = new String[]{"user", "aviation_airport", "aviation_intersection", "aviation_NDB", "aviation_VOR", "aviation_airport_runway", "aviation_airport_intersection", "aviation_airport_NDB", "map_point", "map_area", "map_intersection", "map_address", "map_label", "map_line"};

    public GarminWaypointD109() {
    }

    public GarminWaypointD109(int[] buffer) {
        this.dtype_ = GarminDataConverter.getGarminByte(buffer, 2);
        this.class_type_ = GarminDataConverter.getGarminByte(buffer, 3);
        this.class_name_ = this.class_type_ < CLASS_NAMES.length ? CLASS_NAMES[this.class_type_] : "unknown";
        this.color_value_ = GarminDataConverter.getGarminByte(buffer, 4);
        this.color_index_ = this.color_value_ & 0x1F;
        if (this.color_index_ == 31) {
            this.color_index_ = 15;
        }
        this.color_ = COLORS[this.color_index_];
        this.display_index_ = (this.color_value_ & 0x70) << 5;
        this.display_options_ = this.display_index_ < DISPLAY_OPTIONS.length ? DISPLAY_OPTIONS[this.display_index_] : "unknown";
        this.attributes_ = GarminDataConverter.getGarminByte(buffer, 5);
        this.symbol_type_ = GarminDataConverter.getGarminWord(buffer, 6);
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.subclass_ = GarminDataConverter.getGarminByteArray(buffer, 8, 18);
        this.latitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 26);
        this.longitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 30);
        this.altitude_ = GarminDataConverter.getGarminFloat(buffer, 34);
        this.depth_ = GarminDataConverter.getGarminFloat(buffer, 38);
        this.distance_ = GarminDataConverter.getGarminFloat(buffer, 42);
        this.state_code_ = GarminDataConverter.getGarminString(buffer, 46, 2).trim();
        this.country_code_ = GarminDataConverter.getGarminString(buffer, 48, 2).trim();
        this.ete_ = GarminDataConverter.getGarminLongWord(buffer, 50);
        this.identification_ = GarminDataConverter.getGarminString(buffer, 54, 51).trim();
        int offset = 54 + this.identification_.length() + 1;
        this.comment_ = GarminDataConverter.getGarminString(buffer, offset, 51).trim();
        offset = offset + this.comment_.length() + 1;
        this.facility_ = GarminDataConverter.getGarminString(buffer, offset, 31).trim();
        offset = offset + this.facility_.length() + 1;
        this.city_ = GarminDataConverter.getGarminString(buffer, offset, 25).trim();
        offset = offset + this.city_.length() + 1;
        this.address_ = GarminDataConverter.getGarminString(buffer, offset, 51).trim();
        offset = offset + this.address_.length() + 1;
        this.cross_road_ = GarminDataConverter.getGarminString(buffer, offset, 51).trim();
        offset = offset + this.cross_road_.length() + 1;
    }

    public GarminWaypointD109(GarminPacket pack) {
        this.dtype_ = pack.getNextAsByte();
        this.class_type_ = pack.getNextAsByte();
        this.class_name_ = this.class_type_ < CLASS_NAMES.length ? CLASS_NAMES[this.class_type_] : "unknown";
        this.color_value_ = pack.getNextAsByte();
        this.color_index_ = this.color_value_ & 0x1F;
        if (this.color_index_ == 31) {
            this.color_index_ = 15;
        }
        this.color_ = COLORS[this.color_index_];
        this.display_index_ = (this.color_value_ & 0x70) << 5;
        this.display_options_ = this.display_index_ < DISPLAY_OPTIONS.length ? DISPLAY_OPTIONS[this.display_index_] : "unknown";
        this.attributes_ = pack.getNextAsByte();
        this.symbol_type_ = pack.getNextAsWord();
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.subclass_ = pack.getNextAsByteArray(18);
        this.latitude_ = pack.getNextAsSemicircleDegrees();
        this.longitude_ = pack.getNextAsSemicircleDegrees();
        this.altitude_ = pack.getNextAsFloat();
        this.depth_ = pack.getNextAsFloat();
        this.distance_ = pack.getNextAsFloat();
        this.state_code_ = pack.getNextAsString(2).trim();
        this.country_code_ = pack.getNextAsString(2).trim();
        this.ete_ = pack.getNextAsLongWord();
        this.identification_ = pack.getNextAsString(51);
        this.comment_ = pack.getNextAsString(51);
        this.facility_ = pack.getNextAsString(31);
        this.city_ = pack.getNextAsString(25);
        this.address_ = pack.getNextAsString(51);
        this.cross_road_ = pack.getNextAsString(51);
    }

    GarminWaypointD109(GPSWaypoint waypoint) {
        this.dtype_ = 1;
        this.class_type_ = 0;
        this.class_name_ = this.class_type_ < CLASS_NAMES.length ? CLASS_NAMES[this.class_type_] : "unknown";
        this.color_value_ = 0;
        this.color_index_ = this.color_value_ & 0x1F;
        if (this.color_index_ == 31) {
            this.color_index_ = 15;
        }
        this.color_ = COLORS[this.color_index_];
        this.display_index_ = (this.color_value_ & 0x70) << 5;
        this.display_options_ = this.display_index_ < DISPLAY_OPTIONS.length ? DISPLAY_OPTIONS[this.display_index_] : "unknown";
        this.attributes_ = (short)96;
        this.symbol_type_ = GarminWaypointSymbols.getSymbolId(waypoint.getSymbolName());
        if (this.symbol_type_ < 0) {
            this.symbol_type_ = 18;
        }
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        for (int i = 0; i < 18; ++i) {
            this.subclass_[i] = i < 6 ? 0 : -1;
        }
        this.latitude_ = waypoint.getLatitude();
        this.longitude_ = waypoint.getLongitude();
        this.altitude_ = waypoint.hasValidAltitude() ? (double)((float)waypoint.getAltitude()) : (double)1.0E25f;
        this.depth_ = 1.0E25f;
        this.distance_ = 0.0f;
        this.state_code_ = "";
        this.country_code_ = "";
        this.ete_ = 0L;
        String tmp = waypoint.getIdentification();
        this.identification_ = tmp == null ? "" : tmp;
        tmp = waypoint.getComment();
        this.comment_ = tmp == null ? "" : tmp;
        this.facility_ = "";
        this.city_ = "";
        this.address_ = "";
        this.cross_road_ = "";
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 52 + Math.min(this.identification_.length() + 1, 51) + Math.min(this.comment_.length() + 1, 51) + Math.min(this.facility_.length() + 1, 31) + Math.min(this.city_.length() + 1, 25) + Math.min(this.address_.length() + 1, 51) + Math.min(this.cross_road_.length() + 1, 51);
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsByte(this.dtype_);
        pack.setNextAsByte(this.class_type_);
        pack.setNextAsByte(this.color_value_);
        pack.setNextAsByte(this.attributes_);
        pack.setNextAsWord(this.symbol_type_);
        pack.setNextAsByteArray(this.subclass_);
        pack.setNextAsSemicircleDegrees(this.latitude_);
        pack.setNextAsSemicircleDegrees(this.longitude_);
        pack.setNextAsFloat((float)this.altitude_);
        pack.setNextAsFloat(this.depth_);
        pack.setNextAsFloat(this.distance_);
        pack.setNextAsString(this.state_code_, 2, false);
        pack.setNextAsString(this.country_code_, 2, false);
        pack.setNextAsLongWord(this.ete_);
        pack.setNextAsString(this.identification_, 51, true);
        pack.setNextAsString(this.comment_, 51, true);
        pack.setNextAsString(this.facility_, 31, true);
        pack.setNextAsString(this.city_, 25, true);
        pack.setNextAsString(this.address_, 51, true);
        pack.setNextAsString(this.cross_road_, 51, true);
        return pack;
    }

    public byte getType() {
        return 109;
    }

    public long getEstimatedTimeEnroute() {
        return this.ete_;
    }
}

