/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.cache.MemoryCacheSet;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.tiff.GeotiffImageReaderSpi;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.NetworkStatus;
import gov.nasa.worldwind.util.TaskService;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.imageio.spi.IIORegistry;

public final class WorldWind {
    public static final String SHUTDOWN_EVENT = "gov.nasa.worldwind.ShutDown";
    private static WorldWind instance = new WorldWind();
    private WWObjectImpl wwo;
    private MemoryCacheSet memoryCacheSet;
    private FileStore dataFileStore;
    private RetrievalService retrievalService;
    private TaskService taskService;
    private NetworkStatus networkStatus;

    private WorldWind() {
        this.initialize();
    }

    private void initialize() {
        this.wwo = new WWObjectImpl();
        this.retrievalService = (RetrievalService)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.RetrievalServiceClassName");
        this.taskService = (TaskService)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TaskServiceClassName");
        this.dataFileStore = (FileStore)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataFileStoreClassName");
        this.memoryCacheSet = (MemoryCacheSet)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.MemoryCacheSetClassName");
        this.networkStatus = (NetworkStatus)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.NetworkStatusClassName");
        IIORegistry.getDefaultInstance().registerServiceProvider(GeotiffImageReaderSpi.inst());
    }

    private void dispose() {
        if (this.taskService != null) {
            this.taskService.shutdown(true);
        }
        if (this.retrievalService != null) {
            this.retrievalService.shutdown(true);
        }
        if (this.memoryCacheSet != null) {
            this.memoryCacheSet.clear();
        }
    }

    public static synchronized void shutDown() {
        WorldWind.instance.wwo.firePropertyChange(SHUTDOWN_EVENT, null, -1);
        instance.dispose();
        instance = new WorldWind();
    }

    public static MemoryCacheSet getMemoryCacheSet() {
        return WorldWind.instance.memoryCacheSet;
    }

    public static synchronized MemoryCache getMemoryCache(String string) {
        return WorldWind.instance.memoryCacheSet.getCache(string);
    }

    public static FileStore getDataFileStore() {
        return WorldWind.instance.dataFileStore;
    }

    public static RetrievalService getRetrievalService() {
        return WorldWind.instance.retrievalService;
    }

    public static TaskService getTaskService() {
        return WorldWind.instance.taskService;
    }

    public static NetworkStatus getNetworkStatus() {
        return WorldWind.instance.networkStatus;
    }

    public static boolean isOfflineMode() {
        return WorldWind.getNetworkStatus().isOfflineMode();
    }

    public static void setOfflineMode(boolean bl) {
        WorldWind.getNetworkStatus().setOfflineMode(bl);
    }

    public static Object createComponent(String string) throws WWRuntimeException {
        if (string == null || string.length() == 0) {
            Logging.logger().severe("nullValue.ClassNameKeyNullZero");
            throw new IllegalArgumentException(Logging.getMessage("nullValue.ClassNameKeyNullZero"));
        }
        try {
            Class<?> clazz = Class.forName(string.trim());
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "WorldWind.ExceptionCreatingComponent", string);
            throw new WWRuntimeException(Logging.getMessage("WorldWind.ExceptionCreatingComponent", string), exception);
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, "WorldWind.ErrorCreatingComponent", string);
            throw new WWRuntimeException(Logging.getMessage("WorldWind.ErrorCreatingComponent", string), throwable);
        }
    }

    public static Object createConfigurationComponent(String string) throws IllegalStateException, IllegalArgumentException {
        if (string == null || string.length() == 0) {
            Logging.logger().severe("nullValue.ClassNameKeyNullZero");
            throw new IllegalArgumentException(Logging.getMessage("nullValue.ClassNameKeyNullZero"));
        }
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            Logging.logger().log(Level.SEVERE, "WorldWind.NoClassNameInConfigurationForKey", string);
            throw new WWRuntimeException(Logging.getMessage("WorldWind.NoClassNameInConfigurationForKey", string));
        }
        try {
            return WorldWind.createComponent(string2.trim());
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, "WorldWind.UnableToCreateClassForConfigurationKey", string2);
            throw new IllegalStateException(Logging.getMessage("WorldWind.UnableToCreateClassForConfigurationKey", string2), throwable);
        }
    }

    public static Object createComponentFromConfigurationFactory(String string, String[] stringArray) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.ClassNameKeyNullZero");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (stringArray == null || stringArray.length == 0) {
            String string3 = Logging.getMessage("nullValue.KeyListIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Factory factory = (Factory)WorldWind.createConfigurationComponent(string);
        return factory.createFromKeys(stringArray);
    }

    public static void setValue(String string, String string2) {
        WorldWind.instance.wwo.setValue(string, string2);
    }

    public static Object getValue(String string) {
        return WorldWind.instance.wwo.getValue(string);
    }

    public static String getStringValue(String string) {
        return WorldWind.instance.wwo.getStringValue(string);
    }

    public static boolean hasKey(String string) {
        return WorldWind.instance.wwo.hasKey(string);
    }

    public static void removeKey(String string) {
        WorldWind.instance.wwo.removeKey(string);
    }

    public static void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        WorldWind.instance.wwo.addPropertyChangeListener(string, propertyChangeListener);
    }

    public static void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        WorldWind.instance.wwo.removePropertyChangeListener(string, propertyChangeListener);
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WorldWind.instance.wwo.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WorldWind.instance.wwo.removePropertyChangeListener(propertyChangeListener);
    }
}

