/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.cache.TextureCache;
import gov.nasa.worldwind.event.InputHandler;
import gov.nasa.worldwind.event.NoOpInputHandler;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingExceptionListener;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldWindowImpl
extends WWObjectImpl
implements WorldWindow {
    private SceneController sceneController;
    private final EventListenerList eventListeners = new EventListenerList();
    private InputHandler inputHandler;
    private TextureCache textureCache;

    public WorldWindowImpl() {
        this.sceneController = (SceneController)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.SceneControllerClassName");
    }

    @Override
    public void shutdown() {
        Object object;
        if (this.inputHandler != null) {
            this.inputHandler.dispose();
            this.inputHandler = new NoOpInputHandler();
        }
        if (this.getTextureCache() != null) {
            this.getTextureCache().clear();
        }
        if (this.getModel() != null && this.getModel().getLayers() != null) {
            object = this.getModel().getLayers().iterator();
            while (object.hasNext()) {
                Layer layer = (Layer)object.next();
                try {
                    layer.dispose();
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLCanvas.ExceptionWhileShuttingDownWorldWindow"), exception);
                }
            }
        }
        if ((object = this.getSceneController()) != null) {
            object.dispose();
        }
    }

    @Override
    public TextureCache getTextureCache() {
        return this.textureCache;
    }

    protected void setTextureCache(TextureCache textureCache) {
        this.textureCache = textureCache;
        this.sceneController.setTextureCache(this.textureCache);
    }

    @Override
    public void setModel(Model model) {
        if (this.sceneController != null) {
            this.sceneController.setModel(model);
        }
    }

    @Override
    public Model getModel() {
        return this.sceneController != null ? this.sceneController.getModel() : null;
    }

    @Override
    public void setView(View view) {
        if (this.sceneController != null) {
            this.sceneController.setView(view);
        }
    }

    @Override
    public View getView() {
        return this.sceneController != null ? this.sceneController.getView() : null;
    }

    @Override
    public void setModelAndView(Model model, View view) {
        this.setModel(model);
        this.setView(view);
    }

    @Override
    public SceneController getSceneController() {
        return this.sceneController;
    }

    @Override
    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    @Override
    public void redraw() {
    }

    @Override
    public void redrawNow() {
    }

    @Override
    public void setPerFrameStatisticsKeys(Set<String> set) {
        if (this.sceneController != null) {
            this.sceneController.setPerFrameStatisticsKeys(set);
        }
    }

    @Override
    public Collection<PerformanceStatistic> getPerFrameStatistics() {
        if (this.sceneController == null || this.sceneController.getPerFrameStatistics() == null) {
            return new ArrayList<PerformanceStatistic>(0);
        }
        return this.sceneController.getPerFrameStatistics();
    }

    @Override
    public PickedObjectList getObjectsAtCurrentPosition() {
        return null;
    }

    @Override
    public Position getCurrentPosition() {
        if (this.sceneController == null) {
            return null;
        }
        PickedObjectList pickedObjectList = this.getSceneController().getPickedObjectList();
        if (pickedObjectList == null || pickedObjectList.size() < 1) {
            return null;
        }
        Position position = null;
        PickedObject pickedObject = pickedObjectList.getTopPickedObject();
        if (pickedObject != null && pickedObject.hasPosition()) {
            position = pickedObject.getPosition();
        } else if (pickedObjectList.getTerrainObject() != null) {
            position = pickedObjectList.getTerrainObject().getPosition();
        }
        return position;
    }

    protected PickedObject getCurrentSelection() {
        if (this.sceneController == null) {
            return null;
        }
        PickedObjectList pickedObjectList = this.getSceneController().getPickedObjectList();
        if (pickedObjectList == null || pickedObjectList.size() < 1) {
            return null;
        }
        PickedObject pickedObject = pickedObjectList.getTopPickedObject();
        return pickedObject.isTerrain() ? null : pickedObject;
    }

    @Override
    public void addRenderingListener(RenderingListener renderingListener) {
        this.eventListeners.add(RenderingListener.class, renderingListener);
    }

    @Override
    public void removeRenderingListener(RenderingListener renderingListener) {
        this.eventListeners.remove(RenderingListener.class, renderingListener);
    }

    protected void callRenderingListeners(RenderingEvent renderingEvent) {
        for (RenderingListener renderingListener : (RenderingListener[])this.eventListeners.getListeners(RenderingListener.class)) {
            renderingListener.stageChanged(renderingEvent);
        }
    }

    @Override
    public void addPositionListener(PositionListener positionListener) {
        this.eventListeners.add(PositionListener.class, positionListener);
    }

    @Override
    public void removePositionListener(PositionListener positionListener) {
        this.eventListeners.remove(PositionListener.class, positionListener);
    }

    protected void callPositionListeners(final PositionEvent positionEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                for (PositionListener positionListener : (PositionListener[])WorldWindowImpl.this.eventListeners.getListeners(PositionListener.class)) {
                    positionListener.moved(positionEvent);
                }
            }
        });
    }

    @Override
    public void addSelectListener(SelectListener selectListener) {
        this.eventListeners.add(SelectListener.class, selectListener);
    }

    @Override
    public void removeSelectListener(SelectListener selectListener) {
        this.eventListeners.remove(SelectListener.class, selectListener);
    }

    protected void callSelectListeners(final SelectEvent selectEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                for (SelectListener selectListener : (SelectListener[])WorldWindowImpl.this.eventListeners.getListeners(SelectListener.class)) {
                    selectListener.selected(selectEvent);
                }
            }
        });
    }

    @Override
    public void addRenderingExceptionListener(RenderingExceptionListener renderingExceptionListener) {
        this.eventListeners.add(RenderingExceptionListener.class, renderingExceptionListener);
    }

    @Override
    public void removeRenderingExceptionListener(RenderingExceptionListener renderingExceptionListener) {
        this.eventListeners.remove(RenderingExceptionListener.class, renderingExceptionListener);
    }

    protected void callRenderingExceptionListeners(final Throwable throwable) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                for (RenderingExceptionListener renderingExceptionListener : (RenderingExceptionListener[])WorldWindowImpl.this.eventListeners.getListeners(RenderingExceptionListener.class)) {
                    renderingExceptionListener.exceptionThrown(throwable);
                }
            }
        });
    }
}

