/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;

public class KeyEventState
implements KeyListener {
    private Map<Object, InputState> keyStateMap = new HashMap<Object, InputState>();
    private int modifiers;
    private int modifiersEx;

    public boolean isKeyDown(int n) {
        InputState inputState = this.getKeyState(n);
        return inputState != null && inputState.getEventType() == 401;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getModifiersEx() {
        return this.modifiersEx;
    }

    public void clearKeyState() {
        this.keyStateMap.clear();
        this.modifiers = 0;
        this.modifiersEx = 0;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.onKeyEvent(keyEvent, 401);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.onKeyEvent(keyEvent, 402);
    }

    protected void onKeyEvent(KeyEvent keyEvent, int n) {
        if (keyEvent == null) {
            return;
        }
        long l = this.getTimeStamp(keyEvent, n, this.keyStateMap.get(keyEvent.getKeyCode()));
        this.setKeyState(keyEvent.getKeyCode(), new InputState(n, keyEvent.getKeyCode(), l));
        this.setModifiers(keyEvent.getModifiers());
        this.setModifiersEx(keyEvent.getModifiersEx());
    }

    protected InputState getKeyState(int n) {
        return this.keyStateMap.get(n);
    }

    protected void setKeyState(int n, InputState inputState) {
        this.keyStateMap.put(n, inputState);
    }

    protected void setModifiers(int n) {
        this.modifiers = n;
    }

    protected void setModifiersEx(int n) {
        this.modifiersEx = n;
    }

    protected long getTimeStamp(InputEvent inputEvent, int n, InputState inputState) {
        if (inputState != null && inputState.getEventType() == n) {
            return inputState.getTimestamp();
        }
        return inputEvent.getWhen();
    }

    protected static class InputState {
        private int eventType;
        private int keyOrButtonCode;
        private long timestamp;

        public InputState(int n, int n2, long l) {
            this.eventType = n;
            this.keyOrButtonCode = n2;
            this.timestamp = l;
        }

        public int getEventType() {
            return this.eventType;
        }

        public int getKeyOrButtonCode() {
            return this.keyOrButtonCode;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

