/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.util.Logging;
import java.util.HashMap;
import java.util.Map;

public class ViewInputAttributes {
    public static final String VIEW_FOCUS = "gov.nasa.worldwind.ViewFocus";
    public static final String VIEW_FOCUS_SLOW = "gov.nasa.worldwind.ViewFocusSlow";
    public static final String VIEW_PAN = "gov.nasa.worldwind.ViewPan";
    public static final String VIEW_PAN_SLOW = "gov.nasa.worldwind.ViewPanSlow";
    public static final String VIEW_ROTATE = "gov.nasa.worldwind.ViewRotate";
    public static final String VIEW_ROTATE_SLOW = "gov.nasa.worldwind.ViewRotateSlow";
    public static final String VIEW_ZOOM = "gov.nasa.worldwind.ViewZoom";
    public static final String VIEW_ZOOM_SLOW = "gov.nasa.worldwind.ViewZoomSlow";
    public static final String DEVICE_KEYBOARD = "gov.nasa.worldwind.DeviceKeyboard";
    public static final String DEVICE_MOUSE = "gov.nasa.worldwind.DeviceMouse";
    public static final String DEVICE_MOUSE_WHEEL = "gov.nasa.worldwind.DeviceMouseWheel";
    private static final double DEFAULT_KEY_SENSITIVITY = 1.0;
    private static final double DEFAULT_MOUSE_SENSITIVITY = 1.0;
    private static final double DEFAULT_MOUSE_WHEEL_SENSITIVITY = 1.0;
    private static final double DEFAULT_SLOW_VALUE = 0.25;
    private static final boolean DEFAULT_FOCUS_SMOOTHING_ENABLED = true;
    private static final boolean DEFAULT_PAN_SMOOTHING_ENABLED = true;
    private static final boolean DEFAULT_ROTATE_SMOOTHING_ENABLED = true;
    private static final boolean DEFAULT_ZOOM_SMOOTHING_ENABLED = true;
    private static final double DEFAULT_FOCUS_SMOOTHING_VALUE = 0.0;
    private static final double DEFAULT_PAN_SMOOTHING_VALUE = 0.4;
    private static final double DEFAULT_ROTATE_SMOOTHING_VALUE = 0.7;
    private static final double DEFAULT_ZOOM_SMOOTHING_VALUE = 0.85;
    private static final double DEFAULT_KEY_PAN_MIN_VALUE = 5.0E-6;
    private static final double DEFAULT_KEY_PAN_MAX_VALUE = 4.0;
    private static final double DEFAULT_KEY_ROTATE_MIN_VALUE = 2.0;
    private static final double DEFAULT_KEY_ROTATE_MAX_VALUE = 2.2;
    private static final double DEFAULT_KEY_ZOOM_VALUE = 0.06;
    private static final double DEFAULT_MOUSE_FOCUS_MIN_VALUE = 0.95;
    private static final double DEFAULT_MOUSE_FOCUS_MAX_VALUE = 0.9;
    private static final double DEFAULT_MOUSE_PAN_MIN_VALUE = 1.0E-5;
    private static final double DEFAULT_MOUSE_PAN_MAX_VALUE = 0.2;
    private static final double DEFAULT_MOUSE_ROTATE_MIN_VALUE = 0.14;
    private static final double DEFAULT_MOUSE_ROTATE_MAX_VALUE = 0.18;
    private static final double DEFAULT_MOUSE_ZOOM_VALUE = 0.003;
    private static final double DEFAULT_MOUSE_WHEEL_ZOOM_VALUE = 0.1;
    private static final double DEFAULT_MOUSE_WHEEL_ZOOM_VALUE_OSX = 0.01;
    private Map<Object, DeviceAttributes> deviceMap = new HashMap<Object, DeviceAttributes>();
    private Map<Object, ActionAttributesMap> deviceActionMap = new HashMap<Object, ActionAttributesMap>();

    public ViewInputAttributes() {
        this.setDefaultDeviceAttributes();
        this.setDefaultActionAttributes();
    }

    public DeviceAttributes getDeviceAttributes(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.deviceMap.get(object);
    }

    public void setDeviceAttributes(Object object, DeviceAttributes deviceAttributes) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (deviceAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.deviceMap.put(object, deviceAttributes);
    }

    public ActionAttributesMap getActionMap(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.deviceActionMap.get(object);
    }

    public void setActionMap(Object object, ActionAttributesMap actionAttributesMap) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (actionAttributesMap == null) {
            String string = Logging.getMessage("nullValue.MapIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.deviceActionMap.put(object, actionAttributesMap);
    }

    public ActionAttributes getActionAttributes(Object object, Object object2) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object2 == null) {
            String string = Logging.getMessage("nullValue.ActionKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ActionAttributesMap actionAttributesMap = this.getActionMap(object);
        if (actionAttributesMap == null) {
            return null;
        }
        return actionAttributesMap.getActionAttributes(object2);
    }

    protected void setDefaultDeviceAttributes() {
        this.setDeviceAttributes(DEVICE_KEYBOARD, new DeviceAttributes(1.0));
        this.setDeviceAttributes(DEVICE_MOUSE, new DeviceAttributes(1.0));
        this.setDeviceAttributes(DEVICE_MOUSE_WHEEL, new DeviceAttributes(1.0));
    }

    protected void setDefaultActionAttributes() {
        ActionAttributesMap actionAttributesMap = new ActionAttributesMap();
        actionAttributesMap.setActionAttributes(VIEW_PAN, new ActionAttributes(5.0E-6, 4.0, true, 0.4));
        actionAttributesMap.setActionAttributes(VIEW_ROTATE, new ActionAttributes(2.0, 2.2, true, 0.7));
        actionAttributesMap.setActionAttributes(VIEW_ZOOM, new ActionAttributes(0.06, 0.06, true, 0.85));
        this.setSlowActionAttributes(actionAttributesMap, 0.25);
        this.setActionMap(DEVICE_KEYBOARD, actionAttributesMap);
        actionAttributesMap = new ActionAttributesMap();
        actionAttributesMap.setActionAttributes(VIEW_FOCUS, new ActionAttributes(0.95, 0.9, true, 0.0));
        actionAttributesMap.setActionAttributes(VIEW_PAN, new ActionAttributes(1.0E-5, 0.2, true, 0.4));
        actionAttributesMap.setActionAttributes(VIEW_ROTATE, new ActionAttributes(0.14, 0.18, true, 0.7));
        actionAttributesMap.setActionAttributes(VIEW_ZOOM, new ActionAttributes(0.003, 0.003, true, 0.85));
        this.setSlowActionAttributes(actionAttributesMap, 0.25);
        this.setActionMap(DEVICE_MOUSE, actionAttributesMap);
        actionAttributesMap = new ActionAttributesMap();
        if (Configuration.isMacOS()) {
            actionAttributesMap.setActionAttributes(VIEW_ZOOM, new ActionAttributes(0.01, 0.01, true, 0.85));
            this.setSlowActionAttributes(actionAttributesMap, 0.25);
        } else {
            actionAttributesMap.setActionAttributes(VIEW_ZOOM, new ActionAttributes(0.1, 0.1, true, 0.85));
            this.setSlowActionAttributes(actionAttributesMap, 0.25);
        }
        this.setActionMap(DEVICE_MOUSE_WHEEL, actionAttributesMap);
    }

    protected void setSlowActionAttributes(ActionAttributesMap actionAttributesMap, double d) {
        ActionAttributes actionAttributes = actionAttributesMap.getActionAttributes(VIEW_FOCUS);
        if (actionAttributes != null) {
            actionAttributesMap.setActionAttributes(VIEW_FOCUS_SLOW, this.makeSlowActionAttributes(actionAttributes, d));
        }
        if ((actionAttributes = actionAttributesMap.getActionAttributes(VIEW_PAN)) != null) {
            actionAttributesMap.setActionAttributes(VIEW_PAN_SLOW, this.makeSlowActionAttributes(actionAttributes, d));
        }
        if ((actionAttributes = actionAttributesMap.getActionAttributes(VIEW_ROTATE)) != null) {
            actionAttributesMap.setActionAttributes(VIEW_ROTATE_SLOW, this.makeSlowActionAttributes(actionAttributes, d));
        }
        if ((actionAttributes = actionAttributesMap.getActionAttributes(VIEW_ZOOM)) != null) {
            actionAttributesMap.setActionAttributes(VIEW_ZOOM_SLOW, this.makeSlowActionAttributes(actionAttributes, d));
        }
    }

    protected ActionAttributes makeSlowActionAttributes(ActionAttributes actionAttributes, double d) {
        ActionAttributes actionAttributes2 = new ActionAttributes(actionAttributes);
        double[] dArray = actionAttributes.getValues();
        actionAttributes2.setValues(dArray[0] * d, dArray[1] * d);
        return actionAttributes2;
    }

    public static class ActionAttributesMap {
        private Map<Object, ActionAttributes> actionMap = new HashMap<Object, ActionAttributes>();

        public ActionAttributes getActionAttributes(Object object) {
            if (object == null) {
                String string = Logging.getMessage("nullValue.ActionKeyIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.actionMap.get(object);
        }

        public void setActionAttributes(Object object, ActionAttributes actionAttributes) {
            if (object == null) {
                String string = Logging.getMessage("nullValue.ActionKeyIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (actionAttributes == null) {
                String string = Logging.getMessage("nullValue.AttributesIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.actionMap.put(object, actionAttributes);
        }
    }

    public static class DeviceAttributes {
        private double sensitivity;

        public DeviceAttributes(double d) {
            this.setSensitivity(d);
        }

        public DeviceAttributes(DeviceAttributes deviceAttributes) {
            if (deviceAttributes == null) {
                String string = Logging.getMessage("nullValue.AttributesIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.sensitivity = deviceAttributes.sensitivity;
        }

        public double getSensitivity() {
            return this.sensitivity;
        }

        public void setSensitivity(double d) {
            if (d <= 0.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "sensitivity <= 0");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.sensitivity = d;
        }
    }

    public static class ActionAttributes {
        private double minValue;
        private double maxValue;
        private boolean enableSmoothing;
        private double smoothingValue;

        public ActionAttributes(double d, double d2, boolean bl, double d3) {
            this.setValues(d, d2);
            this.setEnableSmoothing(bl);
            this.setSmoothingValue(d3);
        }

        public ActionAttributes(ActionAttributes actionAttributes) {
            if (actionAttributes == null) {
                String string = Logging.getMessage("nullValue.AttributesIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.minValue = actionAttributes.minValue;
            this.maxValue = actionAttributes.maxValue;
            this.smoothingValue = actionAttributes.smoothingValue;
        }

        public double[] getValues() {
            return new double[]{this.minValue, this.maxValue};
        }

        public void setValues(double d, double d2) {
            if (d <= 0.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "minValue <= 0");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (d2 <= 0.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "maxValue <= 0");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.minValue = d;
            this.maxValue = d2;
        }

        public void setValue(double d) {
            this.setValues(d, d);
        }

        public boolean isEnableSmoothing() {
            return this.enableSmoothing;
        }

        public void setEnableSmoothing(boolean bl) {
            this.enableSmoothing = bl;
        }

        public double getSmoothingValue() {
            return this.smoothingValue;
        }

        public void setSmoothingValue(double d) {
            if (d < 0.0 || d >= 1.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "smoothingValue < 0 || smoothingValue >= 1");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.smoothingValue = d;
        }
    }
}

