/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.KeyEventState;
import gov.nasa.worldwind.awt.OrbitViewInputSupport;
import gov.nasa.worldwind.awt.ViewInputAttributes;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.BasicOrbitViewLimits;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.ScheduledOrbitViewStateIterator;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ViewInputHandler
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
FocusListener,
RenderingListener,
PropertyChangeListener {
    private WorldWindow wwd;
    private ViewInputAttributes attributes;
    private boolean enableSmoothing = true;
    private boolean lockHeading = true;
    private boolean stopOnFocusLost = true;
    private Position selectedPosition;
    private boolean wwdFocusOwner;
    private Point lastMousePoint;
    private Point mousePoint;
    private KeyEventState keyEventState = new KeyEventState();
    private OrbitViewInputSupport orbitViewInputSupport = new OrbitViewInputSupport();
    private double dragSlopeFactor = 0.002;
    private long lastPerFrameInputTime;
    private static final double DEFAULT_DRAG_SLOPE_FACTOR = 0.002;
    private static final long DEFAULT_PER_FRAME_INPUT_DELAY = 35L;
    protected static final String GENERATE_EVENTS = "GenerateEvents";
    protected static final String QUERY_EVENTS = "QueryEvents";
    protected static final String SCALE_FUNC_EYE_ALTITUDE = "ScaleFuncEyeAltitude";
    protected static final String SCALE_FUNC_EYE_ALTITUDE_EXP = "ScaleFuncEyeAltitudeExp";
    protected static final String SCALE_FUNC_ZOOM = "ScaleFuncZoom";
    protected static final String SCALE_FUNC_ZOOM_EXP = "ScaleFuncZoomExp";

    public ViewInputHandler() {
        this.attributes = new ViewInputAttributes();
    }

    public WorldWindow getWorldWindow() {
        return this.wwd;
    }

    public void setWorldWindow(WorldWindow worldWindow) {
        if (worldWindow == this.wwd) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.removeRenderingListener(this);
            this.wwd.getSceneController().removePropertyChangeListener(this);
        }
        this.wwd = worldWindow;
        if (this.wwd != null) {
            this.wwd.addRenderingListener(this);
            this.wwd.getSceneController().addPropertyChangeListener(this);
        }
    }

    public ViewInputAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ViewInputAttributes viewInputAttributes) {
        if (viewInputAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = viewInputAttributes;
    }

    public boolean isEnableSmoothing() {
        return this.enableSmoothing;
    }

    public void setEnableSmoothing(boolean bl) {
        this.enableSmoothing = bl;
    }

    public boolean isLockHeading() {
        return this.lockHeading;
    }

    public void setLockHeading(boolean bl) {
        this.lockHeading = bl;
    }

    public boolean isStopOnFocusLost() {
        return this.stopOnFocusLost;
    }

    public void setStopOnFocusLost(boolean bl) {
        this.stopOnFocusLost = bl;
    }

    public double getDragSlopeFactor() {
        return this.dragSlopeFactor;
    }

    public void setDragSlopeFactor(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "factor < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dragSlopeFactor = d;
    }

    protected View getView() {
        return this.wwd != null ? this.wwd.getView() : null;
    }

    protected boolean isWorldWindowFocusOwner() {
        return this.wwdFocusOwner;
    }

    protected void setWorldWindowFocusOwner(boolean bl) {
        this.wwdFocusOwner = bl;
    }

    protected Point getMousePoint() {
        return this.mousePoint;
    }

    protected Point getLastMousePoint() {
        return this.lastMousePoint;
    }

    protected void updateMousePoint(MouseEvent mouseEvent) {
        this.lastMousePoint = this.mousePoint;
        this.mousePoint = new Point(mouseEvent.getPoint());
    }

    protected Position getSelectedPosition() {
        return this.selectedPosition;
    }

    protected void setSelectedPosition(Position position) {
        this.selectedPosition = position;
    }

    protected Position computeSelectedPosition() {
        PickedObject pickedObject;
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        if (pickedObjectList != null && (pickedObject = pickedObjectList.getTopPickedObject()) != null && pickedObject.isTerrain()) {
            return pickedObject.getPosition();
        }
        return null;
    }

    protected void onFocusView(Position position, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof OrbitView) {
            if (view.hasStateIterator()) {
                view.stopStateIterators();
            }
            double[] dArray = actionAttributes.getValues();
            double d = this.getScaledValue(dArray[0], dArray[1], SCALE_FUNC_ZOOM);
            if (!actionAttributes.isEnableSmoothing()) {
                d = 0.0;
            }
            this.orbitViewInputSupport.setCenterTarget((OrbitView)view, null);
            this.orbitViewInputSupport.setCenterSmoothing(d);
            this.orbitViewInputSupport.setCenterTarget((OrbitView)view, position);
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    protected void onPanViewAbsolute(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (angle.equals(Angle.ZERO) && angle2.equals(Angle.ZERO)) {
            return;
        }
        if (view instanceof OrbitView) {
            Position position = ((OrbitView)view).getCenterPosition().add(new Position(angle, angle2, 0.0));
            this.setCenterPosition((OrbitView)view, position, actionAttributes);
        }
    }

    protected void onPanViewRelative(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (angle.equals(Angle.ZERO) && angle2.equals(Angle.ZERO)) {
            return;
        }
        if (view instanceof OrbitView) {
            double d = ((OrbitView)view).getHeading().sin();
            double d2 = ((OrbitView)view).getHeading().cos();
            double d3 = d2 * angle.getDegrees() - d * angle2.getDegrees();
            double d4 = d * angle.getDegrees() + d2 * angle2.getDegrees();
            Position position = ((OrbitView)view).getCenterPosition().add(Position.fromDegrees(d3, d4, 0.0));
            this.setCenterPosition((OrbitView)view, position, actionAttributes);
        }
    }

    protected void onResetHeading() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof OrbitView) {
            Angle angle = BasicOrbitViewLimits.limitHeading(Angle.ZERO, ((OrbitView)view).getOrbitViewLimits());
            view.applyStateIterator(ScheduledOrbitViewStateIterator.createHeadingIterator(((OrbitView)view).getHeading(), angle));
        }
    }

    protected void onResetHeadingAndPitch() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof OrbitView) {
            Angle angle = BasicOrbitViewLimits.limitHeading(Angle.ZERO, ((OrbitView)view).getOrbitViewLimits());
            Angle angle2 = BasicOrbitViewLimits.limitPitch(Angle.ZERO, ((OrbitView)view).getOrbitViewLimits());
            view.applyStateIterator(ScheduledOrbitViewStateIterator.createHeadingPitchIterator(((OrbitView)view).getHeading(), angle, ((OrbitView)view).getPitch(), angle2));
        }
    }

    protected void onRotateView(Angle angle, Angle angle2, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof OrbitView) {
            if (!angle.equals(Angle.ZERO)) {
                this.changeHeading((OrbitView)view, angle, actionAttributes);
            }
            if (!angle2.equals(Angle.ZERO)) {
                this.changePitch((OrbitView)view, angle2, actionAttributes);
            }
        }
    }

    protected void onStopView() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        view.stopMovement();
    }

    protected void onZoomView(double d, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        if (view instanceof OrbitView) {
            this.changeZoom((OrbitView)view, d, actionAttributes);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyEventState.keyTyped(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyEventState.keyPressed(keyEvent);
        this.handleKeyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyEventState.keyReleased(keyEvent);
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        View view;
        if (keyEvent.getKeyCode() == 78) {
            this.onResetHeading();
        } else if (keyEvent.getKeyCode() == 82) {
            this.onResetHeadingAndPitch();
        } else if (keyEvent.getKeyCode() == 32) {
            this.onStopView();
        } else if (this.handlePerFrameKeyState(this.keyEventState, QUERY_EVENTS) && (view = this.getView()) != null) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.handleMouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
        this.setSelectedPosition(this.computeSelectedPosition());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
        this.setSelectedPosition(null);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
    }

    protected void handleMouseClicked(MouseEvent mouseEvent) {
        if (1 == mouseEvent.getButton()) {
            this.handleMouseFocus(mouseEvent);
        }
    }

    protected void handleMouseFocus(MouseEvent mouseEvent) {
        Position position = this.computeSelectedPosition();
        if (position == null) {
            return;
        }
        ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewFocus");
        this.onFocusView(position, actionAttributes);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
        this.handleMouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
    }

    protected void handleMouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiersEx() & 0x180) != 0 || (mouseEvent.getModifiersEx() & 0x1000) != 0) {
            if ((mouseEvent.getModifiersEx() & 0x1400) != 0) {
                this.handleMouseRotate(mouseEvent);
            }
        } else if ((mouseEvent.getModifiersEx() & 0x800) != 0) {
            this.handleMouseZoom(mouseEvent);
        } else if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
            this.handleMousePan(mouseEvent);
        }
    }

    protected void handleMousePan(MouseEvent mouseEvent) {
        Point point = ViewInputHandler.constrainToSourceBounds(this.getMousePoint(), this.wwd);
        Point point2 = ViewInputHandler.constrainToSourceBounds(this.getLastMousePoint(), this.wwd);
        if (point == null || point2 == null) {
            return;
        }
        if (this.getSelectedPosition() == null) {
            this.setSelectedPosition(this.computeSelectedPosition());
        } else if (this.computeSelectedPosition() == null) {
            this.setSelectedPosition(null);
        } else if (this.computeSelectedPointAt(point) == null || this.computeSelectedPointAt(point2) == null) {
            this.setSelectedPosition(null);
        }
        Vec4 vec4 = this.computeSelectedPointAt(point);
        Vec4 vec42 = this.computeSelectedPointAt(point2);
        if (vec4 != null && vec42 != null) {
            ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewPan");
            LatLon latLon = this.getChangeInLocation(point2, point, vec42, vec4);
            this.onPanViewAbsolute(latLon.getLatitude(), latLon.getLongitude(), actionAttributes);
        } else {
            Point point3 = ViewInputHandler.subtract(point, point2);
            int n = point3.y;
            int n2 = -point3.x;
            ViewInputAttributes.DeviceAttributes deviceAttributes = this.attributes.getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
            ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewPan");
            Angle angle = Angle.fromDegrees(this.rawInputToChangeInValue(n, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM));
            Angle angle2 = Angle.fromDegrees(this.rawInputToChangeInValue(n2, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM));
            this.onPanViewRelative(angle, angle2, actionAttributes);
        }
    }

    protected void handleMouseRotate(MouseEvent mouseEvent) {
        Point point = ViewInputHandler.constrainToSourceBounds(this.getMousePoint(), this.wwd);
        Point point2 = ViewInputHandler.constrainToSourceBounds(this.getLastMousePoint(), this.wwd);
        if (point == null || point2 == null) {
            return;
        }
        Point point3 = ViewInputHandler.subtract(point, point2);
        int n = point3.x;
        int n2 = point3.y;
        if (this.wwd instanceof Component && this.getMousePoint().y < ((Component)((Object)this.wwd)).getHeight() / 2) {
            n = -n;
        }
        ViewInputAttributes.DeviceAttributes deviceAttributes = this.attributes.getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
        ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewRotate");
        Angle angle = Angle.fromDegrees(this.rawInputToChangeInValue(n, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM));
        Angle angle2 = Angle.fromDegrees(this.rawInputToChangeInValue(n2, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM));
        this.onRotateView(angle, angle2, actionAttributes);
    }

    protected void handleMouseZoom(MouseEvent mouseEvent) {
        Point point = ViewInputHandler.constrainToSourceBounds(this.getMousePoint(), this.wwd);
        Point point2 = ViewInputHandler.constrainToSourceBounds(this.getLastMousePoint(), this.wwd);
        if (point == null || point2 == null) {
            return;
        }
        Point point3 = ViewInputHandler.subtract(point, point2);
        int n = point3.y;
        ViewInputAttributes.DeviceAttributes deviceAttributes = this.attributes.getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
        ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceMouse", "gov.nasa.worldwind.ViewZoom");
        double d = this.rawInputToChangeInValue(n, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM);
        this.onZoomView(d, actionAttributes);
    }

    protected Vec4 computeSelectedPointAt(Point point) {
        if (this.getSelectedPosition() == null) {
            return null;
        }
        View view = this.getView();
        if (view == null) {
            return null;
        }
        double d = this.getSelectedPosition().getElevation();
        if (view.getEyePosition().getElevation() <= d) {
            return null;
        }
        Line line = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Intersection[] intersectionArray = this.wwd.getModel().getGlobe().intersect(line, d);
        if (intersectionArray == null || intersectionArray.length == 0) {
            return null;
        }
        return this.nearestIntersectionPoint(line, intersectionArray);
    }

    protected Vec4 nearestIntersectionPoint(Line line, Intersection[] intersectionArray) {
        Vec4 vec4 = null;
        double d = Double.MAX_VALUE;
        for (Intersection intersection : intersectionArray) {
            double d2;
            if (this.isPointBehindLineOrigin(line, intersection.getIntersectionPoint()) || !((d2 = intersection.getIntersectionPoint().distanceTo3(line.getOrigin())) < d)) continue;
            vec4 = intersection.getIntersectionPoint();
            d = d2;
        }
        return vec4;
    }

    public boolean isPointBehindLineOrigin(Line line, Vec4 vec4) {
        double d = vec4.subtract3(line.getOrigin()).dot3(line.getDirection());
        return d < 0.0;
    }

    protected LatLon getChangeInLocation(Point point, Point point2, Vec4 vec4, Vec4 vec42) {
        double d = this.computeDragSlope(point, point2, vec4, vec42);
        double d2 = this.getDragSlopeFactor();
        double d3 = 1.0 / (1.0 + d2 * d * d);
        Position position = this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
        Angle angle = LatLon.greatCircleAzimuth(position, position2);
        Angle angle2 = LatLon.greatCircleDistance(position, position2);
        Angle angle3 = Angle.fromDegrees(angle2.getDegrees() * d3);
        LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, angle, angle3);
        return position.subtract(latLon);
    }

    protected double computeDragSlope(Point point, Point point2, Vec4 vec4, Vec4 vec42) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        double d = point2.getX() - point.getX();
        double d2 = point2.getY() - point.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = view.getEyePoint().distanceTo3(vec4);
        double d5 = view.computePixelSizeAtDistance(d4);
        double d6 = vec4.distanceTo3(vec42) / (d3 * d5);
        if (d6 < 1.0) {
            d6 = 1.0;
        }
        return d6 - 1.0;
    }

    protected static Point constrainToSourceBounds(Point point, Object object) {
        int n;
        if (point == null) {
            return null;
        }
        if (!(object instanceof Component)) {
            return point;
        }
        Component component = (Component)object;
        int n2 = (int)point.getX();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > component.getWidth()) {
            n2 = component.getWidth();
        }
        if ((n = (int)point.getY()) < 0) {
            n = 0;
        }
        if (n > component.getHeight()) {
            n = component.getHeight();
        }
        return new Point(n2, n);
    }

    protected static Point subtract(Point point, Point point2) {
        if (point == null || point2 == null) {
            return null;
        }
        return new Point((int)(point.getX() - point2.getX()), (int)(point.getY() - point2.getY()));
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseWheelEvent == null) {
            return;
        }
        this.handleMouseWheelMoved(mouseWheelEvent);
    }

    protected void handleMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.handleMouseWheelZoom(mouseWheelEvent);
    }

    protected void handleMouseWheelZoom(MouseWheelEvent mouseWheelEvent) {
        double d = mouseWheelEvent.getWheelRotation();
        ViewInputAttributes.DeviceAttributes deviceAttributes = this.attributes.getDeviceAttributes("gov.nasa.worldwind.DeviceMouseWheel");
        ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceMouseWheel", "gov.nasa.worldwind.ViewZoom");
        double d2 = this.rawInputToChangeInValue(d, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM);
        this.onZoomView(d2, actionAttributes);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.setWorldWindowFocusOwner(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.setWorldWindowFocusOwner(false);
        if (this.isStopOnFocusLost()) {
            this.onStopView();
        }
        this.keyEventState.clearKeyState();
    }

    public void stageChanged(RenderingEvent renderingEvent) {
        if (this.wwd == null) {
            return;
        }
        if (renderingEvent == null) {
            return;
        }
        if ("gov.nasa.worldwind.RenderingEvent.BeforeRendering" == renderingEvent.getStage()) {
            this.handleBeforeRendering(renderingEvent);
        }
    }

    protected void handleBeforeRendering(RenderingEvent renderingEvent) {
        this.handlePerFrameInput();
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (view instanceof OrbitView) {
            if (view.hasStateIterator()) {
                this.orbitViewInputSupport.clearTargets();
            }
            if (this.orbitViewInputSupport.hasTargets()) {
                this.orbitViewInputSupport.moveViewTowardTargets((OrbitView)view);
            }
        }
    }

    protected void handlePerFrameInput() {
        View view;
        if (!this.isWorldWindowFocusOwner()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastPerFrameInputTime > 35L) {
            this.handlePerFrameKeyState(this.keyEventState, GENERATE_EVENTS);
            this.lastPerFrameInputTime = l;
        } else if (this.handlePerFrameKeyState(this.keyEventState, QUERY_EVENTS) && (view = this.getView()) != null) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    protected boolean handlePerFrameKeyState(KeyEventState keyEventState, String string) {
        boolean bl;
        if ((keyEventState.getModifiersEx() & 0x40) != 0) {
            bl = this.handleKeyRotate(keyEventState, string);
        } else if ((keyEventState.getModifiersEx() & 0x180) != 0) {
            bl = this.handleKeyZoom(keyEventState, string);
        } else {
            bl = this.handleKeyRotate(keyEventState, string);
            if (!bl && !(bl = this.handleKeyZoom(keyEventState, string))) {
                bl = this.handleKeyPan(keyEventState, string);
            }
        }
        return bl;
    }

    protected boolean handleKeyPan(KeyEventState keyEventState, String string) {
        double d = 0.0;
        double d2 = 0.0;
        if (keyEventState.isKeyDown(37)) {
            d2 += -1.0;
        }
        if (keyEventState.isKeyDown(39)) {
            d2 += 1.0;
        }
        if (keyEventState.isKeyDown(38)) {
            d += 1.0;
        }
        if (keyEventState.isKeyDown(40)) {
            d += -1.0;
        }
        if (d == 0.0 && d2 == 0.0) {
            return false;
        }
        if (string == GENERATE_EVENTS) {
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (d3 > 0.0) {
                d /= d3;
                d2 /= d3;
            }
            boolean bl = (keyEventState.getModifiersEx() & 0x200) != 0;
            ViewInputAttributes.DeviceAttributes deviceAttributes = this.attributes.getDeviceAttributes("gov.nasa.worldwind.DeviceKeyboard");
            ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceKeyboard", bl ? "gov.nasa.worldwind.ViewPanSlow" : "gov.nasa.worldwind.ViewPan");
            Angle angle = Angle.fromDegrees(this.rawInputToChangeInValue(d, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM_EXP));
            Angle angle2 = Angle.fromDegrees(this.rawInputToChangeInValue(d2, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM_EXP));
            this.onPanViewRelative(angle, angle2, actionAttributes);
        }
        return true;
    }

    protected boolean handleKeyRotate(KeyEventState keyEventState, String string) {
        double d = 0.0;
        double d2 = 0.0;
        if ((keyEventState.getModifiersEx() & 0x40) != 0) {
            if (keyEventState.isKeyDown(37)) {
                d += -1.0;
            }
            if (keyEventState.isKeyDown(39)) {
                d += 1.0;
            }
            if (keyEventState.isKeyDown(38)) {
                d2 += -1.0;
            }
            if (keyEventState.isKeyDown(40)) {
                d2 += 1.0;
            }
        } else {
            if (keyEventState.isKeyDown(34)) {
                d2 += 1.0;
            }
            if (keyEventState.isKeyDown(33)) {
                d2 += -1.0;
            }
        }
        if (d == 0.0 && d2 == 0.0) {
            return false;
        }
        if (string == GENERATE_EVENTS) {
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (d3 > 0.0) {
                d /= d3;
                d2 /= d3;
            }
            boolean bl = (keyEventState.getModifiersEx() & 0x200) != 0;
            ViewInputAttributes.DeviceAttributes deviceAttributes = this.attributes.getDeviceAttributes("gov.nasa.worldwind.DeviceKeyboard");
            ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceKeyboard", bl ? "gov.nasa.worldwind.ViewRotateSlow" : "gov.nasa.worldwind.ViewRotate");
            Angle angle = Angle.fromDegrees(this.rawInputToChangeInValue(d, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM));
            Angle angle2 = Angle.fromDegrees(this.rawInputToChangeInValue(d2, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM));
            this.onRotateView(angle, angle2, actionAttributes);
        }
        return true;
    }

    protected boolean handleKeyZoom(KeyEventState keyEventState, String string) {
        double d = 0.0;
        if ((keyEventState.getModifiersEx() & 0x180) != 0) {
            if (keyEventState.isKeyDown(38)) {
                d += -1.0;
            }
            if (keyEventState.isKeyDown(40)) {
                d += 1.0;
            }
        } else {
            if (keyEventState.isKeyDown(107) || keyEventState.isKeyDown(61)) {
                d += -1.0;
            }
            if (keyEventState.isKeyDown(109) || keyEventState.isKeyDown(45)) {
                d += 1.0;
            }
        }
        if (d == 0.0) {
            return false;
        }
        if (string == GENERATE_EVENTS) {
            boolean bl = (keyEventState.getModifiersEx() & 0x200) != 0;
            ViewInputAttributes.DeviceAttributes deviceAttributes = this.attributes.getDeviceAttributes("gov.nasa.worldwind.DeviceKeyboard");
            ViewInputAttributes.ActionAttributes actionAttributes = this.attributes.getActionAttributes("gov.nasa.worldwind.DeviceKeyboard", bl ? "gov.nasa.worldwind.ViewZoomSlow" : "gov.nasa.worldwind.ViewZoom");
            double d2 = this.rawInputToChangeInValue(d, deviceAttributes, actionAttributes, SCALE_FUNC_ZOOM);
            this.onZoomView(d2, actionAttributes);
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.wwd == null) {
            return;
        }
        if (propertyChangeEvent == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.View.ViewStopped") {
            this.handleViewStopped();
        } else if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.view.OrbitView.CenterStopped") {
            this.handleOrbitViewCenterStopped();
        }
    }

    protected void handleViewStopped() {
        this.orbitViewInputSupport.onViewStopped();
    }

    protected void handleOrbitViewCenterStopped() {
        this.orbitViewInputSupport.onViewCenterStopped();
    }

    protected double rawInputToChangeInValue(double d, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes, String string) {
        double d2 = d;
        double[] dArray = actionAttributes.getValues();
        d2 *= this.getScaledValue(dArray[0], dArray[1], string);
        return d2 *= deviceAttributes.getSensitivity();
    }

    protected double getScaledValue(double d, double d2, String string) {
        if (string == null) {
            return d;
        }
        double d3 = 0.0;
        if (string.startsWith(SCALE_FUNC_EYE_ALTITUDE)) {
            d3 = this.evaluateScaleFuncEyeAltitude();
        } else if (string.startsWith(SCALE_FUNC_ZOOM)) {
            d3 = this.evaluateScaleFuncZoom();
        }
        if (string.toLowerCase().endsWith("exp")) {
            d3 = Math.pow(2.0, d3) - 1.0;
        }
        return d * (1.0 - d3) + d2 * d3;
    }

    protected double evaluateScaleFuncEyeAltitude() {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        Position position = view.getEyePosition();
        double d = this.wwd.getModel().getGlobe().getRadius();
        double d2 = this.wwd.getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        double d3 = (position.getElevation() - d2) / (3.0 * d);
        return d3 < 0.0 ? 0.0 : (d3 > 1.0 ? 1.0 : d3);
    }

    protected double evaluateScaleFuncZoom() {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        double d = this.wwd.getModel().getGlobe().getRadius();
        double d2 = ((OrbitView)view).getZoom() / (3.0 * d);
        return d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
    }

    protected void setCenterPosition(OrbitView orbitView, Position position, ViewInputAttributes.ActionAttributes actionAttributes) {
        if (orbitView.hasStateIterator()) {
            orbitView.stopStateIterators();
        }
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        if (d != 0.0 && this.orbitViewInputSupport.getCenterTarget() != null) {
            Position position2 = this.orbitViewInputSupport.getCenterTarget();
            Position position3 = orbitView.getCenterPosition();
            position = new Position(position2.getLatitude().add(position.getLatitude()).subtract(position3.getLatitude()), position2.getLongitude().add(position.getLongitude()).subtract(position3.getLongitude()), position2.getElevation() + position.getElevation() - position3.getElevation());
        }
        this.orbitViewInputSupport.setCenterSmoothing(d);
        this.orbitViewInputSupport.setCenterTarget(orbitView, position);
        orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
    }

    protected void changeHeading(OrbitView orbitView, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        if (orbitView.hasStateIterator()) {
            orbitView.stopStateIterators();
        }
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        Angle angle2 = d != 0.0 && this.orbitViewInputSupport.getHeadingTarget() != null ? this.orbitViewInputSupport.getHeadingTarget().add(angle) : orbitView.getHeading().add(angle);
        this.orbitViewInputSupport.setHeadingSmoothing(d);
        this.orbitViewInputSupport.setHeadingTarget(orbitView, angle2);
        orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
    }

    protected void changePitch(OrbitView orbitView, Angle angle, ViewInputAttributes.ActionAttributes actionAttributes) {
        if (orbitView.hasStateIterator()) {
            orbitView.stopStateIterators();
        }
        double d = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d = 0.0;
        }
        Angle angle2 = d != 0.0 && this.orbitViewInputSupport.getPitchTarget() != null ? this.orbitViewInputSupport.getPitchTarget().add(angle) : orbitView.getPitch().add(angle);
        this.orbitViewInputSupport.setPitchSmoothing(d);
        this.orbitViewInputSupport.setPitchTarget(orbitView, angle2);
        orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
    }

    protected void changeZoom(OrbitView orbitView, double d, ViewInputAttributes.ActionAttributes actionAttributes) {
        if (orbitView.hasStateIterator()) {
            orbitView.stopStateIterators();
        }
        double d2 = actionAttributes.getSmoothingValue();
        if (!actionAttributes.isEnableSmoothing() || !this.isEnableSmoothing()) {
            d2 = 0.0;
        }
        double d3 = d2 != 0.0 && this.orbitViewInputSupport.getZoomTarget() >= 0.0 ? ViewInputHandler.computeNewZoomTarget(this.orbitViewInputSupport.getZoomTarget(), d) : ViewInputHandler.computeNewZoomTarget(orbitView.getZoom(), d);
        this.orbitViewInputSupport.setZoomSmoothing(d2);
        this.orbitViewInputSupport.setZoomTarget(orbitView, d3);
        orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, orbitView);
    }

    protected static double computeNewZoomTarget(double d, double d2) {
        double d3 = d != 0.0 ? Math.log(d) : 0.0;
        return Math.exp(d3 + d2);
    }
}

