/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.data.DataDescriptorReader;
import gov.nasa.worldwind.data.DataIORegistry;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFileStore
implements FileStore {
    protected final List<StoreLocation> readLocations = new ArrayList<StoreLocation>();
    protected StoreLocation writeLocation = null;
    private final Object fileLock = new Object();

    protected void initialize(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            this.buildWritePaths(document);
            this.buildReadPaths(document);
            if (this.writeLocation == null) {
                Logging.logger().warning("FileStore.NoWriteLocation");
            }
            if (this.readLocations.size() == 0) {
                String string = Logging.getMessage("FileStore.NoReadLocations");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, iOException);
        }
    }

    protected void buildReadPaths(Node node) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("/dataFileStore/readLocations/location", node.getFirstChild(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = xPath.evaluate("@property", node2);
                String string2 = xPath.evaluate("@wwDir", node2);
                String string3 = xPath.evaluate("@append", node2);
                String string4 = xPath.evaluate("@isInstall", node2);
                String string5 = xPath.evaluate("@isMarkWhenUsed", node2);
                String string6 = AbstractFileStore.buildLocationPath(string, string3, string2);
                if (string6 == null) {
                    Logging.logger().log(Level.WARNING, "FileStore.LocationInvalid", string != null ? string : Logging.getMessage("generic.Unknown"));
                    continue;
                }
                StoreLocation storeLocation = this.storeLocationFor(string6);
                if (storeLocation != null) continue;
                File file = new File(string6);
                if (file.exists() && !file.isDirectory()) {
                    Logging.logger().log(Level.WARNING, "FileStore.LocationIsFile", file.getPath());
                }
                boolean bl = string4 != null && (string4.contains("t") || string4.contains("T"));
                StoreLocation storeLocation2 = new StoreLocation(file, bl);
                if (string5 != null && string5.length() > 0) {
                    storeLocation2.setMarkWhenUsed(string5.toLowerCase().contains("t"));
                }
                this.readLocations.add(storeLocation2);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, xPathExpressionException);
        }
    }

    protected void buildWritePaths(Node node) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("/dataFileStore/writeLocations/location", node.getFirstChild(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = xPath.evaluate("@property", node2);
                String string2 = xPath.evaluate("@wwDir", node2);
                String string3 = xPath.evaluate("@append", node2);
                String string4 = xPath.evaluate("@create", node2);
                String string5 = AbstractFileStore.buildLocationPath(string, string3, string2);
                if (string5 == null) {
                    Logging.logger().log(Level.WARNING, "FileStore.LocationInvalid", string != null ? string : Logging.getMessage("generic.Unknown"));
                    continue;
                }
                Logging.logger().log(Level.FINER, "FileStore.AttemptingWriteDir", string5);
                File file = new File(string5);
                if (!file.exists() && string4 != null && (string4.contains("t") || string4.contains("T"))) {
                    Logging.logger().log(Level.FINER, "FileStore.MakingDirsFor", string5);
                    file.mkdirs();
                }
                if (!file.isDirectory() || !file.canWrite() || !file.canRead()) continue;
                Logging.logger().log(Level.FINER, "FileStore.WriteLocationSuccessful", string5);
                this.writeLocation = new StoreLocation(file);
                StoreLocation storeLocation = this.storeLocationFor(string5);
                if (storeLocation != null) {
                    this.readLocations.remove(storeLocation);
                }
                this.readLocations.add(0, this.writeLocation);
                break;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, xPathExpressionException);
        }
    }

    protected static String buildLocationPath(String string, String string2, String string3) {
        String string4 = AbstractFileStore.propertyToPath(string);
        if (string2 != null && string2.length() != 0) {
            string4 = AbstractFileStore.appendPathPart(string4, string2.trim());
        }
        if (string3 != null && string3.length() != 0) {
            string4 = AbstractFileStore.appendPathPart(string4, string3.trim());
        }
        return string4;
    }

    protected static String appendPathPart(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string == null || string2.length() == 0) {
            return string2;
        }
        string = WWIO.stripTrailingSeparator(string);
        string2 = WWIO.stripLeadingSeparator(string2);
        return string + System.getProperty("file.separator") + string2;
    }

    protected static String propertyToPath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (string.equalsIgnoreCase("gov.nasa.worldwind.platform.alluser.store")) {
            return AbstractFileStore.determineAllUserLocation();
        }
        if (string.equalsIgnoreCase("gov.nasa.worldwind.platform.user.store")) {
            return AbstractFileStore.determineSingleUserLocation();
        }
        return null;
    }

    protected static String determineAllUserLocation() {
        if (Configuration.isMacOS()) {
            return "/Library/Caches";
        }
        if (Configuration.isWindowsOS()) {
            String string = System.getenv("ALLUSERSPROFILE");
            if (string == null) {
                Logging.logger().severe("generic.AllUsersWindowsProfileNotKnown");
                return null;
            }
            return string + "\\Application Data";
        }
        if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            return "/var/cache/";
        }
        Logging.logger().warning("generic.UnknownOperatingSystem");
        return null;
    }

    protected static String determineSingleUserLocation() {
        String string = AbstractFileStore.getUserHomeDir();
        if (string == null) {
            Logging.logger().warning("generic.UsersHomeDirectoryNotKnown");
            return null;
        }
        String string2 = null;
        if (Configuration.isMacOS()) {
            string2 = "/Library/Caches";
        } else if (Configuration.isWindowsOS()) {
            string2 = "\\Application Data";
        } else if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            string2 = "/var/cache/";
        } else {
            Logging.logger().fine("generic.UnknownOperatingSystem");
        }
        if (string2 == null) {
            return null;
        }
        return string + string2;
    }

    protected static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    @Override
    public List<? extends File> getLocations() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (StoreLocation storeLocation : this.readLocations) {
            arrayList.add(storeLocation.getFile());
        }
        return arrayList;
    }

    @Override
    public File getWriteLocation() {
        return this.writeLocation != null ? this.writeLocation.getFile() : null;
    }

    @Override
    public void addLocation(String string, boolean bl) {
        this.addLocation(this.readLocations.size(), string, bl);
    }

    @Override
    public void addLocation(int n, String string, boolean bl) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (n < 0) {
            String string3 = Logging.getMessage("generic.InvalidIndex", n);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        StoreLocation storeLocation = this.storeLocationFor(string);
        if (storeLocation != null) {
            this.readLocations.remove(storeLocation);
        }
        if (n > 0 && n > this.readLocations.size()) {
            n = this.readLocations.size();
        }
        File file = new File(string);
        StoreLocation storeLocation2 = new StoreLocation(file, bl);
        this.readLocations.add(n, storeLocation2);
    }

    @Override
    public void removeLocation(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string2);
            return;
        }
        StoreLocation storeLocation = this.storeLocationFor(string);
        if (storeLocation == null) {
            return;
        }
        if (storeLocation.equals(this.writeLocation)) {
            String string3 = Logging.getMessage("FileStore.CannotRemoveWriteLocation", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.readLocations.remove(storeLocation);
    }

    @Override
    public boolean isInstallLocation(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        StoreLocation storeLocation = this.storeLocationFor(string);
        return storeLocation != null && storeLocation.isInstall();
    }

    protected StoreLocation storeLocationFor(String string) {
        File file = new File(string);
        for (StoreLocation storeLocation : this.readLocations) {
            if (!file.equals(storeLocation.getFile())) continue;
            return storeLocation;
        }
        return null;
    }

    @Override
    public boolean containsFile(String string) {
        if (string == null) {
            return false;
        }
        for (StoreLocation storeLocation : this.readLocations) {
            File file = storeLocation.getFile();
            File file2 = string.startsWith(file.getAbsolutePath()) ? new File(string) : AbstractFileStore.makeAbsoluteFile(file, string);
            if (!file2.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public URL findFile(String string, boolean bl) {
        Object object;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (bl && (object = this.getClass().getClassLoader().getResource(string)) != null) {
            return object;
        }
        for (StoreLocation storeLocation : this.readLocations) {
            File file;
            File file2 = storeLocation.getFile();
            if (!file2.exists() || !(file = new File(AbstractFileStore.makeAbsolutePath(file2, string))).exists()) continue;
            try {
                if (storeLocation.isMarkWhenUsed()) {
                    AbstractFileStore.markFileUsed(file);
                } else {
                    AbstractFileStore.markFileUsed(file.getParentFile());
                }
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("FileStore.ExceptionCreatingURLForFile", file.getPath()), malformedURLException);
            }
        }
        return null;
    }

    protected static void markFileUsed(File file) {
        if (file == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (file.canWrite()) {
            file.setLastModified(l);
        }
        if (file.isDirectory()) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 != null && file2.canWrite()) {
            file2.setLastModified(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File newFile(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.writeLocation != null) {
            String string3 = AbstractFileStore.makeAbsolutePath(this.writeLocation.getFile(), string);
            File file = new File(string3);
            boolean bl = false;
            Object object = this.fileLock;
            synchronized (object) {
                if (file.getParentFile().exists()) {
                    bl = true;
                } else if (file.getParentFile().mkdirs()) {
                    bl = true;
                }
            }
            if (bl) {
                return file;
            }
            object = Logging.getMessage("generic.CannotCreateFile", string3);
            Logging.logger().severe((String)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(URL uRL) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            File file = new File(uRL.toURI());
            Object object = this.fileLock;
            synchronized (object) {
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("FileStore.ExceptionRemovingFile", uRL.toString()), uRISyntaxException);
        }
    }

    protected static File makeAbsoluteFile(File file, String string) {
        return new File(file.getAbsolutePath() + "/" + string);
    }

    protected static String makeAbsolutePath(File file, String string) {
        return file.getAbsolutePath() + "/" + string;
    }

    protected static String storePathForFile(StoreLocation storeLocation, File file) {
        String string;
        String string2 = file.getPath();
        if (storeLocation != null && string2.startsWith(string = storeLocation.getFile().getPath())) {
            string2 = string2.substring(string.length(), string2.length());
        }
        return string2;
    }

    @Override
    public List<? extends DataDescriptor> findAllDataDescriptors() {
        ArrayList<DataDescriptor> arrayList = new ArrayList<DataDescriptor>();
        for (StoreLocation storeLocation : this.readLocations) {
            this.doFindDataDescriptors(storeLocation, storeLocation.getFile(), arrayList);
        }
        return arrayList;
    }

    @Override
    public List<? extends DataDescriptor> findDataDescriptors(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        ArrayList<DataDescriptor> arrayList = new ArrayList<DataDescriptor>();
        StoreLocation storeLocation = this.storeLocationFor(string);
        if (storeLocation != null) {
            this.doFindDataDescriptors(storeLocation, storeLocation.getFile(), arrayList);
        }
        return arrayList;
    }

    protected void doFindDataDescriptors(StoreLocation storeLocation, File file, List<DataDescriptor> list) {
        File[] fileArray;
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray2 = fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file != null && file.exists() && !file.isDirectory();
            }
        });
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file2 = fileArray2[i];
            if (!this.readDataDescriptor(storeLocation, file2, list)) continue;
            return;
        }
        for (File file3 : fileArray2 = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file != null && file.isDirectory();
            }
        })) {
            this.doFindDataDescriptors(storeLocation, file3, list);
        }
    }

    protected boolean readDataDescriptor(StoreLocation storeLocation, File file, List<DataDescriptor> list) {
        DataDescriptorReader dataDescriptorReader = null;
        DataDescriptor dataDescriptor = null;
        Iterable<? extends DataDescriptorReader> iterable = DataIORegistry.getInstance().createDataDescriptorReaders();
        for (DataDescriptorReader object : iterable) {
            try {
                object.setSource(file);
                if (!object.canRead()) continue;
                dataDescriptorReader = object;
                break;
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("generic.ExceptionWhileReading", file);
                Logging.logger().log(Level.SEVERE, string, iOException);
            }
        }
        if (dataDescriptorReader != null) {
            try {
                dataDescriptorReader.setSource(file);
                dataDescriptor = dataDescriptorReader.read();
            }
            catch (IOException iOException) {
                String malformedURLException = Logging.getMessage("generic.ExceptionWhileReading", file);
                Logging.logger().log(Level.SEVERE, malformedURLException, iOException);
            }
        }
        if (dataDescriptor != null) {
            String string = AbstractFileStore.storePathForFile(storeLocation, file.getParentFile());
            dataDescriptor.setFileStoreLocation(storeLocation.getFile());
            dataDescriptor.setFileStorePath(string);
            dataDescriptor.setInstalled(storeLocation.isInstall());
            try {
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.URL", file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("FileStore.ExceptionCreatingURLForFile", file.getPath()), malformedURLException);
            }
            list.add(dataDescriptor);
        }
        return dataDescriptor != null;
    }

    protected static class StoreLocation
    extends AVListImpl {
        protected boolean markWhenUsed = false;

        public StoreLocation(File file, boolean bl) {
            this.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", file);
            this.setValue("gov.nasa.worldwind.avkey.Installed", bl);
        }

        public StoreLocation(File file) {
            this(file, false);
        }

        public File getFile() {
            Object object = this.getValue("gov.nasa.worldwind.avkey.FileStoreLocation");
            return object != null && object instanceof File ? (File)object : null;
        }

        public void setFile(File file) {
            this.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", file);
        }

        public boolean isInstall() {
            Object object = this.getValue("gov.nasa.worldwind.avkey.Installed");
            return object != null && object instanceof Boolean ? (Boolean)object : false;
        }

        public void setInstall(boolean bl) {
            this.setValue("gov.nasa.worldwind.avkey.Installed", bl);
        }

        public boolean isMarkWhenUsed() {
            return this.markWhenUsed;
        }

        public void setMarkWhenUsed(boolean bl) {
            this.markWhenUsed = bl;
        }
    }
}

