/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicMemoryCache
implements MemoryCache {
    private ConcurrentHashMap<Object, CacheEntry> entries = new ConcurrentHashMap();
    private CopyOnWriteArrayList<MemoryCache.CacheListener> listeners = new CopyOnWriteArrayList();
    private Long capacityInBytes;
    private Long currentUsedCapacity;
    private Long lowWater;
    private String name = "";

    public BasicMemoryCache(long l, long l2) {
        this.capacityInBytes = l2;
        this.lowWater = l;
        this.currentUsedCapacity = 0L;
    }

    @Override
    public int getNumObjects() {
        return this.entries.size();
    }

    @Override
    public long getCapacity() {
        return this.capacityInBytes;
    }

    @Override
    public synchronized long getUsedCapacity() {
        return this.currentUsedCapacity;
    }

    @Override
    public synchronized long getFreeCapacity() {
        return this.capacityInBytes - this.currentUsedCapacity;
    }

    @Override
    public void setName(String string) {
        this.name = string != null ? string : "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void addCacheListener(MemoryCache.CacheListener cacheListener) {
        if (cacheListener == null) {
            String string = Logging.getMessage("BasicMemoryCache.nullListenerAdded");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        this.listeners.add(cacheListener);
    }

    @Override
    public synchronized void removeCacheListener(MemoryCache.CacheListener cacheListener) {
        if (cacheListener == null) {
            String string = Logging.getMessage("BasicMemoryCache.nullListenerRemoved");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        this.listeners.remove(cacheListener);
    }

    @Override
    public synchronized void setCapacity(long l) {
        this.capacityInBytes = l;
    }

    @Override
    public synchronized void setLowWater(long l) {
        if (l < this.capacityInBytes && l >= 0L) {
            this.lowWater = l;
        }
    }

    @Override
    public long getLowWater() {
        return this.lowWater;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.entries.containsKey(object);
    }

    @Override
    public synchronized boolean add(Object object, Object object2, long l) {
        if (object == null || object2 == null || l <= 0L || l > this.capacityInBytes) {
            Logging.logger().warning("BasicMemoryCache.CacheItemNotAdded");
            if (l > this.capacityInBytes) {
                Logging.logger().warning("BasicMemoryCache.ItemTooLargeForCache");
            }
            return false;
        }
        CacheEntry cacheEntry = this.entries.get(object);
        if (cacheEntry != null) {
            this.removeEntry(cacheEntry);
        }
        if (this.currentUsedCapacity + l > this.capacityInBytes) {
            this.makeSpace(l);
        }
        Object object3 = this;
        ((BasicMemoryCache)object3).currentUsedCapacity = ((BasicMemoryCache)object3).currentUsedCapacity + l;
        object3 = new CacheEntry(object, object2, l);
        this.entries.putIfAbsent(((CacheEntry)object3).key, (CacheEntry)object3);
        return true;
    }

    @Override
    public synchronized boolean add(Object object, Cacheable cacheable) {
        return this.add(object, cacheable, cacheable.getSizeInBytes());
    }

    @Override
    public synchronized void remove(Object object) {
        if (object == null) {
            Logging.logger().finer("nullValue.KeyIsNull");
            return;
        }
        CacheEntry cacheEntry = this.entries.get(object);
        if (cacheEntry != null) {
            this.removeEntry(cacheEntry);
        }
    }

    @Override
    public synchronized Object getObject(Object object) {
        if (object == null) {
            Logging.logger().finer("nullValue.KeyIsNull");
            return null;
        }
        CacheEntry cacheEntry = this.entries.get(object);
        if (cacheEntry == null) {
            return null;
        }
        cacheEntry.lastUsed = System.nanoTime();
        return cacheEntry.clientObject;
    }

    @Override
    public Set<Object> getKeySet() {
        return this.entries.keySet();
    }

    @Override
    public synchronized void clear() {
        for (CacheEntry cacheEntry : this.entries.values()) {
            this.removeEntry(cacheEntry);
        }
    }

    private synchronized void removeEntry(CacheEntry cacheEntry) {
        if (this.entries.remove(cacheEntry.key) != null) {
            BasicMemoryCache basicMemoryCache = this;
            basicMemoryCache.currentUsedCapacity = basicMemoryCache.currentUsedCapacity - cacheEntry.clientObjectSize;
            for (MemoryCache.CacheListener cacheListener : this.listeners) {
                cacheListener.entryRemoved(cacheEntry.key, cacheEntry.clientObject);
            }
        }
    }

    private void makeSpace(long l) {
        if (l > this.capacityInBytes || l < 0L) {
            return;
        }
        CacheEntry[] cacheEntryArray = new CacheEntry[this.entries.size()];
        Arrays.sort(this.entries.values().toArray(cacheEntryArray));
        int n = 0;
        while (this.getFreeCapacity() < l || this.getUsedCapacity() > this.lowWater) {
            if (n >= cacheEntryArray.length) continue;
            this.removeEntry(cacheEntryArray[n++]);
        }
    }

    public synchronized String toString() {
        return "MemoryCache " + this.name + " max size = " + this.getCapacity() + " current size = " + this.currentUsedCapacity + " number of items: " + this.getNumObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry
    implements Comparable<CacheEntry> {
        Object key;
        Object clientObject;
        private long lastUsed;
        private long clientObjectSize;

        CacheEntry(Object object, Object object2, long l) {
            this.key = object;
            this.clientObject = object2;
            this.lastUsed = System.nanoTime();
            this.clientObjectSize = l;
        }

        @Override
        public int compareTo(CacheEntry cacheEntry) {
            if (cacheEntry == null) {
                String string = Logging.getMessage("nullValue.CacheEntryIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.lastUsed < cacheEntry.lastUsed ? -1 : (this.lastUsed == cacheEntry.lastUsed ? 0 : 1);
        }

        public String toString() {
            return this.key.toString() + " " + this.clientObject.toString() + " " + this.lastUsed + " " + this.clientObjectSize;
        }
    }
}

