/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.cache.MemoryCacheSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMemoryCacheSet
implements MemoryCacheSet {
    private ConcurrentHashMap<String, MemoryCache> caches = new ConcurrentHashMap();

    @Override
    public synchronized boolean containsCache(String string) {
        return this.caches.containsKey(string);
    }

    @Override
    public synchronized MemoryCache getCache(String string) {
        MemoryCache memoryCache = this.caches.get(string);
        if (memoryCache == null) {
            String string2 = Logging.getMessage("MemoryCacheSet.CacheDoesNotExist", string);
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        return memoryCache;
    }

    @Override
    public Map<String, MemoryCache> getAllCaches() {
        return this.caches;
    }

    @Override
    public synchronized MemoryCache addCache(String string, MemoryCache memoryCache) {
        if (this.containsCache(string)) {
            String string2 = Logging.getMessage("MemoryCacheSet.CacheAlreadyExists");
            Logging.logger().fine(string2);
            throw new IllegalStateException(string2);
        }
        if (memoryCache == null) {
            String string3 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.caches.put(string, memoryCache);
        return memoryCache;
    }

    @Override
    public synchronized void clear() {
        for (MemoryCache memoryCache : this.caches.values()) {
            memoryCache.clear();
        }
    }

    @Override
    public Collection<PerformanceStatistic> getPerformanceStatistics() {
        ArrayList<PerformanceStatistic> arrayList = new ArrayList<PerformanceStatistic>();
        for (MemoryCache memoryCache : this.caches.values()) {
            arrayList.add(new PerformanceStatistic("gov.nasa.worldwind.perfstat.MemoryCache", "Cache Size (Kb): " + memoryCache.getName(), memoryCache.getUsedCapacity() / 1000L));
        }
        return arrayList;
    }
}

