/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import com.sun.opengl.util.texture.Texture;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.cache.TextureCache;
import javax.media.opengl.GLContext;

public class BasicTextureCache
implements TextureCache {
    private final BasicMemoryCache textures;

    public BasicTextureCache(long l, long l2) {
        this.textures = new BasicMemoryCache(l, l2);
        this.textures.setName("Texture Cache");
        this.textures.addCacheListener(new MemoryCache.CacheListener(){

            public void entryRemoved(Object object, Object object2) {
                if (GLContext.getCurrent() == null) {
                    return;
                }
                if (object2 != null) {
                    ((TextureEntry)object2).texture.dispose();
                }
            }
        });
    }

    public void put(Object object, Texture texture) {
        TextureEntry textureEntry = new TextureEntry(texture);
        this.textures.add(object, textureEntry);
    }

    public Texture get(Object object) {
        TextureEntry textureEntry = (TextureEntry)this.textures.getObject(object);
        return textureEntry != null ? textureEntry.texture : null;
    }

    public void remove(Object object) {
        this.textures.remove(object);
    }

    public int getNumObjects() {
        return this.textures.getNumObjects();
    }

    public long getCapacity() {
        return this.textures.getCapacity();
    }

    public long getUsedCapacity() {
        return this.textures.getUsedCapacity();
    }

    public long getFreeCapacity() {
        return this.textures.getFreeCapacity();
    }

    public boolean contains(Object object) {
        return this.textures.contains(object);
    }

    public void clear() {
        this.textures.clear();
    }

    public synchronized void setCapacity(long l) {
        this.textures.setCapacity(l);
    }

    public synchronized void setLowWater(long l) {
        this.textures.setLowWater(l);
    }

    public long getLowWater() {
        return this.textures.getLowWater();
    }

    public static class TextureEntry
    implements Cacheable {
        private final Texture texture;

        public TextureEntry(Texture texture) {
            this.texture = texture;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public long getSizeInBytes() {
            long l = this.texture.getEstimatedMemorySize();
            if (l < 1L) {
                l = this.texture.getHeight() * this.texture.getWidth() * 4;
            }
            return l;
        }
    }
}

