/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.data.DataDescriptorReader;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

public abstract class AbstractDataDescriptorReader
implements DataDescriptorReader {
    private Object source;

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public boolean canRead() throws IOException {
        Object object = this.getSource();
        if (object == null) {
            return false;
        }
        return this.doCanRead(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataDescriptor read() throws IOException {
        Object object = this.getSource();
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Reader reader = this.openReader(object);
        if (reader == null) {
            String string = Logging.getMessage("generic.CannotOpenInputStream", object);
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        DataDescriptor dataDescriptor = null;
        try {
            dataDescriptor = this.doRead(reader);
        }
        finally {
            reader.close();
        }
        return dataDescriptor;
    }

    protected Reader openReader(Object object) throws IOException {
        Reader reader = null;
        if (object instanceof Reader) {
            reader = (Reader)object;
        } else if (object instanceof InputStream) {
            reader = new InputStreamReader((InputStream)object);
        } else if (object instanceof File) {
            reader = new FileReader((File)object);
        } else if (object instanceof URL) {
            reader = new InputStreamReader(((URL)object).openStream());
        } else if (object instanceof String) {
            reader = new StringReader((String)object);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCanRead(Object object) throws IOException {
        Reader reader = this.openReader(object);
        if (reader == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = this.doCanReadStream(reader);
        }
        finally {
            reader.close();
        }
        return bl;
    }

    protected abstract boolean doCanReadStream(Reader var1) throws IOException;

    protected abstract DataDescriptor doRead(Reader var1) throws IOException;
}

