/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.data.DataDescriptorWriter;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class AbstractDataDescriptorWriter
implements DataDescriptorWriter {
    private Object destination;

    public Object getDestination() {
        return this.destination;
    }

    public void setDestination(Object object) {
        this.destination = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataDescriptor dataDescriptor) throws IOException {
        if (dataDescriptor == null) {
            String string = Logging.getMessage("nullValue.DataDescriptorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = this.getDestination();
        if (object == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Writer writer = this.openWriter(object);
        if (writer == null) {
            String string = Logging.getMessage("generic.CannotOpenOutputStream", object);
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        try {
            this.doWrite(writer, dataDescriptor);
        }
        finally {
            writer.close();
        }
    }

    protected Writer openWriter(Object object) throws IOException {
        Writer writer = null;
        if (object instanceof Writer) {
            writer = (Writer)object;
        } else if (object instanceof OutputStream) {
            writer = new OutputStreamWriter((OutputStream)object);
        } else if (object instanceof File) {
            writer = new FileWriter((File)object);
        }
        return writer;
    }

    protected abstract void doWrite(Writer var1, DataDescriptor var2) throws IOException;
}

