/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterWriter;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;

public abstract class AbstractDataRasterWriter
implements DataRasterWriter {
    private final String[] mimeTypes;
    private final String[] suffixes;

    public AbstractDataRasterWriter(String[] stringArray, String[] stringArray2) {
        this.mimeTypes = AbstractDataRasterWriter.copyOf(stringArray);
        this.suffixes = AbstractDataRasterWriter.copyOf(stringArray2);
    }

    public String[] getMimeTypes() {
        String[] stringArray = new String[this.mimeTypes.length];
        System.arraycopy(this.mimeTypes, 0, stringArray, 0, this.mimeTypes.length);
        return stringArray;
    }

    public String[] getSuffixes() {
        String[] stringArray = new String[this.suffixes.length];
        System.arraycopy(this.suffixes, 0, stringArray, 0, this.suffixes.length);
        return stringArray;
    }

    public boolean canWrite(DataRaster dataRaster, String string, File file) {
        if (string == null) {
            return false;
        }
        string = AbstractDataRasterWriter.stripLeadingPeriod(string);
        boolean bl = false;
        for (String string2 : this.suffixes) {
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        return this.doCanWrite(dataRaster, string, file);
    }

    public void write(DataRaster dataRaster, String string, File file) throws IOException {
        if (dataRaster == null) {
            String string2 = Logging.getMessage("nullValue.RasterIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FormatSuffixIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (!this.canWrite(dataRaster, string = AbstractDataRasterWriter.stripLeadingPeriod(string), file)) {
            String string4 = Logging.getMessage("DataRaster.CannotWrite", dataRaster, string, file);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.doWrite(dataRaster, string, file);
    }

    protected abstract boolean doCanWrite(DataRaster var1, String var2, File var3);

    protected abstract void doWrite(DataRaster var1, String var2, File var3) throws IOException;

    private static String[] copyOf(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].toLowerCase();
        }
        return stringArray2;
    }

    private static String stripLeadingPeriod(String string) {
        if (string.startsWith(".")) {
            return string.substring(Math.min(1, string.length()), string.length());
        }
        return string;
    }
}

