/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.util.Logging;
import java.io.File;

public class BasicDataDescriptor
extends WWObjectImpl
implements DataDescriptor {
    private File fileStoreLocation;

    public BasicDataDescriptor(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setValues(aVList);
    }

    public BasicDataDescriptor() {
    }

    public File getFileStoreLocation() {
        return this.fileStoreLocation;
    }

    public void setFileStoreLocation(File file) {
        this.fileStoreLocation = file;
    }

    public String getFileStorePath() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey");
    }

    public void setFileStorePath(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string);
    }

    public boolean isInstalled() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.Installed");
        return object != null && object instanceof Boolean && (Boolean)object != false;
    }

    public void setInstalled(boolean bl) {
        this.setValue("gov.nasa.worldwind.avkey.Installed", bl);
    }

    public String getName() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey");
    }

    public void setName(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
    }

    public String getType() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DataType");
    }

    public void setType(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DataType", string);
    }
}

