/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.AbstractDataDescriptorReader;
import gov.nasa.worldwind.data.BasicDataDescriptor;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;

public class BasicDataDescriptorReader
extends AbstractDataDescriptorReader {
    public static final String MIME_TYPE = "text/xml";
    public static final String VERSION = "1";
    private static final String DOCUMENT_ELEMENT_TAG_NAME = "dataDescriptor";
    private static final String PROPERTY_TAG_NAME = "property";

    public String getMimeType() {
        return MIME_TYPE;
    }

    public boolean matchesMimeType(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(this.getMimeType());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("DataDescriptor.BasicDataDescriptor.Name"));
        stringBuilder.append("(*").append(WWIO.makeSuffixForMimeType(this.getMimeType())).append(")");
        return stringBuilder.toString();
    }

    protected boolean doCanRead(Object object) throws IOException {
        String string = null;
        if (object instanceof File) {
            string = ((File)object).getPath();
        } else if (object instanceof URL) {
            string = ((URL)object).toExternalForm();
        }
        String string2 = WWIO.makeSuffixForMimeType(this.getMimeType());
        if (string != null && !string.toLowerCase().endsWith(string2)) {
            return false;
        }
        return super.doCanRead(object);
    }

    protected boolean doCanReadStream(Reader reader) throws IOException {
        RestorableSupport restorableSupport;
        try {
            restorableSupport = this.parseDocument(reader);
        }
        catch (Exception exception) {
            restorableSupport = null;
        }
        if (restorableSupport == null) {
            return false;
        }
        String string = this.validate(restorableSupport);
        return string == null;
    }

    protected DataDescriptor doRead(Reader reader) throws IOException {
        RestorableSupport.StateObject[] stateObjectArray;
        RestorableSupport restorableSupport = this.parseDocument(reader);
        String string = this.validate(restorableSupport);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BasicDataDescriptor basicDataDescriptor = new BasicDataDescriptor();
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("dataSet");
        if (stateObject != null && (stateObjectArray = restorableSupport.getAllStateObjects(stateObject)) != null) {
            for (RestorableSupport.StateObject stateObject2 : stateObjectArray) {
                if (stateObject2 == null) continue;
                String string2 = stateObject2.getName();
                Object object = this.parseStateValue(restorableSupport, stateObject2);
                string2 = this.parseStateKey(string2);
                basicDataDescriptor.setValue(string2, object);
            }
        }
        return basicDataDescriptor;
    }

    protected RestorableSupport parseDocument(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 4096;
        char[] cArray = new char[n2];
        while ((n = reader.read(cArray, 0, n2)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        RestorableSupport restorableSupport = RestorableSupport.parse(stringBuilder.toString());
        restorableSupport.setStateObjectTagName(PROPERTY_TAG_NAME);
        return restorableSupport;
    }

    protected String parseStateKey(String string) {
        if ("gov.nasa.worldwind.avkey.MissingDataValue".equals(string)) {
            return "gov.nasa.worldwind.avkey.MissingDataFlag";
        }
        return string;
    }

    protected Object parseStateValue(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string = stateObject.getName();
        if ("gov.nasa.worldwind.avkey.NumEmptyLevels".equals(string) || "gov.nasa.worldwind.avkey.NumLevels".equals(string) || "gov.nasa.worldwind.avkey.TileWidthKey".equals(string) || "gov.nasa.worldwind.avkey.TileHeightKey".equals(string)) {
            return restorableSupport.getStateObjectAsInteger(stateObject);
        }
        if ("gov.nasa.worldwind.avkey.MissingDataValue".equals(string)) {
            return restorableSupport.getStateObjectAsDouble(stateObject);
        }
        if ("gov.nasa.worldwind.avkey.LevelZeroTileDelta".equals(string) || "gov.nasa.worldwind.avkey.TileDeltaKey".equals(string) || "gov.nasa.worldwind.avkey.TileOrigin".equals(string)) {
            return restorableSupport.getStateObjectAsLatLon(stateObject);
        }
        if ("gov.nasa.worldwind.avKey.Sector".equals(string)) {
            return restorableSupport.getStateObjectAsSector(stateObject);
        }
        return stateObject.getValue();
    }

    protected String validate(RestorableSupport restorableSupport) {
        String string = restorableSupport.getDocumentElementTagName();
        if (!DOCUMENT_ELEMENT_TAG_NAME.equals(string)) {
            return Logging.getMessage("generic.CannotParseInputStream");
        }
        string = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.Version");
        if (!VERSION.equals(string)) {
            return Logging.getMessage("generic.CannotParseInputStream");
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("dataSet");
        if (stateObject == null) {
            return Logging.getMessage("generic.CannotParseInputStream");
        }
        string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DatasetNameKey");
        if (string == null) {
            return Logging.getMessage("generic.CannotParseInputStream");
        }
        string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DataType");
        if (string == null) {
            return Logging.getMessage("generic.CannotParseInputStream");
        }
        return null;
    }
}

