/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.AbstractDataDescriptorWriter;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class BasicDataDescriptorWriter
extends AbstractDataDescriptorWriter {
    public static final String MIME_TYPE = "text/xml";
    public static final String VERSION = "1";
    private static final String DOCUMENT_ELEMENT_TAG_NAME = "dataDescriptor";
    private static final String PROPERTY_TAG_NAME = "property";

    public String getMimeType() {
        return MIME_TYPE;
    }

    public boolean matchesMimeType(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(this.getMimeType());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("DataDescriptor.BasicDataDescriptor.Name"));
        stringBuilder.append("(*").append(WWIO.makeSuffixForMimeType(this.getMimeType())).append(")");
        return stringBuilder.toString();
    }

    protected void doWrite(Writer writer, DataDescriptor dataDescriptor) throws IOException {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport(DOCUMENT_ELEMENT_TAG_NAME);
        restorableSupport.setStateObjectTagName(PROPERTY_TAG_NAME);
        restorableSupport.addStateValueAsString("gov.nasa.worldwind.avkey.Version", VERSION);
        RestorableSupport.StateObject stateObject = restorableSupport.addStateObject("dataSet");
        for (Map.Entry<String, Object> entry : dataDescriptor.getEntries()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if ("gov.nasa.worldwind.avkey.FileStoreLocation".equals(string) || "gov.nasa.worldwind.avkey.DataCacheNameKey".equals(string)) continue;
            if (object instanceof Integer) {
                restorableSupport.addStateValueAsInteger(stateObject, string, (Integer)object);
                continue;
            }
            if (object instanceof Double) {
                restorableSupport.addStateValueAsDouble(stateObject, string, (Double)object);
                continue;
            }
            if (object instanceof Boolean) {
                restorableSupport.addStateValueAsBoolean(stateObject, string, (Boolean)object);
                continue;
            }
            if (object instanceof Position) {
                restorableSupport.addStateValueAsPosition(stateObject, string, (Position)object);
                continue;
            }
            if (object instanceof LatLon) {
                restorableSupport.addStateValueAsLatLon(stateObject, string, (LatLon)object);
                continue;
            }
            if (object instanceof Sector) {
                restorableSupport.addStateValueAsSector(stateObject, string, (Sector)object);
                continue;
            }
            if (object instanceof Color) {
                restorableSupport.addStateValueAsColor(stateObject, string, (Color)object);
                continue;
            }
            restorableSupport.addStateValueAsString(stateObject, string, object.toString());
        }
        String string = restorableSupport.getStateAsXml();
        writer.write(string);
        writer.flush();
    }
}

