/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;

public class ByteBufferRaster
extends BufferWrapperRaster {
    private ByteBuffer byteBuffer;

    public ByteBufferRaster(int n, int n2, Sector sector, ByteBuffer byteBuffer, AVList aVList) {
        super(n, n2, sector, BufferWrapper.wrap(byteBuffer, aVList));
        this.byteBuffer = byteBuffer;
    }

    public ByteBufferRaster(int n, int n2, Sector sector, AVList aVList) {
        this(n, n2, sector, ByteBufferRaster.createCompatibleBuffer(n, n2, aVList), aVList);
    }

    public static ByteBuffer createCompatibleBuffer(int n, int n2, AVList aVList) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.DataType");
        int n3 = 0;
        if ("gov.nasa.worldwind.avkey.Int8".equals(object)) {
            n3 = 1;
        } else if ("gov.nasa.worldwind.avkey.Int16".equals(object)) {
            n3 = 2;
        } else if ("gov.nasa.worldwind.avkey.Int32".equals(object)) {
            n3 = 4;
        } else if ("gov.nasa.worldwind.avkey.Float32".equals(object)) {
            n3 = 4;
        }
        int n4 = n3 * n * n2;
        return ByteBuffer.allocate(n4);
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }
}

